/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.VersionLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComposeEnvironmentsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, ComposeEnvironmentsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(ComposeEnvironmentsRequest.getter(ComposeEnvironmentsRequest::applicationName)).setter(ComposeEnvironmentsRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(ComposeEnvironmentsRequest.getter(ComposeEnvironmentsRequest::groupName)).setter(ComposeEnvironmentsRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<List<String>> VERSION_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VersionLabels").getter(ComposeEnvironmentsRequest.getter(ComposeEnvironmentsRequest::versionLabels)).setter(ComposeEnvironmentsRequest.setter(Builder::versionLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, GROUP_NAME_FIELD, VERSION_LABELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComposeEnvironmentsRequest.memberNameToFieldInitializer();
    private final String applicationName;
    private final String groupName;
    private final List<String> versionLabels;

    private ComposeEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.groupName = builder.groupName;
        this.versionLabels = builder.versionLabels;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final boolean hasVersionLabels() {
        return this.versionLabels != null && !(this.versionLabels instanceof SdkAutoConstructList);
    }

    public final List<String> versionLabels() {
        return this.versionLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersionLabels() ? this.versionLabels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComposeEnvironmentsRequest)) {
            return false;
        }
        ComposeEnvironmentsRequest other = (ComposeEnvironmentsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.groupName(), other.groupName()) && this.hasVersionLabels() == other.hasVersionLabels() && Objects.equals(this.versionLabels(), other.versionLabels());
    }

    public final String toString() {
        return ToString.builder((String)"ComposeEnvironmentsRequest").add("ApplicationName", (Object)this.applicationName()).add("GroupName", (Object)this.groupName()).add("VersionLabels", this.hasVersionLabels() ? this.versionLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "VersionLabels": {
                return Optional.ofNullable(clazz.cast(this.versionLabels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("VersionLabels", VERSION_LABELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComposeEnvironmentsRequest, T> g) {
        return obj -> g.apply((ComposeEnvironmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String groupName;
        private List<String> versionLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComposeEnvironmentsRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.groupName(model.groupName);
            this.versionLabels(model.versionLabels);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final Collection<String> getVersionLabels() {
            if (this.versionLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.versionLabels;
        }

        public final void setVersionLabels(Collection<String> versionLabels) {
            this.versionLabels = VersionLabelsCopier.copy(versionLabels);
        }

        @Override
        public final Builder versionLabels(Collection<String> versionLabels) {
            this.versionLabels = VersionLabelsCopier.copy(versionLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionLabels(String ... versionLabels) {
            this.versionLabels(Arrays.asList(versionLabels));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ComposeEnvironmentsRequest build() {
            return new ComposeEnvironmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ComposeEnvironmentsRequest> {
        public Builder applicationName(String var1);

        public Builder groupName(String var1);

        public Builder versionLabels(Collection<String> var1);

        public Builder versionLabels(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

