/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptionSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptionSpecification> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(OptionSpecification.getter(OptionSpecification::resourceName)).setter(OptionSpecification.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(OptionSpecification.getter(OptionSpecification::namespace)).setter(OptionSpecification.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> OPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionName").getter(OptionSpecification.getter(OptionSpecification::optionName)).setter(OptionSpecification.setter(Builder::optionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD, NAMESPACE_FIELD, OPTION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptionSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceName;
    private final String namespace;
    private final String optionName;

    private OptionSpecification(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.namespace = builder.namespace;
        this.optionName = builder.optionName;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String optionName() {
        return this.optionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionSpecification)) {
            return false;
        }
        OptionSpecification other = (OptionSpecification)obj;
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.optionName(), other.optionName());
    }

    public final String toString() {
        return ToString.builder((String)"OptionSpecification").add("ResourceName", (Object)this.resourceName()).add("Namespace", (Object)this.namespace()).add("OptionName", (Object)this.optionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "OptionName": {
                return Optional.ofNullable(clazz.cast(this.optionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("OptionName", OPTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptionSpecification, T> g) {
        return obj -> g.apply((OptionSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private String namespace;
        private String optionName;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionSpecification model) {
            this.resourceName(model.resourceName);
            this.namespace(model.namespace);
            this.optionName(model.optionName);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getOptionName() {
            return this.optionName;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public OptionSpecification build() {
            return new OptionSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptionSpecification> {
        public Builder resourceName(String var1);

        public Builder namespace(String var1);

        public Builder optionName(String var1);
    }
}

