/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BuildConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BuildConfiguration> {
    private static final SdkField<String> ARTIFACT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactName").getter(BuildConfiguration.getter(BuildConfiguration::artifactName)).setter(BuildConfiguration.setter(Builder::artifactName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactName").build()}).build();
    private static final SdkField<String> CODE_BUILD_SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeBuildServiceRole").getter(BuildConfiguration.getter(BuildConfiguration::codeBuildServiceRole)).setter(BuildConfiguration.setter(Builder::codeBuildServiceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeBuildServiceRole").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeType").getter(BuildConfiguration.getter(BuildConfiguration::computeTypeAsString)).setter(BuildConfiguration.setter(Builder::computeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Image").getter(BuildConfiguration.getter(BuildConfiguration::image)).setter(BuildConfiguration.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutInMinutes").getter(BuildConfiguration.getter(BuildConfiguration::timeoutInMinutes)).setter(BuildConfiguration.setter(Builder::timeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_NAME_FIELD, CODE_BUILD_SERVICE_ROLE_FIELD, COMPUTE_TYPE_FIELD, IMAGE_FIELD, TIMEOUT_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BuildConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String artifactName;
    private final String codeBuildServiceRole;
    private final String computeType;
    private final String image;
    private final Integer timeoutInMinutes;

    private BuildConfiguration(BuilderImpl builder) {
        this.artifactName = builder.artifactName;
        this.codeBuildServiceRole = builder.codeBuildServiceRole;
        this.computeType = builder.computeType;
        this.image = builder.image;
        this.timeoutInMinutes = builder.timeoutInMinutes;
    }

    public final String artifactName() {
        return this.artifactName;
    }

    public final String codeBuildServiceRole() {
        return this.codeBuildServiceRole;
    }

    public final ComputeType computeType() {
        return ComputeType.fromValue(this.computeType);
    }

    public final String computeTypeAsString() {
        return this.computeType;
    }

    public final String image() {
        return this.image;
    }

    public final Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactName());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeBuildServiceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildConfiguration)) {
            return false;
        }
        BuildConfiguration other = (BuildConfiguration)obj;
        return Objects.equals(this.artifactName(), other.artifactName()) && Objects.equals(this.codeBuildServiceRole(), other.codeBuildServiceRole()) && Objects.equals(this.computeTypeAsString(), other.computeTypeAsString()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"BuildConfiguration").add("ArtifactName", (Object)this.artifactName()).add("CodeBuildServiceRole", (Object)this.codeBuildServiceRole()).add("ComputeType", (Object)this.computeTypeAsString()).add("Image", (Object)this.image()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArtifactName": {
                return Optional.ofNullable(clazz.cast(this.artifactName()));
            }
            case "CodeBuildServiceRole": {
                return Optional.ofNullable(clazz.cast(this.codeBuildServiceRole()));
            }
            case "ComputeType": {
                return Optional.ofNullable(clazz.cast(this.computeTypeAsString()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "TimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArtifactName", ARTIFACT_NAME_FIELD);
        map.put("CodeBuildServiceRole", CODE_BUILD_SERVICE_ROLE_FIELD);
        map.put("ComputeType", COMPUTE_TYPE_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("TimeoutInMinutes", TIMEOUT_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BuildConfiguration, T> g) {
        return obj -> g.apply((BuildConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String artifactName;
        private String codeBuildServiceRole;
        private String computeType;
        private String image;
        private Integer timeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildConfiguration model) {
            this.artifactName(model.artifactName);
            this.codeBuildServiceRole(model.codeBuildServiceRole);
            this.computeType(model.computeType);
            this.image(model.image);
            this.timeoutInMinutes(model.timeoutInMinutes);
        }

        public final String getArtifactName() {
            return this.artifactName;
        }

        public final void setArtifactName(String artifactName) {
            this.artifactName = artifactName;
        }

        @Override
        public final Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public final String getCodeBuildServiceRole() {
            return this.codeBuildServiceRole;
        }

        public final void setCodeBuildServiceRole(String codeBuildServiceRole) {
            this.codeBuildServiceRole = codeBuildServiceRole;
        }

        @Override
        public final Builder codeBuildServiceRole(String codeBuildServiceRole) {
            this.codeBuildServiceRole = codeBuildServiceRole;
            return this;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public BuildConfiguration build() {
            return new BuildConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BuildConfiguration> {
        public Builder artifactName(String var1);

        public Builder codeBuildServiceRole(String var1);

        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder image(String var1);

        public Builder timeoutInMinutes(Integer var1);
    }
}

