/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Listener
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Listener> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(Listener.getter(Listener::protocol)).setter(Listener.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(Listener.getter(Listener::port)).setter(Listener.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, PORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Listener.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final Integer port;

    private Listener(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.port = builder.port;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final Integer port() {
        return this.port;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)obj;
        return Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.port(), other.port());
    }

    public final String toString() {
        return ToString.builder((String)"Listener").add("Protocol", (Object)this.protocol()).add("Port", (Object)this.port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Port", PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Listener, T> g) {
        return obj -> g.apply((Listener)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            this.protocol(model.protocol);
            this.port(model.port);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Listener build() {
            return new Listener(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Listener> {
        public Builder protocol(String var1);

        public Builder port(Integer var1);
    }
}

