/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * See the example below to learn how to create a request body.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentHealthRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<DescribeEnvironmentHealthRequest.Builder, DescribeEnvironmentHealthRequest> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(DescribeEnvironmentHealthRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(DescribeEnvironmentHealthRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributeNames")
            .getter(getter(DescribeEnvironmentHealthRequest::attributeNamesAsStrings))
            .setter(setter(Builder::attributeNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD,
            ENVIRONMENT_ID_FIELD, ATTRIBUTE_NAMES_FIELD));

    private final String environmentName;

    private final String environmentId;

    private final List<String> attributeNames;

    private DescribeEnvironmentHealthRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.attributeNames = builder.attributeNames;
    }

    /**
     * <p>
     * Specify the environment by name.
     * </p>
     * <p>
     * You must specify either this or an EnvironmentName, or both.
     * </p>
     * 
     * @return Specify the environment by name.</p>
     *         <p>
     *         You must specify either this or an EnvironmentName, or both.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * Specify the environment by ID.
     * </p>
     * <p>
     * You must specify either this or an EnvironmentName, or both.
     * </p>
     * 
     * @return Specify the environment by ID.</p>
     *         <p>
     *         You must specify either this or an EnvironmentName, or both.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute
     * names are specified, returns the name of the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeNames} method.
     * </p>
     * 
     * @return Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no
     *         attribute names are specified, returns the name of the environment.
     */
    public final List<EnvironmentHealthAttribute> attributeNames() {
        return EnvironmentHealthAttributesCopier.copyStringToEnum(attributeNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeNames() {
        return attributeNames != null && !(attributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute
     * names are specified, returns the name of the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeNames} method.
     * </p>
     * 
     * @return Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no
     *         attribute names are specified, returns the name of the environment.
     */
    public final List<String> attributeNamesAsStrings() {
        return attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeNames() ? attributeNamesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentHealthRequest)) {
            return false;
        }
        DescribeEnvironmentHealthRequest other = (DescribeEnvironmentHealthRequest) obj;
        return Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(environmentId(), other.environmentId()) && hasAttributeNames() == other.hasAttributeNames()
                && Objects.equals(attributeNamesAsStrings(), other.attributeNamesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEnvironmentHealthRequest").add("EnvironmentName", environmentName())
                .add("EnvironmentId", environmentId())
                .add("AttributeNames", hasAttributeNames() ? attributeNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "AttributeNames":
            return Optional.ofNullable(clazz.cast(attributeNamesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentHealthRequest, T> g) {
        return obj -> g.apply((DescribeEnvironmentHealthRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEnvironmentHealthRequest> {
        /**
         * <p>
         * Specify the environment by name.
         * </p>
         * <p>
         * You must specify either this or an EnvironmentName, or both.
         * </p>
         * 
         * @param environmentName
         *        Specify the environment by name.</p>
         *        <p>
         *        You must specify either this or an EnvironmentName, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * Specify the environment by ID.
         * </p>
         * <p>
         * You must specify either this or an EnvironmentName, or both.
         * </p>
         * 
         * @param environmentId
         *        Specify the environment by ID.</p>
         *        <p>
         *        You must specify either this or an EnvironmentName, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute
         * names are specified, returns the name of the environment.
         * </p>
         * 
         * @param attributeNames
         *        Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no
         *        attribute names are specified, returns the name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNamesWithStrings(Collection<String> attributeNames);

        /**
         * <p>
         * Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute
         * names are specified, returns the name of the environment.
         * </p>
         * 
         * @param attributeNames
         *        Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no
         *        attribute names are specified, returns the name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNamesWithStrings(String... attributeNames);

        /**
         * <p>
         * Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute
         * names are specified, returns the name of the environment.
         * </p>
         * 
         * @param attributeNames
         *        Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no
         *        attribute names are specified, returns the name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(Collection<EnvironmentHealthAttribute> attributeNames);

        /**
         * <p>
         * Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no attribute
         * names are specified, returns the name of the environment.
         * </p>
         * 
         * @param attributeNames
         *        Specify the response elements to return. To retrieve all attributes, set to <code>All</code>. If no
         *        attribute names are specified, returns the name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(EnvironmentHealthAttribute... attributeNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String environmentName;

        private String environmentId;

        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentHealthRequest model) {
            super(model);
            environmentName(model.environmentName);
            environmentId(model.environmentId);
            attributeNamesWithStrings(model.attributeNames);
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = EnvironmentHealthAttributesCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNamesWithStrings(Collection<String> attributeNames) {
            this.attributeNames = EnvironmentHealthAttributesCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNamesWithStrings(String... attributeNames) {
            attributeNamesWithStrings(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public final Builder attributeNames(Collection<EnvironmentHealthAttribute> attributeNames) {
            this.attributeNames = EnvironmentHealthAttributesCopier.copyEnumToString(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(EnvironmentHealthAttribute... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentHealthRequest build() {
            return new DescribeEnvironmentHealthRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
