/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;
import software.amazon.awssdk.services.elasticbeanstalk.model.TagKeyListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTagsForResourceRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, UpdateTagsForResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(UpdateTagsForResourceRequest.getter(UpdateTagsForResourceRequest::resourceArn)).setter(UpdateTagsForResourceRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagsToAdd").getter(UpdateTagsForResourceRequest.getter(UpdateTagsForResourceRequest::tagsToAdd)).setter(UpdateTagsForResourceRequest.setter(Builder::tagsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAGS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagsToRemove").getter(UpdateTagsForResourceRequest.getter(UpdateTagsForResourceRequest::tagsToRemove)).setter(UpdateTagsForResourceRequest.setter(Builder::tagsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, TAGS_TO_ADD_FIELD, TAGS_TO_REMOVE_FIELD));
    private final String resourceArn;
    private final List<Tag> tagsToAdd;
    private final List<String> tagsToRemove;

    private UpdateTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.tagsToAdd = builder.tagsToAdd;
        this.tagsToRemove = builder.tagsToRemove;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasTagsToAdd() {
        return this.tagsToAdd != null && !(this.tagsToAdd instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagsToAdd() {
        return this.tagsToAdd;
    }

    public final boolean hasTagsToRemove() {
        return this.tagsToRemove != null && !(this.tagsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> tagsToRemove() {
        return this.tagsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagsToAdd() ? this.tagsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagsToRemove() ? this.tagsToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagsForResourceRequest)) {
            return false;
        }
        UpdateTagsForResourceRequest other = (UpdateTagsForResourceRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasTagsToAdd() == other.hasTagsToAdd() && Objects.equals(this.tagsToAdd(), other.tagsToAdd()) && this.hasTagsToRemove() == other.hasTagsToRemove() && Objects.equals(this.tagsToRemove(), other.tagsToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTagsForResourceRequest").add("ResourceArn", (Object)this.resourceArn()).add("TagsToAdd", this.hasTagsToAdd() ? this.tagsToAdd() : null).add("TagsToRemove", this.hasTagsToRemove() ? this.tagsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "TagsToAdd": {
                return Optional.ofNullable(clazz.cast(this.tagsToAdd()));
            }
            case "TagsToRemove": {
                return Optional.ofNullable(clazz.cast(this.tagsToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTagsForResourceRequest, T> g) {
        return obj -> g.apply((UpdateTagsForResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<Tag> tagsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> tagsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTagsForResourceRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.tagsToAdd(model.tagsToAdd);
            this.tagsToRemove(model.tagsToRemove);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<Tag.Builder> getTagsToAdd() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagsToAdd(Collection<Tag.BuilderImpl> tagsToAdd) {
            this.tagsToAdd = TagListCopier.copyFromBuilder(tagsToAdd);
        }

        @Override
        @Transient
        public final Builder tagsToAdd(Collection<Tag> tagsToAdd) {
            this.tagsToAdd = TagListCopier.copy(tagsToAdd);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagsToAdd(Tag ... tagsToAdd) {
            this.tagsToAdd(Arrays.asList(tagsToAdd));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagsToAdd(Consumer<Tag.Builder> ... tagsToAdd) {
            this.tagsToAdd(Stream.of(tagsToAdd).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTagsToRemove() {
            if (this.tagsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagsToRemove;
        }

        public final void setTagsToRemove(Collection<String> tagsToRemove) {
            this.tagsToRemove = TagKeyListCopier.copy(tagsToRemove);
        }

        @Override
        @Transient
        public final Builder tagsToRemove(Collection<String> tagsToRemove) {
            this.tagsToRemove = TagKeyListCopier.copy(tagsToRemove);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagsToRemove(String ... tagsToRemove) {
            this.tagsToRemove(Arrays.asList(tagsToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTagsForResourceRequest build() {
            return new UpdateTagsForResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTagsForResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder tagsToAdd(Collection<Tag> var1);

        public Builder tagsToAdd(Tag ... var1);

        public Builder tagsToAdd(Consumer<Tag.Builder> ... var1);

        public Builder tagsToRemove(Collection<String> var1);

        public Builder tagsToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

