/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedAddonListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedTierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlatformSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlatformSummary> {
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformArn").getter(PlatformSummary.getter(PlatformSummary::platformArn)).setter(PlatformSummary.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<String> PLATFORM_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformOwner").getter(PlatformSummary.getter(PlatformSummary::platformOwner)).setter(PlatformSummary.setter(Builder::platformOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformOwner").build()}).build();
    private static final SdkField<String> PLATFORM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformStatus").getter(PlatformSummary.getter(PlatformSummary::platformStatusAsString)).setter(PlatformSummary.setter(Builder::platformStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformStatus").build()}).build();
    private static final SdkField<String> PLATFORM_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformCategory").getter(PlatformSummary.getter(PlatformSummary::platformCategory)).setter(PlatformSummary.setter(Builder::platformCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformCategory").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystemName").getter(PlatformSummary.getter(PlatformSummary::operatingSystemName)).setter(PlatformSummary.setter(Builder::operatingSystemName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemName").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystemVersion").getter(PlatformSummary.getter(PlatformSummary::operatingSystemVersion)).setter(PlatformSummary.setter(Builder::operatingSystemVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemVersion").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_TIER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedTierList").getter(PlatformSummary.getter(PlatformSummary::supportedTierList)).setter(PlatformSummary.setter(Builder::supportedTierList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTierList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ADDON_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedAddonList").getter(PlatformSummary.getter(PlatformSummary::supportedAddonList)).setter(PlatformSummary.setter(Builder::supportedAddonList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAddonList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_LIFECYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformLifecycleState").getter(PlatformSummary.getter(PlatformSummary::platformLifecycleState)).setter(PlatformSummary.setter(Builder::platformLifecycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformLifecycleState").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformVersion").getter(PlatformSummary.getter(PlatformSummary::platformVersion)).setter(PlatformSummary.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> PLATFORM_BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformBranchName").getter(PlatformSummary.getter(PlatformSummary::platformBranchName)).setter(PlatformSummary.setter(Builder::platformBranchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchName").build()}).build();
    private static final SdkField<String> PLATFORM_BRANCH_LIFECYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformBranchLifecycleState").getter(PlatformSummary.getter(PlatformSummary::platformBranchLifecycleState)).setter(PlatformSummary.setter(Builder::platformBranchLifecycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchLifecycleState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ARN_FIELD, PLATFORM_OWNER_FIELD, PLATFORM_STATUS_FIELD, PLATFORM_CATEGORY_FIELD, OPERATING_SYSTEM_NAME_FIELD, OPERATING_SYSTEM_VERSION_FIELD, SUPPORTED_TIER_LIST_FIELD, SUPPORTED_ADDON_LIST_FIELD, PLATFORM_LIFECYCLE_STATE_FIELD, PLATFORM_VERSION_FIELD, PLATFORM_BRANCH_NAME_FIELD, PLATFORM_BRANCH_LIFECYCLE_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String platformArn;
    private final String platformOwner;
    private final String platformStatus;
    private final String platformCategory;
    private final String operatingSystemName;
    private final String operatingSystemVersion;
    private final List<String> supportedTierList;
    private final List<String> supportedAddonList;
    private final String platformLifecycleState;
    private final String platformVersion;
    private final String platformBranchName;
    private final String platformBranchLifecycleState;

    private PlatformSummary(BuilderImpl builder) {
        this.platformArn = builder.platformArn;
        this.platformOwner = builder.platformOwner;
        this.platformStatus = builder.platformStatus;
        this.platformCategory = builder.platformCategory;
        this.operatingSystemName = builder.operatingSystemName;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.supportedTierList = builder.supportedTierList;
        this.supportedAddonList = builder.supportedAddonList;
        this.platformLifecycleState = builder.platformLifecycleState;
        this.platformVersion = builder.platformVersion;
        this.platformBranchName = builder.platformBranchName;
        this.platformBranchLifecycleState = builder.platformBranchLifecycleState;
    }

    public final String platformArn() {
        return this.platformArn;
    }

    public final String platformOwner() {
        return this.platformOwner;
    }

    public final PlatformStatus platformStatus() {
        return PlatformStatus.fromValue(this.platformStatus);
    }

    public final String platformStatusAsString() {
        return this.platformStatus;
    }

    public final String platformCategory() {
        return this.platformCategory;
    }

    public final String operatingSystemName() {
        return this.operatingSystemName;
    }

    public final String operatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public final boolean hasSupportedTierList() {
        return this.supportedTierList != null && !(this.supportedTierList instanceof SdkAutoConstructList);
    }

    public final List<String> supportedTierList() {
        return this.supportedTierList;
    }

    public final boolean hasSupportedAddonList() {
        return this.supportedAddonList != null && !(this.supportedAddonList instanceof SdkAutoConstructList);
    }

    public final List<String> supportedAddonList() {
        return this.supportedAddonList;
    }

    public final String platformLifecycleState() {
        return this.platformLifecycleState;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String platformBranchName() {
        return this.platformBranchName;
    }

    public final String platformBranchLifecycleState() {
        return this.platformBranchLifecycleState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedTierList() ? this.supportedTierList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedAddonList() ? this.supportedAddonList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.platformLifecycleState());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformBranchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformBranchLifecycleState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformSummary)) {
            return false;
        }
        PlatformSummary other = (PlatformSummary)obj;
        return Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.platformOwner(), other.platformOwner()) && Objects.equals(this.platformStatusAsString(), other.platformStatusAsString()) && Objects.equals(this.platformCategory(), other.platformCategory()) && Objects.equals(this.operatingSystemName(), other.operatingSystemName()) && Objects.equals(this.operatingSystemVersion(), other.operatingSystemVersion()) && this.hasSupportedTierList() == other.hasSupportedTierList() && Objects.equals(this.supportedTierList(), other.supportedTierList()) && this.hasSupportedAddonList() == other.hasSupportedAddonList() && Objects.equals(this.supportedAddonList(), other.supportedAddonList()) && Objects.equals(this.platformLifecycleState(), other.platformLifecycleState()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.platformBranchName(), other.platformBranchName()) && Objects.equals(this.platformBranchLifecycleState(), other.platformBranchLifecycleState());
    }

    public final String toString() {
        return ToString.builder((String)"PlatformSummary").add("PlatformArn", (Object)this.platformArn()).add("PlatformOwner", (Object)this.platformOwner()).add("PlatformStatus", (Object)this.platformStatusAsString()).add("PlatformCategory", (Object)this.platformCategory()).add("OperatingSystemName", (Object)this.operatingSystemName()).add("OperatingSystemVersion", (Object)this.operatingSystemVersion()).add("SupportedTierList", this.hasSupportedTierList() ? this.supportedTierList() : null).add("SupportedAddonList", this.hasSupportedAddonList() ? this.supportedAddonList() : null).add("PlatformLifecycleState", (Object)this.platformLifecycleState()).add("PlatformVersion", (Object)this.platformVersion()).add("PlatformBranchName", (Object)this.platformBranchName()).add("PlatformBranchLifecycleState", (Object)this.platformBranchLifecycleState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "PlatformOwner": {
                return Optional.ofNullable(clazz.cast(this.platformOwner()));
            }
            case "PlatformStatus": {
                return Optional.ofNullable(clazz.cast(this.platformStatusAsString()));
            }
            case "PlatformCategory": {
                return Optional.ofNullable(clazz.cast(this.platformCategory()));
            }
            case "OperatingSystemName": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemName()));
            }
            case "OperatingSystemVersion": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemVersion()));
            }
            case "SupportedTierList": {
                return Optional.ofNullable(clazz.cast(this.supportedTierList()));
            }
            case "SupportedAddonList": {
                return Optional.ofNullable(clazz.cast(this.supportedAddonList()));
            }
            case "PlatformLifecycleState": {
                return Optional.ofNullable(clazz.cast(this.platformLifecycleState()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "PlatformBranchName": {
                return Optional.ofNullable(clazz.cast(this.platformBranchName()));
            }
            case "PlatformBranchLifecycleState": {
                return Optional.ofNullable(clazz.cast(this.platformBranchLifecycleState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlatformSummary, T> g) {
        return obj -> g.apply((PlatformSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String platformArn;
        private String platformOwner;
        private String platformStatus;
        private String platformCategory;
        private String operatingSystemName;
        private String operatingSystemVersion;
        private List<String> supportedTierList = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedAddonList = DefaultSdkAutoConstructList.getInstance();
        private String platformLifecycleState;
        private String platformVersion;
        private String platformBranchName;
        private String platformBranchLifecycleState;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformSummary model) {
            this.platformArn(model.platformArn);
            this.platformOwner(model.platformOwner);
            this.platformStatus(model.platformStatus);
            this.platformCategory(model.platformCategory);
            this.operatingSystemName(model.operatingSystemName);
            this.operatingSystemVersion(model.operatingSystemVersion);
            this.supportedTierList(model.supportedTierList);
            this.supportedAddonList(model.supportedAddonList);
            this.platformLifecycleState(model.platformLifecycleState);
            this.platformVersion(model.platformVersion);
            this.platformBranchName(model.platformBranchName);
            this.platformBranchLifecycleState(model.platformBranchLifecycleState);
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final String getPlatformOwner() {
            return this.platformOwner;
        }

        public final void setPlatformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
        }

        @Override
        public final Builder platformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
            return this;
        }

        public final String getPlatformStatus() {
            return this.platformStatus;
        }

        public final void setPlatformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
        }

        @Override
        public final Builder platformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
            return this;
        }

        @Override
        public final Builder platformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus == null ? null : platformStatus.toString());
            return this;
        }

        public final String getPlatformCategory() {
            return this.platformCategory;
        }

        public final void setPlatformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
        }

        @Override
        public final Builder platformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
            return this;
        }

        public final String getOperatingSystemName() {
            return this.operatingSystemName;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        public final String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final Collection<String> getSupportedTierList() {
            if (this.supportedTierList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedTierList;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String ... supportedTierList) {
            this.supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        public final Collection<String> getSupportedAddonList() {
            if (this.supportedAddonList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedAddonList;
        }

        public final void setSupportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
        }

        @Override
        public final Builder supportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAddonList(String ... supportedAddonList) {
            this.supportedAddonList(Arrays.asList(supportedAddonList));
            return this;
        }

        public final String getPlatformLifecycleState() {
            return this.platformLifecycleState;
        }

        public final void setPlatformLifecycleState(String platformLifecycleState) {
            this.platformLifecycleState = platformLifecycleState;
        }

        @Override
        public final Builder platformLifecycleState(String platformLifecycleState) {
            this.platformLifecycleState = platformLifecycleState;
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getPlatformBranchName() {
            return this.platformBranchName;
        }

        public final void setPlatformBranchName(String platformBranchName) {
            this.platformBranchName = platformBranchName;
        }

        @Override
        public final Builder platformBranchName(String platformBranchName) {
            this.platformBranchName = platformBranchName;
            return this;
        }

        public final String getPlatformBranchLifecycleState() {
            return this.platformBranchLifecycleState;
        }

        public final void setPlatformBranchLifecycleState(String platformBranchLifecycleState) {
            this.platformBranchLifecycleState = platformBranchLifecycleState;
        }

        @Override
        public final Builder platformBranchLifecycleState(String platformBranchLifecycleState) {
            this.platformBranchLifecycleState = platformBranchLifecycleState;
            return this;
        }

        public PlatformSummary build() {
            return new PlatformSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlatformSummary> {
        public Builder platformArn(String var1);

        public Builder platformOwner(String var1);

        public Builder platformStatus(String var1);

        public Builder platformStatus(PlatformStatus var1);

        public Builder platformCategory(String var1);

        public Builder operatingSystemName(String var1);

        public Builder operatingSystemVersion(String var1);

        public Builder supportedTierList(Collection<String> var1);

        public Builder supportedTierList(String ... var1);

        public Builder supportedAddonList(Collection<String> var1);

        public Builder supportedAddonList(String ... var1);

        public Builder platformLifecycleState(String var1);

        public Builder platformVersion(String var1);

        public Builder platformBranchName(String var1);

        public Builder platformBranchLifecycleState(String var1);
    }
}

