/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteApplicationRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DeleteApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(DeleteApplicationRequest.getter(DeleteApplicationRequest::applicationName)).setter(DeleteApplicationRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<Boolean> TERMINATE_ENV_BY_FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminateEnvByForce").getter(DeleteApplicationRequest.getter(DeleteApplicationRequest::terminateEnvByForce)).setter(DeleteApplicationRequest.setter(Builder::terminateEnvByForce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateEnvByForce").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, TERMINATE_ENV_BY_FORCE_FIELD));
    private final String applicationName;
    private final Boolean terminateEnvByForce;

    private DeleteApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.terminateEnvByForce = builder.terminateEnvByForce;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final Boolean terminateEnvByForce() {
        return this.terminateEnvByForce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateEnvByForce());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationRequest)) {
            return false;
        }
        DeleteApplicationRequest other = (DeleteApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.terminateEnvByForce(), other.terminateEnvByForce());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("TerminateEnvByForce", (Object)this.terminateEnvByForce()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "TerminateEnvByForce": {
                return Optional.ofNullable(clazz.cast(this.terminateEnvByForce()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationRequest, T> g) {
        return obj -> g.apply((DeleteApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private Boolean terminateEnvByForce;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.terminateEnvByForce(model.terminateEnvByForce);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Boolean getTerminateEnvByForce() {
            return this.terminateEnvByForce;
        }

        public final void setTerminateEnvByForce(Boolean terminateEnvByForce) {
            this.terminateEnvByForce = terminateEnvByForce;
        }

        @Override
        @Transient
        public final Builder terminateEnvByForce(Boolean terminateEnvByForce) {
            this.terminateEnvByForce = terminateEnvByForce;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationRequest build() {
            return new DeleteApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder terminateEnvByForce(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

