/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkAsyncClient;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse;

public class ListPlatformBranchesPublisher
implements SdkPublisher<ListPlatformBranchesResponse> {
    private final ElasticBeanstalkAsyncClient client;
    private final ListPlatformBranchesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlatformBranchesPublisher(ElasticBeanstalkAsyncClient client, ListPlatformBranchesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlatformBranchesPublisher(ElasticBeanstalkAsyncClient client, ListPlatformBranchesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlatformBranchesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlatformBranchesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPlatformBranchesResponseFetcher
    implements AsyncPageFetcher<ListPlatformBranchesResponse> {
        private ListPlatformBranchesResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformBranchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlatformBranchesResponse> nextPage(ListPlatformBranchesResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformBranchesPublisher.this.client.listPlatformBranches(ListPlatformBranchesPublisher.this.firstRequest);
            }
            return ListPlatformBranchesPublisher.this.client.listPlatformBranches((ListPlatformBranchesRequest)((Object)ListPlatformBranchesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

