/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePlatformVersionResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribePlatformVersionResponse> {
    private static final SdkField<PlatformDescription> PLATFORM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PlatformDescription").getter(DescribePlatformVersionResponse.getter(DescribePlatformVersionResponse::platformDescription)).setter(DescribePlatformVersionResponse.setter(Builder::platformDescription)).constructor(PlatformDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_DESCRIPTION_FIELD));
    private final PlatformDescription platformDescription;

    private DescribePlatformVersionResponse(BuilderImpl builder) {
        super(builder);
        this.platformDescription = builder.platformDescription;
    }

    public final PlatformDescription platformDescription() {
        return this.platformDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlatformVersionResponse)) {
            return false;
        }
        DescribePlatformVersionResponse other = (DescribePlatformVersionResponse)((Object)obj);
        return Objects.equals(this.platformDescription(), other.platformDescription());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePlatformVersionResponse").add("PlatformDescription", (Object)this.platformDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformDescription": {
                return Optional.ofNullable(clazz.cast(this.platformDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePlatformVersionResponse, T> g) {
        return obj -> g.apply((DescribePlatformVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private PlatformDescription platformDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlatformVersionResponse model) {
            super(model);
            this.platformDescription(model.platformDescription);
        }

        public final PlatformDescription.Builder getPlatformDescription() {
            return this.platformDescription != null ? this.platformDescription.toBuilder() : null;
        }

        @Override
        public final Builder platformDescription(PlatformDescription platformDescription) {
            this.platformDescription = platformDescription;
            return this;
        }

        public final void setPlatformDescription(PlatformDescription.BuilderImpl platformDescription) {
            this.platformDescription = platformDescription != null ? platformDescription.build() : null;
        }

        @Override
        public DescribePlatformVersionResponse build() {
            return new DescribePlatformVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePlatformVersionResponse> {
        public Builder platformDescription(PlatformDescription var1);

        default public Builder platformDescription(Consumer<PlatformDescription.Builder> platformDescription) {
            return this.platformDescription((PlatformDescription)((PlatformDescription.Builder)PlatformDescription.builder().applyMutation(platformDescription)).build());
        }
    }
}

