/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentIdListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentNamesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEnvironmentsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeEnvironmentsRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(DescribeEnvironmentsRequest.getter(DescribeEnvironmentsRequest::applicationName)).setter(DescribeEnvironmentsRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionLabel").getter(DescribeEnvironmentsRequest.getter(DescribeEnvironmentsRequest::versionLabel)).setter(DescribeEnvironmentsRequest.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final SdkField<List<String>> ENVIRONMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentIds").getter(DescribeEnvironmentsRequest.getter(DescribeEnvironmentsRequest::environmentIds)).setter(DescribeEnvironmentsRequest.setter(Builder::environmentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENVIRONMENT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentNames").getter(DescribeEnvironmentsRequest.getter(DescribeEnvironmentsRequest::environmentNames)).setter(DescribeEnvironmentsRequest.setter(Builder::environmentNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeDeleted").getter(DescribeEnvironmentsRequest.getter(DescribeEnvironmentsRequest::includeDeleted)).setter(DescribeEnvironmentsRequest.setter(Builder::includeDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeDeleted").build()}).build();
    private static final SdkField<Instant> INCLUDED_DELETED_BACK_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IncludedDeletedBackTo").getter(DescribeEnvironmentsRequest.getter(DescribeEnvironmentsRequest::includedDeletedBackTo)).setter(DescribeEnvironmentsRequest.setter(Builder::includedDeletedBackTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedDeletedBackTo").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeEnvironmentsRequest.getter(DescribeEnvironmentsRequest::maxRecords)).setter(DescribeEnvironmentsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeEnvironmentsRequest.getter(DescribeEnvironmentsRequest::nextToken)).setter(DescribeEnvironmentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, VERSION_LABEL_FIELD, ENVIRONMENT_IDS_FIELD, ENVIRONMENT_NAMES_FIELD, INCLUDE_DELETED_FIELD, INCLUDED_DELETED_BACK_TO_FIELD, MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));
    private final String applicationName;
    private final String versionLabel;
    private final List<String> environmentIds;
    private final List<String> environmentNames;
    private final Boolean includeDeleted;
    private final Instant includedDeletedBackTo;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.environmentIds = builder.environmentIds;
        this.environmentNames = builder.environmentNames;
        this.includeDeleted = builder.includeDeleted;
        this.includedDeletedBackTo = builder.includedDeletedBackTo;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String versionLabel() {
        return this.versionLabel;
    }

    public final boolean hasEnvironmentIds() {
        return this.environmentIds != null && !(this.environmentIds instanceof SdkAutoConstructList);
    }

    public final List<String> environmentIds() {
        return this.environmentIds;
    }

    public final boolean hasEnvironmentNames() {
        return this.environmentNames != null && !(this.environmentNames instanceof SdkAutoConstructList);
    }

    public final List<String> environmentNames() {
        return this.environmentNames;
    }

    public final Boolean includeDeleted() {
        return this.includeDeleted;
    }

    public final Instant includedDeletedBackTo() {
        return this.includedDeletedBackTo;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentIds() ? this.environmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentNames() ? this.environmentNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.includedDeletedBackTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsRequest)) {
            return false;
        }
        DescribeEnvironmentsRequest other = (DescribeEnvironmentsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && this.hasEnvironmentIds() == other.hasEnvironmentIds() && Objects.equals(this.environmentIds(), other.environmentIds()) && this.hasEnvironmentNames() == other.hasEnvironmentNames() && Objects.equals(this.environmentNames(), other.environmentNames()) && Objects.equals(this.includeDeleted(), other.includeDeleted()) && Objects.equals(this.includedDeletedBackTo(), other.includedDeletedBackTo()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEnvironmentsRequest").add("ApplicationName", (Object)this.applicationName()).add("VersionLabel", (Object)this.versionLabel()).add("EnvironmentIds", this.hasEnvironmentIds() ? this.environmentIds() : null).add("EnvironmentNames", this.hasEnvironmentNames() ? this.environmentNames() : null).add("IncludeDeleted", (Object)this.includeDeleted()).add("IncludedDeletedBackTo", (Object)this.includedDeletedBackTo()).add("MaxRecords", (Object)this.maxRecords()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
            case "EnvironmentIds": {
                return Optional.ofNullable(clazz.cast(this.environmentIds()));
            }
            case "EnvironmentNames": {
                return Optional.ofNullable(clazz.cast(this.environmentNames()));
            }
            case "IncludeDeleted": {
                return Optional.ofNullable(clazz.cast(this.includeDeleted()));
            }
            case "IncludedDeletedBackTo": {
                return Optional.ofNullable(clazz.cast(this.includedDeletedBackTo()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentsRequest, T> g) {
        return obj -> g.apply((DescribeEnvironmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private List<String> environmentIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> environmentNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeDeleted;
        private Instant includedDeletedBackTo;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.environmentIds(model.environmentIds);
            this.environmentNames(model.environmentNames);
            this.includeDeleted(model.includeDeleted);
            this.includedDeletedBackTo(model.includedDeletedBackTo);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final Collection<String> getEnvironmentIds() {
            if (this.environmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.environmentIds;
        }

        @Override
        public final Builder environmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentIds(String ... environmentIds) {
            this.environmentIds(Arrays.asList(environmentIds));
            return this;
        }

        public final void setEnvironmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
        }

        public final Collection<String> getEnvironmentNames() {
            if (this.environmentNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.environmentNames;
        }

        @Override
        public final Builder environmentNames(Collection<String> environmentNames) {
            this.environmentNames = EnvironmentNamesListCopier.copy(environmentNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentNames(String ... environmentNames) {
            this.environmentNames(Arrays.asList(environmentNames));
            return this;
        }

        public final void setEnvironmentNames(Collection<String> environmentNames) {
            this.environmentNames = EnvironmentNamesListCopier.copy(environmentNames);
        }

        public final Boolean getIncludeDeleted() {
            return this.includeDeleted;
        }

        @Override
        public final Builder includeDeleted(Boolean includeDeleted) {
            this.includeDeleted = includeDeleted;
            return this;
        }

        public final void setIncludeDeleted(Boolean includeDeleted) {
            this.includeDeleted = includeDeleted;
        }

        public final Instant getIncludedDeletedBackTo() {
            return this.includedDeletedBackTo;
        }

        @Override
        public final Builder includedDeletedBackTo(Instant includedDeletedBackTo) {
            this.includedDeletedBackTo = includedDeletedBackTo;
            return this;
        }

        public final void setIncludedDeletedBackTo(Instant includedDeletedBackTo) {
            this.includedDeletedBackTo = includedDeletedBackTo;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentsRequest build() {
            return new DescribeEnvironmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEnvironmentsRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder environmentIds(Collection<String> var1);

        public Builder environmentIds(String ... var1);

        public Builder environmentNames(Collection<String> var1);

        public Builder environmentNames(String ... var1);

        public Builder includeDeleted(Boolean var1);

        public Builder includedDeletedBackTo(Instant var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

