/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuota;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceQuotas
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceQuotas> {
    private static final SdkField<ResourceQuota> APPLICATION_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationQuota").getter(ResourceQuotas.getter(ResourceQuotas::applicationQuota)).setter(ResourceQuotas.setter(Builder::applicationQuota)).constructor(ResourceQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationQuota").build()}).build();
    private static final SdkField<ResourceQuota> APPLICATION_VERSION_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationVersionQuota").getter(ResourceQuotas.getter(ResourceQuotas::applicationVersionQuota)).setter(ResourceQuotas.setter(Builder::applicationVersionQuota)).constructor(ResourceQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionQuota").build()}).build();
    private static final SdkField<ResourceQuota> ENVIRONMENT_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnvironmentQuota").getter(ResourceQuotas.getter(ResourceQuotas::environmentQuota)).setter(ResourceQuotas.setter(Builder::environmentQuota)).constructor(ResourceQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentQuota").build()}).build();
    private static final SdkField<ResourceQuota> CONFIGURATION_TEMPLATE_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationTemplateQuota").getter(ResourceQuotas.getter(ResourceQuotas::configurationTemplateQuota)).setter(ResourceQuotas.setter(Builder::configurationTemplateQuota)).constructor(ResourceQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationTemplateQuota").build()}).build();
    private static final SdkField<ResourceQuota> CUSTOM_PLATFORM_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomPlatformQuota").getter(ResourceQuotas.getter(ResourceQuotas::customPlatformQuota)).setter(ResourceQuotas.setter(Builder::customPlatformQuota)).constructor(ResourceQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPlatformQuota").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_QUOTA_FIELD, APPLICATION_VERSION_QUOTA_FIELD, ENVIRONMENT_QUOTA_FIELD, CONFIGURATION_TEMPLATE_QUOTA_FIELD, CUSTOM_PLATFORM_QUOTA_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourceQuota applicationQuota;
    private final ResourceQuota applicationVersionQuota;
    private final ResourceQuota environmentQuota;
    private final ResourceQuota configurationTemplateQuota;
    private final ResourceQuota customPlatformQuota;

    private ResourceQuotas(BuilderImpl builder) {
        this.applicationQuota = builder.applicationQuota;
        this.applicationVersionQuota = builder.applicationVersionQuota;
        this.environmentQuota = builder.environmentQuota;
        this.configurationTemplateQuota = builder.configurationTemplateQuota;
        this.customPlatformQuota = builder.customPlatformQuota;
    }

    public final ResourceQuota applicationQuota() {
        return this.applicationQuota;
    }

    public final ResourceQuota applicationVersionQuota() {
        return this.applicationVersionQuota;
    }

    public final ResourceQuota environmentQuota() {
        return this.environmentQuota;
    }

    public final ResourceQuota configurationTemplateQuota() {
        return this.configurationTemplateQuota;
    }

    public final ResourceQuota customPlatformQuota() {
        return this.customPlatformQuota;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTemplateQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPlatformQuota());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceQuotas)) {
            return false;
        }
        ResourceQuotas other = (ResourceQuotas)obj;
        return Objects.equals(this.applicationQuota(), other.applicationQuota()) && Objects.equals(this.applicationVersionQuota(), other.applicationVersionQuota()) && Objects.equals(this.environmentQuota(), other.environmentQuota()) && Objects.equals(this.configurationTemplateQuota(), other.configurationTemplateQuota()) && Objects.equals(this.customPlatformQuota(), other.customPlatformQuota());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceQuotas").add("ApplicationQuota", (Object)this.applicationQuota()).add("ApplicationVersionQuota", (Object)this.applicationVersionQuota()).add("EnvironmentQuota", (Object)this.environmentQuota()).add("ConfigurationTemplateQuota", (Object)this.configurationTemplateQuota()).add("CustomPlatformQuota", (Object)this.customPlatformQuota()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationQuota": {
                return Optional.ofNullable(clazz.cast(this.applicationQuota()));
            }
            case "ApplicationVersionQuota": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionQuota()));
            }
            case "EnvironmentQuota": {
                return Optional.ofNullable(clazz.cast(this.environmentQuota()));
            }
            case "ConfigurationTemplateQuota": {
                return Optional.ofNullable(clazz.cast(this.configurationTemplateQuota()));
            }
            case "CustomPlatformQuota": {
                return Optional.ofNullable(clazz.cast(this.customPlatformQuota()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceQuotas, T> g) {
        return obj -> g.apply((ResourceQuotas)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceQuota applicationQuota;
        private ResourceQuota applicationVersionQuota;
        private ResourceQuota environmentQuota;
        private ResourceQuota configurationTemplateQuota;
        private ResourceQuota customPlatformQuota;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceQuotas model) {
            this.applicationQuota(model.applicationQuota);
            this.applicationVersionQuota(model.applicationVersionQuota);
            this.environmentQuota(model.environmentQuota);
            this.configurationTemplateQuota(model.configurationTemplateQuota);
            this.customPlatformQuota(model.customPlatformQuota);
        }

        public final ResourceQuota.Builder getApplicationQuota() {
            return this.applicationQuota != null ? this.applicationQuota.toBuilder() : null;
        }

        @Override
        public final Builder applicationQuota(ResourceQuota applicationQuota) {
            this.applicationQuota = applicationQuota;
            return this;
        }

        public final void setApplicationQuota(ResourceQuota.BuilderImpl applicationQuota) {
            this.applicationQuota = applicationQuota != null ? applicationQuota.build() : null;
        }

        public final ResourceQuota.Builder getApplicationVersionQuota() {
            return this.applicationVersionQuota != null ? this.applicationVersionQuota.toBuilder() : null;
        }

        @Override
        public final Builder applicationVersionQuota(ResourceQuota applicationVersionQuota) {
            this.applicationVersionQuota = applicationVersionQuota;
            return this;
        }

        public final void setApplicationVersionQuota(ResourceQuota.BuilderImpl applicationVersionQuota) {
            this.applicationVersionQuota = applicationVersionQuota != null ? applicationVersionQuota.build() : null;
        }

        public final ResourceQuota.Builder getEnvironmentQuota() {
            return this.environmentQuota != null ? this.environmentQuota.toBuilder() : null;
        }

        @Override
        public final Builder environmentQuota(ResourceQuota environmentQuota) {
            this.environmentQuota = environmentQuota;
            return this;
        }

        public final void setEnvironmentQuota(ResourceQuota.BuilderImpl environmentQuota) {
            this.environmentQuota = environmentQuota != null ? environmentQuota.build() : null;
        }

        public final ResourceQuota.Builder getConfigurationTemplateQuota() {
            return this.configurationTemplateQuota != null ? this.configurationTemplateQuota.toBuilder() : null;
        }

        @Override
        public final Builder configurationTemplateQuota(ResourceQuota configurationTemplateQuota) {
            this.configurationTemplateQuota = configurationTemplateQuota;
            return this;
        }

        public final void setConfigurationTemplateQuota(ResourceQuota.BuilderImpl configurationTemplateQuota) {
            this.configurationTemplateQuota = configurationTemplateQuota != null ? configurationTemplateQuota.build() : null;
        }

        public final ResourceQuota.Builder getCustomPlatformQuota() {
            return this.customPlatformQuota != null ? this.customPlatformQuota.toBuilder() : null;
        }

        @Override
        public final Builder customPlatformQuota(ResourceQuota customPlatformQuota) {
            this.customPlatformQuota = customPlatformQuota;
            return this;
        }

        public final void setCustomPlatformQuota(ResourceQuota.BuilderImpl customPlatformQuota) {
            this.customPlatformQuota = customPlatformQuota != null ? customPlatformQuota.build() : null;
        }

        public ResourceQuotas build() {
            return new ResourceQuotas(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceQuotas> {
        public Builder applicationQuota(ResourceQuota var1);

        default public Builder applicationQuota(Consumer<ResourceQuota.Builder> applicationQuota) {
            return this.applicationQuota((ResourceQuota)((ResourceQuota.Builder)ResourceQuota.builder().applyMutation(applicationQuota)).build());
        }

        public Builder applicationVersionQuota(ResourceQuota var1);

        default public Builder applicationVersionQuota(Consumer<ResourceQuota.Builder> applicationVersionQuota) {
            return this.applicationVersionQuota((ResourceQuota)((ResourceQuota.Builder)ResourceQuota.builder().applyMutation(applicationVersionQuota)).build());
        }

        public Builder environmentQuota(ResourceQuota var1);

        default public Builder environmentQuota(Consumer<ResourceQuota.Builder> environmentQuota) {
            return this.environmentQuota((ResourceQuota)((ResourceQuota.Builder)ResourceQuota.builder().applyMutation(environmentQuota)).build());
        }

        public Builder configurationTemplateQuota(ResourceQuota var1);

        default public Builder configurationTemplateQuota(Consumer<ResourceQuota.Builder> configurationTemplateQuota) {
            return this.configurationTemplateQuota((ResourceQuota)((ResourceQuota.Builder)ResourceQuota.builder().applyMutation(configurationTemplateQuota)).build());
        }

        public Builder customPlatformQuota(ResourceQuota var1);

        default public Builder customPlatformQuota(Consumer<ResourceQuota.Builder> customPlatformQuota) {
            return this.customPlatformQuota((ResourceQuota)((ResourceQuota.Builder)ResourceQuota.builder().applyMutation(customPlatformQuota)).build());
        }
    }
}

