/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescriptionListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationSettingsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationSettingsResponse> {
    private static final SdkField<List<ConfigurationSettingsDescription>> CONFIGURATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationSettings").getter(DescribeConfigurationSettingsResponse.getter(DescribeConfigurationSettingsResponse::configurationSettings)).setter(DescribeConfigurationSettingsResponse.setter(Builder::configurationSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SETTINGS_FIELD));
    private final List<ConfigurationSettingsDescription> configurationSettings;

    private DescribeConfigurationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSettings = builder.configurationSettings;
    }

    public final boolean hasConfigurationSettings() {
        return this.configurationSettings != null && !(this.configurationSettings instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationSettingsDescription> configurationSettings() {
        return this.configurationSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationSettings() ? this.configurationSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSettingsResponse)) {
            return false;
        }
        DescribeConfigurationSettingsResponse other = (DescribeConfigurationSettingsResponse)((Object)obj);
        return this.hasConfigurationSettings() == other.hasConfigurationSettings() && Objects.equals(this.configurationSettings(), other.configurationSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationSettingsResponse").add("ConfigurationSettings", this.hasConfigurationSettings() ? this.configurationSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSettings": {
                return Optional.ofNullable(clazz.cast(this.configurationSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationSettingsResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationSettingsDescription> configurationSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSettingsResponse model) {
            super(model);
            this.configurationSettings(model.configurationSettings);
        }

        public final List<ConfigurationSettingsDescription.Builder> getConfigurationSettings() {
            List<ConfigurationSettingsDescription.Builder> result = ConfigurationSettingsDescriptionListCopier.copyToBuilder(this.configurationSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder configurationSettings(Collection<ConfigurationSettingsDescription> configurationSettings) {
            this.configurationSettings = ConfigurationSettingsDescriptionListCopier.copy(configurationSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSettings(ConfigurationSettingsDescription ... configurationSettings) {
            this.configurationSettings(Arrays.asList(configurationSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSettings(Consumer<ConfigurationSettingsDescription.Builder> ... configurationSettings) {
            this.configurationSettings(Stream.of(configurationSettings).map(c -> (ConfigurationSettingsDescription)((ConfigurationSettingsDescription.Builder)ConfigurationSettingsDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationSettings(Collection<ConfigurationSettingsDescription.BuilderImpl> configurationSettings) {
            this.configurationSettings = ConfigurationSettingsDescriptionListCopier.copyFromBuilder(configurationSettings);
        }

        @Override
        public DescribeConfigurationSettingsResponse build() {
            return new DescribeConfigurationSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationSettingsResponse> {
        public Builder configurationSettings(Collection<ConfigurationSettingsDescription> var1);

        public Builder configurationSettings(ConfigurationSettingsDescription ... var1);

        public Builder configurationSettings(Consumer<ConfigurationSettingsDescription.Builder> ... var1);
    }
}

