/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTagsForResourceRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<UpdateTagsForResourceRequest.Builder, UpdateTagsForResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(UpdateTagsForResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_TO_ADD_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagsToAdd")
            .getter(getter(UpdateTagsForResourceRequest::tagsToAdd))
            .setter(setter(Builder::tagsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TAGS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagsToRemove")
            .getter(getter(UpdateTagsForResourceRequest::tagsToRemove))
            .setter(setter(Builder::tagsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            TAGS_TO_ADD_FIELD, TAGS_TO_REMOVE_FIELD));

    private final String resourceArn;

    private final List<Tag> tagsToAdd;

    private final List<String> tagsToRemove;

    private UpdateTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.tagsToAdd = builder.tagsToAdd;
        this.tagsToRemove = builder.tagsToRemove;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resouce to be updated.
     * </p>
     * <p>
     * Must be the ARN of an Elastic Beanstalk resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resouce to be updated.</p>
     *         <p>
     *         Must be the ARN of an Elastic Beanstalk resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * Returns true if the TagsToAdd property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTagsToAdd() {
        return tagsToAdd != null && !(tagsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.
     * </p>
     * <p>
     * Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagsToAdd()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>
     *         <p>
     *         Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
     */
    public final List<Tag> tagsToAdd() {
        return tagsToAdd;
    }

    /**
     * Returns true if the TagsToRemove property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTagsToRemove() {
        return tagsToRemove != null && !(tagsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.
     * </p>
     * <p>
     * Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagsToRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
     *         <p>
     *         Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
     */
    public final List<String> tagsToRemove() {
        return tagsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagsToAdd() ? tagsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagsToRemove() ? tagsToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagsForResourceRequest)) {
            return false;
        }
        UpdateTagsForResourceRequest other = (UpdateTagsForResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && hasTagsToAdd() == other.hasTagsToAdd()
                && Objects.equals(tagsToAdd(), other.tagsToAdd()) && hasTagsToRemove() == other.hasTagsToRemove()
                && Objects.equals(tagsToRemove(), other.tagsToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTagsForResourceRequest").add("ResourceArn", resourceArn())
                .add("TagsToAdd", hasTagsToAdd() ? tagsToAdd() : null)
                .add("TagsToRemove", hasTagsToRemove() ? tagsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "TagsToAdd":
            return Optional.ofNullable(clazz.cast(tagsToAdd()));
        case "TagsToRemove":
            return Optional.ofNullable(clazz.cast(tagsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTagsForResourceRequest, T> g) {
        return obj -> g.apply((UpdateTagsForResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTagsForResourceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resouce to be updated.
         * </p>
         * <p>
         * Must be the ARN of an Elastic Beanstalk resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the resouce to be updated.</p>
         *        <p>
         *        Must be the ARN of an Elastic Beanstalk resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.
         * </p>
         * <p>
         * Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
         * </p>
         * 
         * @param tagsToAdd
         *        A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>
         *        <p>
         *        Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToAdd(Collection<Tag> tagsToAdd);

        /**
         * <p>
         * A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.
         * </p>
         * <p>
         * Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
         * </p>
         * 
         * @param tagsToAdd
         *        A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.</p>
         *        <p>
         *        Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToAdd(Tag... tagsToAdd);

        /**
         * <p>
         * A list of tags to add or update. If a key of an existing tag is added, the tag's value is updated.
         * </p>
         * <p>
         * Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tagsToAdd(List<Tag>)}.
         * 
         * @param tagsToAdd
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagsToAdd(List<Tag>)
         */
        Builder tagsToAdd(Consumer<Tag.Builder>... tagsToAdd);

        /**
         * <p>
         * A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.
         * </p>
         * <p>
         * Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
         * </p>
         * 
         * @param tagsToRemove
         *        A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
         *        <p>
         *        Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToRemove(Collection<String> tagsToRemove);

        /**
         * <p>
         * A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.
         * </p>
         * <p>
         * Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
         * </p>
         * 
         * @param tagsToRemove
         *        A list of tag keys to remove. If a tag key doesn't exist, it is silently ignored.</p>
         *        <p>
         *        Specify at least one of these parameters: <code>TagsToAdd</code>, <code>TagsToRemove</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToRemove(String... tagsToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private List<Tag> tagsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> tagsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTagsForResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            tagsToAdd(model.tagsToAdd);
            tagsToRemove(model.tagsToRemove);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<Tag.Builder> getTagsToAdd() {
            if (tagsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return tagsToAdd != null ? tagsToAdd.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagsToAdd(Collection<Tag> tagsToAdd) {
            this.tagsToAdd = TagListCopier.copy(tagsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(Tag... tagsToAdd) {
            tagsToAdd(Arrays.asList(tagsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(Consumer<Tag.Builder>... tagsToAdd) {
            tagsToAdd(Stream.of(tagsToAdd).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagsToAdd(Collection<Tag.BuilderImpl> tagsToAdd) {
            this.tagsToAdd = TagListCopier.copyFromBuilder(tagsToAdd);
        }

        public final Collection<String> getTagsToRemove() {
            if (tagsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return tagsToRemove;
        }

        @Override
        public final Builder tagsToRemove(Collection<String> tagsToRemove) {
            this.tagsToRemove = TagKeyListCopier.copy(tagsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToRemove(String... tagsToRemove) {
            tagsToRemove(Arrays.asList(tagsToRemove));
            return this;
        }

        public final void setTagsToRemove(Collection<String> tagsToRemove) {
            this.tagsToRemove = TagKeyListCopier.copy(tagsToRemove);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTagsForResourceRequest build() {
            return new UpdateTagsForResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
