/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlatformVersionResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<CreatePlatformVersionResponse.Builder, CreatePlatformVersionResponse> {
    private static final SdkField<PlatformSummary> PLATFORM_SUMMARY_FIELD = SdkField
            .<PlatformSummary> builder(MarshallingType.SDK_POJO).memberName("PlatformSummary")
            .getter(getter(CreatePlatformVersionResponse::platformSummary)).setter(setter(Builder::platformSummary))
            .constructor(PlatformSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformSummary").build()).build();

    private static final SdkField<PlatformBuilder> PLATFORM_BUILDER_FIELD = SdkField
            .<PlatformBuilder> builder(MarshallingType.SDK_POJO).memberName("PlatformBuilder")
            .getter(getter(CreatePlatformVersionResponse::platformBuilder)).setter(setter(Builder::platformBuilder))
            .constructor(PlatformBuilder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Builder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_SUMMARY_FIELD,
            PLATFORM_BUILDER_FIELD));

    private final PlatformSummary platformSummary;

    private final PlatformBuilder platformBuilder;

    private CreatePlatformVersionResponse(BuilderImpl builder) {
        super(builder);
        this.platformSummary = builder.platformSummary;
        this.platformBuilder = builder.platformBuilder;
    }

    /**
     * <p>
     * Detailed information about the new version of the custom platform.
     * </p>
     * 
     * @return Detailed information about the new version of the custom platform.
     */
    public final PlatformSummary platformSummary() {
        return platformSummary;
    }

    /**
     * <p>
     * The builder used to create the custom platform.
     * </p>
     * 
     * @return The builder used to create the custom platform.
     */
    public final PlatformBuilder platformBuilder() {
        return platformBuilder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(platformSummary());
        hashCode = 31 * hashCode + Objects.hashCode(platformBuilder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformVersionResponse)) {
            return false;
        }
        CreatePlatformVersionResponse other = (CreatePlatformVersionResponse) obj;
        return Objects.equals(platformSummary(), other.platformSummary())
                && Objects.equals(platformBuilder(), other.platformBuilder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePlatformVersionResponse").add("PlatformSummary", platformSummary())
                .add("PlatformBuilder", platformBuilder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformSummary":
            return Optional.ofNullable(clazz.cast(platformSummary()));
        case "PlatformBuilder":
            return Optional.ofNullable(clazz.cast(platformBuilder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlatformVersionResponse, T> g) {
        return obj -> g.apply((CreatePlatformVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePlatformVersionResponse> {
        /**
         * <p>
         * Detailed information about the new version of the custom platform.
         * </p>
         * 
         * @param platformSummary
         *        Detailed information about the new version of the custom platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformSummary(PlatformSummary platformSummary);

        /**
         * <p>
         * Detailed information about the new version of the custom platform.
         * </p>
         * This is a convenience that creates an instance of the {@link PlatformSummary.Builder} avoiding the need to
         * create one manually via {@link PlatformSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlatformSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #platformSummary(PlatformSummary)}.
         * 
         * @param platformSummary
         *        a consumer that will call methods on {@link PlatformSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformSummary(PlatformSummary)
         */
        default Builder platformSummary(Consumer<PlatformSummary.Builder> platformSummary) {
            return platformSummary(PlatformSummary.builder().applyMutation(platformSummary).build());
        }

        /**
         * <p>
         * The builder used to create the custom platform.
         * </p>
         * 
         * @param platformBuilder
         *        The builder used to create the custom platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformBuilder(PlatformBuilder platformBuilder);

        /**
         * <p>
         * The builder used to create the custom platform.
         * </p>
         * This is a convenience that creates an instance of the {@link PlatformBuilder.Builder} avoiding the need to
         * create one manually via {@link PlatformBuilder#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlatformBuilder.Builder#build()} is called immediately and its
         * result is passed to {@link #platformBuilder(PlatformBuilder)}.
         * 
         * @param platformBuilder
         *        a consumer that will call methods on {@link PlatformBuilder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformBuilder(PlatformBuilder)
         */
        default Builder platformBuilder(Consumer<PlatformBuilder.Builder> platformBuilder) {
            return platformBuilder(PlatformBuilder.builder().applyMutation(platformBuilder).build());
        }
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private PlatformSummary platformSummary;

        private PlatformBuilder platformBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformVersionResponse model) {
            super(model);
            platformSummary(model.platformSummary);
            platformBuilder(model.platformBuilder);
        }

        public final PlatformSummary.Builder getPlatformSummary() {
            return platformSummary != null ? platformSummary.toBuilder() : null;
        }

        @Override
        public final Builder platformSummary(PlatformSummary platformSummary) {
            this.platformSummary = platformSummary;
            return this;
        }

        public final void setPlatformSummary(PlatformSummary.BuilderImpl platformSummary) {
            this.platformSummary = platformSummary != null ? platformSummary.build() : null;
        }

        public final PlatformBuilder.Builder getPlatformBuilder() {
            return platformBuilder != null ? platformBuilder.toBuilder() : null;
        }

        @Override
        public final Builder platformBuilder(PlatformBuilder platformBuilder) {
            this.platformBuilder = platformBuilder;
            return this;
        }

        public final void setPlatformBuilder(PlatformBuilder.BuilderImpl platformBuilder) {
            this.platformBuilder = platformBuilder != null ? platformBuilder.build() : null;
        }

        @Override
        public CreatePlatformVersionResponse build() {
            return new CreatePlatformVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
