/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealth;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLink;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLinksCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourcesDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, CreateEnvironmentResponse> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::environmentName)).setter(CreateEnvironmentResponse.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::environmentId)).setter(CreateEnvironmentResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::applicationName)).setter(CreateEnvironmentResponse.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionLabel").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::versionLabel)).setter(CreateEnvironmentResponse.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolutionStackName").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::solutionStackName)).setter(CreateEnvironmentResponse.setter(Builder::solutionStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()}).build();
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformArn").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::platformArn)).setter(CreateEnvironmentResponse.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::templateName)).setter(CreateEnvironmentResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::description)).setter(CreateEnvironmentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointURL").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::endpointURL)).setter(CreateEnvironmentResponse.setter(Builder::endpointURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointURL").build()}).build();
    private static final SdkField<String> CNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CNAME").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::cname)).setter(CreateEnvironmentResponse.setter(Builder::cname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CNAME").build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::dateCreated)).setter(CreateEnvironmentResponse.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateUpdated").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::dateUpdated)).setter(CreateEnvironmentResponse.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::statusAsString)).setter(CreateEnvironmentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> ABORTABLE_OPERATION_IN_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AbortableOperationInProgress").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::abortableOperationInProgress)).setter(CreateEnvironmentResponse.setter(Builder::abortableOperationInProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortableOperationInProgress").build()}).build();
    private static final SdkField<String> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Health").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::healthAsString)).setter(CreateEnvironmentResponse.setter(Builder::health)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Health").build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthStatus").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::healthStatusAsString)).setter(CreateEnvironmentResponse.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final SdkField<EnvironmentResourcesDescription> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resources").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::resources)).setter(CreateEnvironmentResponse.setter(Builder::resources)).constructor(EnvironmentResourcesDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build()}).build();
    private static final SdkField<EnvironmentTier> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tier").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::tier)).setter(CreateEnvironmentResponse.setter(Builder::tier)).constructor(EnvironmentTier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<List<EnvironmentLink>> ENVIRONMENT_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentLinks").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::environmentLinks)).setter(CreateEnvironmentResponse.setter(Builder::environmentLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentArn").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::environmentArn)).setter(CreateEnvironmentResponse.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentArn").build()}).build();
    private static final SdkField<String> OPERATIONS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationsRole").getter(CreateEnvironmentResponse.getter(CreateEnvironmentResponse::operationsRole)).setter(CreateEnvironmentResponse.setter(Builder::operationsRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationsRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD, ENVIRONMENT_ID_FIELD, APPLICATION_NAME_FIELD, VERSION_LABEL_FIELD, SOLUTION_STACK_NAME_FIELD, PLATFORM_ARN_FIELD, TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, ENDPOINT_URL_FIELD, CNAME_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, STATUS_FIELD, ABORTABLE_OPERATION_IN_PROGRESS_FIELD, HEALTH_FIELD, HEALTH_STATUS_FIELD, RESOURCES_FIELD, TIER_FIELD, ENVIRONMENT_LINKS_FIELD, ENVIRONMENT_ARN_FIELD, OPERATIONS_ROLE_FIELD));
    private final String environmentName;
    private final String environmentId;
    private final String applicationName;
    private final String versionLabel;
    private final String solutionStackName;
    private final String platformArn;
    private final String templateName;
    private final String description;
    private final String endpointURL;
    private final String cname;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final String status;
    private final Boolean abortableOperationInProgress;
    private final String health;
    private final String healthStatus;
    private final EnvironmentResourcesDescription resources;
    private final EnvironmentTier tier;
    private final List<EnvironmentLink> environmentLinks;
    private final String environmentArn;
    private final String operationsRole;

    private CreateEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.endpointURL = builder.endpointURL;
        this.cname = builder.cname;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.status = builder.status;
        this.abortableOperationInProgress = builder.abortableOperationInProgress;
        this.health = builder.health;
        this.healthStatus = builder.healthStatus;
        this.resources = builder.resources;
        this.tier = builder.tier;
        this.environmentLinks = builder.environmentLinks;
        this.environmentArn = builder.environmentArn;
        this.operationsRole = builder.operationsRole;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String versionLabel() {
        return this.versionLabel;
    }

    public final String solutionStackName() {
        return this.solutionStackName;
    }

    public final String platformArn() {
        return this.platformArn;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String description() {
        return this.description;
    }

    public final String endpointURL() {
        return this.endpointURL;
    }

    public final String cname() {
        return this.cname;
    }

    public final Instant dateCreated() {
        return this.dateCreated;
    }

    public final Instant dateUpdated() {
        return this.dateUpdated;
    }

    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean abortableOperationInProgress() {
        return this.abortableOperationInProgress;
    }

    public final EnvironmentHealth health() {
        return EnvironmentHealth.fromValue(this.health);
    }

    public final String healthAsString() {
        return this.health;
    }

    public final EnvironmentHealthStatus healthStatus() {
        return EnvironmentHealthStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final EnvironmentResourcesDescription resources() {
        return this.resources;
    }

    public final EnvironmentTier tier() {
        return this.tier;
    }

    public final boolean hasEnvironmentLinks() {
        return this.environmentLinks != null && !(this.environmentLinks instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentLink> environmentLinks() {
        return this.environmentLinks;
    }

    public final String environmentArn() {
        return this.environmentArn;
    }

    public final String operationsRole() {
        return this.operationsRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.cname());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortableOperationInProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentLinks() ? this.environmentLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationsRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentResponse)) {
            return false;
        }
        CreateEnvironmentResponse other = (CreateEnvironmentResponse)((Object)obj);
        return Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endpointURL(), other.endpointURL()) && Objects.equals(this.cname(), other.cname()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.abortableOperationInProgress(), other.abortableOperationInProgress()) && Objects.equals(this.healthAsString(), other.healthAsString()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.tier(), other.tier()) && this.hasEnvironmentLinks() == other.hasEnvironmentLinks() && Objects.equals(this.environmentLinks(), other.environmentLinks()) && Objects.equals(this.environmentArn(), other.environmentArn()) && Objects.equals(this.operationsRole(), other.operationsRole());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentResponse").add("EnvironmentName", (Object)this.environmentName()).add("EnvironmentId", (Object)this.environmentId()).add("ApplicationName", (Object)this.applicationName()).add("VersionLabel", (Object)this.versionLabel()).add("SolutionStackName", (Object)this.solutionStackName()).add("PlatformArn", (Object)this.platformArn()).add("TemplateName", (Object)this.templateName()).add("Description", (Object)this.description()).add("EndpointURL", (Object)this.endpointURL()).add("CNAME", (Object)this.cname()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("Status", (Object)this.statusAsString()).add("AbortableOperationInProgress", (Object)this.abortableOperationInProgress()).add("Health", (Object)this.healthAsString()).add("HealthStatus", (Object)this.healthStatusAsString()).add("Resources", (Object)this.resources()).add("Tier", (Object)this.tier()).add("EnvironmentLinks", this.hasEnvironmentLinks() ? this.environmentLinks() : null).add("EnvironmentArn", (Object)this.environmentArn()).add("OperationsRole", (Object)this.operationsRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
            case "SolutionStackName": {
                return Optional.ofNullable(clazz.cast(this.solutionStackName()));
            }
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EndpointURL": {
                return Optional.ofNullable(clazz.cast(this.endpointURL()));
            }
            case "CNAME": {
                return Optional.ofNullable(clazz.cast(this.cname()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AbortableOperationInProgress": {
                return Optional.ofNullable(clazz.cast(this.abortableOperationInProgress()));
            }
            case "Health": {
                return Optional.ofNullable(clazz.cast(this.healthAsString()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tier()));
            }
            case "EnvironmentLinks": {
                return Optional.ofNullable(clazz.cast(this.environmentLinks()));
            }
            case "EnvironmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
            case "OperationsRole": {
                return Optional.ofNullable(clazz.cast(this.operationsRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentResponse, T> g) {
        return obj -> g.apply((CreateEnvironmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private String environmentName;
        private String environmentId;
        private String applicationName;
        private String versionLabel;
        private String solutionStackName;
        private String platformArn;
        private String templateName;
        private String description;
        private String endpointURL;
        private String cname;
        private Instant dateCreated;
        private Instant dateUpdated;
        private String status;
        private Boolean abortableOperationInProgress;
        private String health;
        private String healthStatus;
        private EnvironmentResourcesDescription resources;
        private EnvironmentTier tier;
        private List<EnvironmentLink> environmentLinks = DefaultSdkAutoConstructList.getInstance();
        private String environmentArn;
        private String operationsRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentResponse model) {
            super(model);
            this.environmentName(model.environmentName);
            this.environmentId(model.environmentId);
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.solutionStackName(model.solutionStackName);
            this.platformArn(model.platformArn);
            this.templateName(model.templateName);
            this.description(model.description);
            this.endpointURL(model.endpointURL);
            this.cname(model.cname);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.status(model.status);
            this.abortableOperationInProgress(model.abortableOperationInProgress);
            this.health(model.health);
            this.healthStatus(model.healthStatus);
            this.resources(model.resources);
            this.tier(model.tier);
            this.environmentLinks(model.environmentLinks);
            this.environmentArn(model.environmentArn);
            this.operationsRole(model.operationsRole);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEndpointURL() {
            return this.endpointURL;
        }

        @Override
        public final Builder endpointURL(String endpointURL) {
            this.endpointURL = endpointURL;
            return this;
        }

        public final void setEndpointURL(String endpointURL) {
            this.endpointURL = endpointURL;
        }

        public final String getCname() {
            return this.cname;
        }

        @Override
        public final Builder cname(String cname) {
            this.cname = cname;
            return this;
        }

        public final void setCname(String cname) {
            this.cname = cname;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getAbortableOperationInProgress() {
            return this.abortableOperationInProgress;
        }

        @Override
        public final Builder abortableOperationInProgress(Boolean abortableOperationInProgress) {
            this.abortableOperationInProgress = abortableOperationInProgress;
            return this;
        }

        public final void setAbortableOperationInProgress(Boolean abortableOperationInProgress) {
            this.abortableOperationInProgress = abortableOperationInProgress;
        }

        public final String getHealth() {
            return this.health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(EnvironmentHealth health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(EnvironmentHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final EnvironmentResourcesDescription.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(EnvironmentResourcesDescription resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(EnvironmentResourcesDescription.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final EnvironmentTier.Builder getTier() {
            return this.tier != null ? this.tier.toBuilder() : null;
        }

        @Override
        public final Builder tier(EnvironmentTier tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(EnvironmentTier.BuilderImpl tier) {
            this.tier = tier != null ? tier.build() : null;
        }

        public final List<EnvironmentLink.Builder> getEnvironmentLinks() {
            List<EnvironmentLink.Builder> result = EnvironmentLinksCopier.copyToBuilder(this.environmentLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder environmentLinks(Collection<EnvironmentLink> environmentLinks) {
            this.environmentLinks = EnvironmentLinksCopier.copy(environmentLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentLinks(EnvironmentLink ... environmentLinks) {
            this.environmentLinks(Arrays.asList(environmentLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentLinks(Consumer<EnvironmentLink.Builder> ... environmentLinks) {
            this.environmentLinks(Stream.of(environmentLinks).map(c -> (EnvironmentLink)((EnvironmentLink.Builder)EnvironmentLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironmentLinks(Collection<EnvironmentLink.BuilderImpl> environmentLinks) {
            this.environmentLinks = EnvironmentLinksCopier.copyFromBuilder(environmentLinks);
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        public final String getOperationsRole() {
            return this.operationsRole;
        }

        @Override
        public final Builder operationsRole(String operationsRole) {
            this.operationsRole = operationsRole;
            return this;
        }

        public final void setOperationsRole(String operationsRole) {
            this.operationsRole = operationsRole;
        }

        @Override
        public CreateEnvironmentResponse build() {
            return new CreateEnvironmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentResponse> {
        public Builder environmentName(String var1);

        public Builder environmentId(String var1);

        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder endpointURL(String var1);

        public Builder cname(String var1);

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder abortableOperationInProgress(Boolean var1);

        public Builder health(String var1);

        public Builder health(EnvironmentHealth var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(EnvironmentHealthStatus var1);

        public Builder resources(EnvironmentResourcesDescription var1);

        default public Builder resources(Consumer<EnvironmentResourcesDescription.Builder> resources) {
            return this.resources((EnvironmentResourcesDescription)((EnvironmentResourcesDescription.Builder)EnvironmentResourcesDescription.builder().applyMutation(resources)).build());
        }

        public Builder tier(EnvironmentTier var1);

        default public Builder tier(Consumer<EnvironmentTier.Builder> tier) {
            return this.tier((EnvironmentTier)((EnvironmentTier.Builder)EnvironmentTier.builder().applyMutation(tier)).build());
        }

        public Builder environmentLinks(Collection<EnvironmentLink> var1);

        public Builder environmentLinks(EnvironmentLink ... var1);

        public Builder environmentLinks(Consumer<EnvironmentLink.Builder> ... var1);

        public Builder environmentArn(String var1);

        public Builder operationsRole(String var1);
    }
}

