/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedTierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlatformBranchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlatformBranchSummary> {
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformName").getter(PlatformBranchSummary.getter(PlatformBranchSummary::platformName)).setter(PlatformBranchSummary.setter(Builder::platformName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BranchName").getter(PlatformBranchSummary.getter(PlatformBranchSummary::branchName)).setter(PlatformBranchSummary.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchName").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifecycleState").getter(PlatformBranchSummary.getter(PlatformBranchSummary::lifecycleState)).setter(PlatformBranchSummary.setter(Builder::lifecycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleState").build()}).build();
    private static final SdkField<Integer> BRANCH_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BranchOrder").getter(PlatformBranchSummary.getter(PlatformBranchSummary::branchOrder)).setter(PlatformBranchSummary.setter(Builder::branchOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchOrder").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_TIER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedTierList").getter(PlatformBranchSummary.getter(PlatformBranchSummary::supportedTierList)).setter(PlatformBranchSummary.setter(Builder::supportedTierList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTierList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_NAME_FIELD, BRANCH_NAME_FIELD, LIFECYCLE_STATE_FIELD, BRANCH_ORDER_FIELD, SUPPORTED_TIER_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String platformName;
    private final String branchName;
    private final String lifecycleState;
    private final Integer branchOrder;
    private final List<String> supportedTierList;

    private PlatformBranchSummary(BuilderImpl builder) {
        this.platformName = builder.platformName;
        this.branchName = builder.branchName;
        this.lifecycleState = builder.lifecycleState;
        this.branchOrder = builder.branchOrder;
        this.supportedTierList = builder.supportedTierList;
    }

    public String platformName() {
        return this.platformName;
    }

    public String branchName() {
        return this.branchName;
    }

    public String lifecycleState() {
        return this.lifecycleState;
    }

    public Integer branchOrder() {
        return this.branchOrder;
    }

    public boolean hasSupportedTierList() {
        return this.supportedTierList != null && !(this.supportedTierList instanceof SdkAutoConstructList);
    }

    public List<String> supportedTierList() {
        return this.supportedTierList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformName());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleState());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedTierList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformBranchSummary)) {
            return false;
        }
        PlatformBranchSummary other = (PlatformBranchSummary)obj;
        return Objects.equals(this.platformName(), other.platformName()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.lifecycleState(), other.lifecycleState()) && Objects.equals(this.branchOrder(), other.branchOrder()) && Objects.equals(this.supportedTierList(), other.supportedTierList());
    }

    public String toString() {
        return ToString.builder((String)"PlatformBranchSummary").add("PlatformName", (Object)this.platformName()).add("BranchName", (Object)this.branchName()).add("LifecycleState", (Object)this.lifecycleState()).add("BranchOrder", (Object)this.branchOrder()).add("SupportedTierList", this.supportedTierList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformName": {
                return Optional.ofNullable(clazz.cast(this.platformName()));
            }
            case "BranchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "LifecycleState": {
                return Optional.ofNullable(clazz.cast(this.lifecycleState()));
            }
            case "BranchOrder": {
                return Optional.ofNullable(clazz.cast(this.branchOrder()));
            }
            case "SupportedTierList": {
                return Optional.ofNullable(clazz.cast(this.supportedTierList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlatformBranchSummary, T> g) {
        return obj -> g.apply((PlatformBranchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String platformName;
        private String branchName;
        private String lifecycleState;
        private Integer branchOrder;
        private List<String> supportedTierList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformBranchSummary model) {
            this.platformName(model.platformName);
            this.branchName(model.branchName);
            this.lifecycleState(model.lifecycleState);
            this.branchOrder(model.branchOrder);
            this.supportedTierList(model.supportedTierList);
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getLifecycleState() {
            return this.lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        public final Integer getBranchOrder() {
            return this.branchOrder;
        }

        @Override
        public final Builder branchOrder(Integer branchOrder) {
            this.branchOrder = branchOrder;
            return this;
        }

        public final void setBranchOrder(Integer branchOrder) {
            this.branchOrder = branchOrder;
        }

        public final Collection<String> getSupportedTierList() {
            return this.supportedTierList;
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String ... supportedTierList) {
            this.supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        public PlatformBranchSummary build() {
            return new PlatformBranchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlatformBranchSummary> {
        public Builder platformName(String var1);

        public Builder branchName(String var1);

        public Builder lifecycleState(String var1);

        public Builder branchOrder(Integer var1);

        public Builder supportedTierList(Collection<String> var1);

        public Builder supportedTierList(String ... var1);
    }
}

