/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error or warning for a desired configuration option value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationMessage.Builder, ValidationMessage> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ValidationMessage::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ValidationMessage::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ValidationMessage::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> OPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ValidationMessage::optionName)).setter(setter(Builder::optionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, SEVERITY_FIELD,
            NAMESPACE_FIELD, OPTION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String severity;

    private final String namespace;

    private final String optionName;

    private ValidationMessage(BuilderImpl builder) {
        this.message = builder.message;
        this.severity = builder.severity;
        this.namespace = builder.namespace;
        this.optionName = builder.optionName;
    }

    /**
     * <p>
     * A message describing the error or warning.
     * </p>
     * 
     * @return A message describing the error or warning.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * An indication of the severity of this message:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>error</code>: This message indicates that this is not a valid setting for an option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>warning</code>: This message is providing information you should take into account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ValidationSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return An indication of the severity of this message:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>error</code>: This message indicates that this is not a valid setting for an option.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>warning</code>: This message is providing information you should take into account.
     *         </p>
     *         </li>
     * @see ValidationSeverity
     */
    public ValidationSeverity severity() {
        return ValidationSeverity.fromValue(severity);
    }

    /**
     * <p>
     * An indication of the severity of this message:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>error</code>: This message indicates that this is not a valid setting for an option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>warning</code>: This message is providing information you should take into account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ValidationSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return An indication of the severity of this message:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>error</code>: This message indicates that this is not a valid setting for an option.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>warning</code>: This message is providing information you should take into account.
     *         </p>
     *         </li>
     * @see ValidationSeverity
     */
    public String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The namespace to which the option belongs.
     * </p>
     * 
     * @return The namespace to which the option belongs.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the option.
     * </p>
     * 
     * @return The name of the option.
     */
    public String optionName() {
        return optionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(optionName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationMessage)) {
            return false;
        }
        ValidationMessage other = (ValidationMessage) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(optionName(), other.optionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ValidationMessage").add("Message", message()).add("Severity", severityAsString())
                .add("Namespace", namespace()).add("OptionName", optionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "OptionName":
            return Optional.ofNullable(clazz.cast(optionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationMessage, T> g) {
        return obj -> g.apply((ValidationMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationMessage> {
        /**
         * <p>
         * A message describing the error or warning.
         * </p>
         * 
         * @param message
         *        A message describing the error or warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * An indication of the severity of this message:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>error</code>: This message indicates that this is not a valid setting for an option.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>warning</code>: This message is providing information you should take into account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param severity
         *        An indication of the severity of this message:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>error</code>: This message indicates that this is not a valid setting for an option.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>warning</code>: This message is providing information you should take into account.
         *        </p>
         *        </li>
         * @see ValidationSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * An indication of the severity of this message:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>error</code>: This message indicates that this is not a valid setting for an option.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>warning</code>: This message is providing information you should take into account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param severity
         *        An indication of the severity of this message:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>error</code>: This message indicates that this is not a valid setting for an option.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>warning</code>: This message is providing information you should take into account.
         *        </p>
         *        </li>
         * @see ValidationSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationSeverity
         */
        Builder severity(ValidationSeverity severity);

        /**
         * <p>
         * The namespace to which the option belongs.
         * </p>
         * 
         * @param namespace
         *        The namespace to which the option belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the option.
         * </p>
         * 
         * @param optionName
         *        The name of the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionName(String optionName);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String severity;

        private String namespace;

        private String optionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationMessage model) {
            message(model.message);
            severity(model.severity);
            namespace(model.namespace);
            optionName(model.optionName);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSeverity() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ValidationSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getOptionName() {
            return optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        @Override
        public ValidationMessage build() {
            return new ValidationMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
