/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<EventDescription.Builder, EventDescription> {
    private static final SdkField<Instant> EVENT_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(EventDescription::eventDate)).setter(setter(Builder::eventDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDate").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventDescription::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventDescription::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventDescription::versionLabel)).setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventDescription::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventDescription::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventDescription::platformArn)).setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventDescription::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EventDescription::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATE_FIELD,
            MESSAGE_FIELD, APPLICATION_NAME_FIELD, VERSION_LABEL_FIELD, TEMPLATE_NAME_FIELD, ENVIRONMENT_NAME_FIELD,
            PLATFORM_ARN_FIELD, REQUEST_ID_FIELD, SEVERITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant eventDate;

    private final String message;

    private final String applicationName;

    private final String versionLabel;

    private final String templateName;

    private final String environmentName;

    private final String platformArn;

    private final String requestId;

    private final String severity;

    private EventDescription(BuilderImpl builder) {
        this.eventDate = builder.eventDate;
        this.message = builder.message;
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
        this.platformArn = builder.platformArn;
        this.requestId = builder.requestId;
        this.severity = builder.severity;
    }

    /**
     * <p>
     * The date when the event occurred.
     * </p>
     * 
     * @return The date when the event occurred.
     */
    public Instant eventDate() {
        return eventDate;
    }

    /**
     * <p>
     * The event message.
     * </p>
     * 
     * @return The event message.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The application associated with the event.
     * </p>
     * 
     * @return The application associated with the event.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The release label for the application version associated with this event.
     * </p>
     * 
     * @return The release label for the application version associated with this event.
     */
    public String versionLabel() {
        return versionLabel;
    }

    /**
     * <p>
     * The name of the configuration associated with this event.
     * </p>
     * 
     * @return The name of the configuration associated with this event.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The name of the environment associated with this event.
     * </p>
     * 
     * @return The name of the environment associated with this event.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The ARN of the platform version.
     * </p>
     * 
     * @return The ARN of the platform version.
     */
    public String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * The web service request ID for the activity of this event.
     * </p>
     * 
     * @return The web service request ID for the activity of this event.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The severity level of this event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link EventSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity level of this event.
     * @see EventSeverity
     */
    public EventSeverity severity() {
        return EventSeverity.fromValue(severity);
    }

    /**
     * <p>
     * The severity level of this event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link EventSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity level of this event.
     * @see EventSeverity
     */
    public String severityAsString() {
        return severity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventDate());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDescription)) {
            return false;
        }
        EventDescription other = (EventDescription) obj;
        return Objects.equals(eventDate(), other.eventDate()) && Objects.equals(message(), other.message())
                && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(versionLabel(), other.versionLabel()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(platformArn(), other.platformArn()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(severityAsString(), other.severityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventDescription").add("EventDate", eventDate()).add("Message", message())
                .add("ApplicationName", applicationName()).add("VersionLabel", versionLabel())
                .add("TemplateName", templateName()).add("EnvironmentName", environmentName()).add("PlatformArn", platformArn())
                .add("RequestId", requestId()).add("Severity", severityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDate":
            return Optional.ofNullable(clazz.cast(eventDate()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventDescription, T> g) {
        return obj -> g.apply((EventDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventDescription> {
        /**
         * <p>
         * The date when the event occurred.
         * </p>
         * 
         * @param eventDate
         *        The date when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDate(Instant eventDate);

        /**
         * <p>
         * The event message.
         * </p>
         * 
         * @param message
         *        The event message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The application associated with the event.
         * </p>
         * 
         * @param applicationName
         *        The application associated with the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The release label for the application version associated with this event.
         * </p>
         * 
         * @param versionLabel
         *        The release label for the application version associated with this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);

        /**
         * <p>
         * The name of the configuration associated with this event.
         * </p>
         * 
         * @param templateName
         *        The name of the configuration associated with this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The name of the environment associated with this event.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment associated with this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The ARN of the platform version.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * The web service request ID for the activity of this event.
         * </p>
         * 
         * @param requestId
         *        The web service request ID for the activity of this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The severity level of this event.
         * </p>
         * 
         * @param severity
         *        The severity level of this event.
         * @see EventSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity level of this event.
         * </p>
         * 
         * @param severity
         *        The severity level of this event.
         * @see EventSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSeverity
         */
        Builder severity(EventSeverity severity);
    }

    static final class BuilderImpl implements Builder {
        private Instant eventDate;

        private String message;

        private String applicationName;

        private String versionLabel;

        private String templateName;

        private String environmentName;

        private String platformArn;

        private String requestId;

        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDescription model) {
            eventDate(model.eventDate);
            message(model.message);
            applicationName(model.applicationName);
            versionLabel(model.versionLabel);
            templateName(model.templateName);
            environmentName(model.environmentName);
            platformArn(model.platformArn);
            requestId(model.requestId);
            severity(model.severity);
        }

        public final Instant getEventDate() {
            return eventDate;
        }

        @Override
        public final Builder eventDate(Instant eventDate) {
            this.eventDate = eventDate;
            return this;
        }

        public final void setEventDate(Instant eventDate) {
            this.eventDate = eventDate;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getSeverity() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(EventSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public EventDescription build() {
            return new EventDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
