/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result message containing information about the managed action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplyEnvironmentManagedActionResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<ApplyEnvironmentManagedActionResponse.Builder, ApplyEnvironmentManagedActionResponse> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplyEnvironmentManagedActionResponse::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final SdkField<String> ACTION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplyEnvironmentManagedActionResponse::actionDescription)).setter(setter(Builder::actionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionDescription").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplyEnvironmentManagedActionResponse::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplyEnvironmentManagedActionResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            ACTION_DESCRIPTION_FIELD, ACTION_TYPE_FIELD, STATUS_FIELD));

    private final String actionId;

    private final String actionDescription;

    private final String actionType;

    private final String status;

    private ApplyEnvironmentManagedActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionId = builder.actionId;
        this.actionDescription = builder.actionDescription;
        this.actionType = builder.actionType;
        this.status = builder.status;
    }

    /**
     * <p>
     * The action ID of the managed action.
     * </p>
     * 
     * @return The action ID of the managed action.
     */
    public String actionId() {
        return actionId;
    }

    /**
     * <p>
     * A description of the managed action.
     * </p>
     * 
     * @return A description of the managed action.
     */
    public String actionDescription() {
        return actionDescription;
    }

    /**
     * <p>
     * The type of managed action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of managed action.
     * @see ActionType
     */
    public ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of managed action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of managed action.
     * @see ActionType
     */
    public String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The status of the managed action.
     * </p>
     * 
     * @return The status of the managed action.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyEnvironmentManagedActionResponse)) {
            return false;
        }
        ApplyEnvironmentManagedActionResponse other = (ApplyEnvironmentManagedActionResponse) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(actionDescription(), other.actionDescription())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplyEnvironmentManagedActionResponse").add("ActionId", actionId())
                .add("ActionDescription", actionDescription()).add("ActionType", actionTypeAsString()).add("Status", status())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "ActionDescription":
            return Optional.ofNullable(clazz.cast(actionDescription()));
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyEnvironmentManagedActionResponse, T> g) {
        return obj -> g.apply((ApplyEnvironmentManagedActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ApplyEnvironmentManagedActionResponse> {
        /**
         * <p>
         * The action ID of the managed action.
         * </p>
         * 
         * @param actionId
         *        The action ID of the managed action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * A description of the managed action.
         * </p>
         * 
         * @param actionDescription
         *        A description of the managed action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDescription(String actionDescription);

        /**
         * <p>
         * The type of managed action.
         * </p>
         * 
         * @param actionType
         *        The type of managed action.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of managed action.
         * </p>
         * 
         * @param actionType
         *        The type of managed action.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * The status of the managed action.
         * </p>
         * 
         * @param status
         *        The status of the managed action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private String actionId;

        private String actionDescription;

        private String actionType;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyEnvironmentManagedActionResponse model) {
            super(model);
            actionId(model.actionId);
            actionDescription(model.actionDescription);
            actionType(model.actionType);
            status(model.status);
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionDescription() {
            return actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getActionType() {
            return actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public ApplyEnvironmentManagedActionResponse build() {
            return new ApplyEnvironmentManagedActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
