/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.AbortEnvironmentUpdateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CodeBuildNotInServiceRegionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComposeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateStorageLocationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribePlatformVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkServiceException;
import software.amazon.awssdk.services.elasticbeanstalk.model.InsufficientPrivilegesException;
import software.amazon.awssdk.services.elasticbeanstalk.model.InvalidRequestException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionInvalidStateException;
import software.amazon.awssdk.services.elasticbeanstalk.model.OperationInProgressException;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformVersionStillReferencedException;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RebuildEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RestartAppServerResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3LocationNotInServiceRegionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3SubscriptionRequiredException;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBundleDeletionException;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.SwapEnvironmentCnamEsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyApplicationVersionsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyApplicationsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyBucketsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyConfigurationTemplatesException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyEnvironmentsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyPlatformsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateTagsForResourceResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable;
import software.amazon.awssdk.services.elasticbeanstalk.transform.AbortEnvironmentUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ApplyEnvironmentManagedActionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CheckDnsAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ComposeEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreatePlatformVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CreateStorageLocationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeleteEnvironmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeletePlatformVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeApplicationVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeApplicationsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeConfigurationOptionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeConfigurationSettingsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentManagedActionHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentManagedActionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentResourcesRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribeInstancesHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DescribePlatformVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListAvailableSolutionStacksRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListPlatformBranchesRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListPlatformVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RebuildEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RequestEnvironmentInfoRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RestartAppServerRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.RetrieveEnvironmentInfoRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.SwapEnvironmentCnamEsRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.TerminateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateApplicationResourceLifecycleRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateApplicationVersionRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.UpdateTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ValidateConfigurationSettingsRequestMarshaller;

/**
 * Internal implementation of {@link ElasticBeanstalkClient}.
 *
 * @see ElasticBeanstalkClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultElasticBeanstalkClient implements ElasticBeanstalkClient {
    private final SyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticBeanstalkClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Cancels in-progress environment configuration update or application version deployment.
     * </p>
     *
     * @param abortEnvironmentUpdateRequest
     * @return Result of the AbortEnvironmentUpdate operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.AbortEnvironmentUpdate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/AbortEnvironmentUpdate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AbortEnvironmentUpdateResponse abortEnvironmentUpdate(AbortEnvironmentUpdateRequest abortEnvironmentUpdateRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<AbortEnvironmentUpdateResponse> responseHandler = protocolFactory
                .createResponseHandler(AbortEnvironmentUpdateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AbortEnvironmentUpdateRequest, AbortEnvironmentUpdateResponse>()
                .withOperationName("AbortEnvironmentUpdate").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(abortEnvironmentUpdateRequest)
                .withMarshaller(new AbortEnvironmentUpdateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Applies a scheduled managed action immediately. A managed action can be applied only if its status is
     * <code>Scheduled</code>. Get the status and action ID of a managed action with
     * <a>DescribeEnvironmentManagedActions</a>.
     * </p>
     *
     * @param applyEnvironmentManagedActionRequest
     *        Request to execute a scheduled managed action immediately.
     * @return Result of the ApplyEnvironmentManagedAction operation returned by the service.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws ManagedActionInvalidStateException
     *         Cannot modify the managed action in its current state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ApplyEnvironmentManagedAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplyEnvironmentManagedAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ApplyEnvironmentManagedActionResponse applyEnvironmentManagedAction(
            ApplyEnvironmentManagedActionRequest applyEnvironmentManagedActionRequest) throws ElasticBeanstalkServiceException,
            ManagedActionInvalidStateException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<ApplyEnvironmentManagedActionResponse> responseHandler = protocolFactory
                .createResponseHandler(ApplyEnvironmentManagedActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ApplyEnvironmentManagedActionRequest, ApplyEnvironmentManagedActionResponse>()
                        .withOperationName("ApplyEnvironmentManagedAction").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(applyEnvironmentManagedActionRequest)
                        .withMarshaller(new ApplyEnvironmentManagedActionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Checks if the specified CNAME is available.
     * </p>
     *
     * @param checkDnsAvailabilityRequest
     *        Results message indicating whether a CNAME is available.
     * @return Result of the CheckDNSAvailability operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CheckDNSAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CheckDNSAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CheckDnsAvailabilityResponse checkDNSAvailability(CheckDnsAvailabilityRequest checkDnsAvailabilityRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<CheckDnsAvailabilityResponse> responseHandler = protocolFactory
                .createResponseHandler(CheckDnsAvailabilityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CheckDnsAvailabilityRequest, CheckDnsAvailabilityResponse>()
                .withOperationName("CheckDNSAvailability").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(checkDnsAvailabilityRequest)
                .withMarshaller(new CheckDnsAvailabilityRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Create or update a group of environments that each run a separate component of a single application. Takes a list
     * of version labels that specify application source bundles for each of the environments to create or update. The
     * name of each environment and other required information must be included in the source bundles in an environment
     * manifest named <code>env.yaml</code>. See <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html">Compose
     * Environments</a> for details.
     * </p>
     *
     * @param composeEnvironmentsRequest
     *        Request to create or update a group of environments.
     * @return Result of the ComposeEnvironments operation returned by the service.
     * @throws TooManyEnvironmentsException
     *         The specified account has reached its limit of environments.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ComposeEnvironments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ComposeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ComposeEnvironmentsResponse composeEnvironments(ComposeEnvironmentsRequest composeEnvironmentsRequest)
            throws TooManyEnvironmentsException, InsufficientPrivilegesException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {

        HttpResponseHandler<ComposeEnvironmentsResponse> responseHandler = protocolFactory
                .createResponseHandler(ComposeEnvironmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ComposeEnvironmentsRequest, ComposeEnvironmentsResponse>()
                .withOperationName("ComposeEnvironments").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(composeEnvironmentsRequest)
                .withMarshaller(new ComposeEnvironmentsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an application that has one configuration template named <code>default</code> and no application
     * versions.
     * </p>
     *
     * @param createApplicationRequest
     *        Request to create an application.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws TooManyApplicationsException
     *         The specified account has reached its limit of applications.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws TooManyApplicationsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<CreateApplicationResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateApplicationRequest, CreateApplicationResponse>()
                .withOperationName("CreateApplication").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createApplicationRequest)
                .withMarshaller(new CreateApplicationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an application version for the specified application. You can create an application version from a source
     * bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:
     * </p>
     * <p>
     * Specify a commit in an AWS CodeCommit repository with <code>SourceBuildInformation</code>.
     * </p>
     * <p>
     * Specify a build in an AWS CodeBuild with <code>SourceBuildInformation</code> and <code>BuildConfiguration</code>.
     * </p>
     * <p>
     * Specify a source bundle in S3 with <code>SourceBundle</code>
     * </p>
     * <p>
     * Omit both <code>SourceBuildInformation</code> and <code>SourceBundle</code> to use the default sample
     * application.
     * </p>
     * <note>
     * <p>
     * After you create an application version with a specified Amazon S3 bucket and key location, you can't change that
     * Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an
     * environment from the application version.
     * </p>
     * </note>
     *
     * @param createApplicationVersionRequest
     * @return Result of the CreateApplicationVersion operation returned by the service.
     * @throws TooManyApplicationsException
     *         The specified account has reached its limit of applications.
     * @throws TooManyApplicationVersionsException
     *         The specified account has reached its limit of application versions.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws S3LocationNotInServiceRegionException
     *         The specified S3 bucket does not belong to the S3 region in which the service is running. The following
     *         regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li>
     * @throws CodeBuildNotInServiceRegionException
     *         AWS CodeBuild is not available in the specified region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateApplicationVersionResponse createApplicationVersion(
            CreateApplicationVersionRequest createApplicationVersionRequest) throws TooManyApplicationsException,
            TooManyApplicationVersionsException, InsufficientPrivilegesException, S3LocationNotInServiceRegionException,
            CodeBuildNotInServiceRegionException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<CreateApplicationVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateApplicationVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CreateApplicationVersionRequest, CreateApplicationVersionResponse>()
                        .withOperationName("CreateApplicationVersion").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createApplicationVersionRequest)
                        .withMarshaller(new CreateApplicationVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk
     * application. You define application configuration settings in a configuration template. You can then use the
     * configuration template to deploy different versions of the application with the same configuration settings.
     * </p>
     * <p>
     * Templates aren't associated with any environment. The <code>EnvironmentName</code> response element is always
     * <code>null</code>.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeConfigurationSettings</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>ListAvailableSolutionStacks</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createConfigurationTemplateRequest
     *        Request to create a configuration template.
     * @return Result of the CreateConfigurationTemplate operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws TooManyConfigurationTemplatesException
     *         The specified account has reached its limit of configuration templates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateConfigurationTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConfigurationTemplateResponse createConfigurationTemplate(
            CreateConfigurationTemplateRequest createConfigurationTemplateRequest) throws InsufficientPrivilegesException,
            TooManyBucketsException, TooManyConfigurationTemplatesException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {

        HttpResponseHandler<CreateConfigurationTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateConfigurationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<CreateConfigurationTemplateRequest, CreateConfigurationTemplateResponse>()
                        .withOperationName("CreateConfigurationTemplate").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createConfigurationTemplateRequest)
                        .withMarshaller(new CreateConfigurationTemplateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.
     * </p>
     *
     * @param createEnvironmentRequest
     * @return Result of the CreateEnvironment operation returned by the service.
     * @throws TooManyEnvironmentsException
     *         The specified account has reached its limit of environments.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest createEnvironmentRequest)
            throws TooManyEnvironmentsException, InsufficientPrivilegesException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {

        HttpResponseHandler<CreateEnvironmentResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateEnvironmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateEnvironmentRequest, CreateEnvironmentResponse>()
                .withOperationName("CreateEnvironment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createEnvironmentRequest)
                .withMarshaller(new CreateEnvironmentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Create a new version of your custom platform.
     * </p>
     *
     * @param createPlatformVersionRequest
     *        Request to create a new platform version.
     * @return Result of the CreatePlatformVersion operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws TooManyPlatformsException
     *         You have exceeded the maximum number of allowed platforms associated with the account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreatePlatformVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreatePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePlatformVersionResponse createPlatformVersion(CreatePlatformVersionRequest createPlatformVersionRequest)
            throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, TooManyPlatformsException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<CreatePlatformVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreatePlatformVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreatePlatformVersionRequest, CreatePlatformVersionResponse>()
                .withOperationName("CreatePlatformVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createPlatformVersionRequest)
                .withMarshaller(new CreatePlatformVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk
     * environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in
     * a region. If the storage location already exists, <code>CreateStorageLocation</code> still returns the bucket
     * name but does not create a new bucket.
     * </p>
     *
     * @param createStorageLocationRequest
     * @return Result of the CreateStorageLocation operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws S3SubscriptionRequiredException
     *         The specified account does not have a subscription to Amazon S3.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.CreateStorageLocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateStorageLocation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStorageLocationResponse createStorageLocation(CreateStorageLocationRequest createStorageLocationRequest)
            throws TooManyBucketsException, S3SubscriptionRequiredException, InsufficientPrivilegesException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<CreateStorageLocationResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateStorageLocationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateStorageLocationRequest, CreateStorageLocationResponse>()
                .withOperationName("CreateStorageLocation").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createStorageLocationRequest)
                .withMarshaller(new CreateStorageLocationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the specified application along with all associated versions and configurations. The application versions
     * will not be deleted from your Amazon S3 bucket.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application that has a running environment.
     * </p>
     * </note>
     *
     * @param deleteApplicationRequest
     *        Request to delete an application.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws OperationInProgressException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DeleteApplicationResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteApplicationRequest, DeleteApplicationResponse>()
                .withOperationName("DeleteApplication").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteApplicationRequest)
                .withMarshaller(new DeleteApplicationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the specified version from the specified application.
     * </p>
     * <note>
     * <p>
     * You cannot delete an application version that is associated with a running environment.
     * </p>
     * </note>
     *
     * @param deleteApplicationVersionRequest
     *        Request to delete an application version.
     * @return Result of the DeleteApplicationVersion operation returned by the service.
     * @throws SourceBundleDeletionException
     *         Unable to delete the Amazon S3 source bundle associated with the application version. The application
     *         version was deleted successfully.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws S3LocationNotInServiceRegionException
     *         The specified S3 bucket does not belong to the S3 region in which the service is running. The following
     *         regions are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         IAD/us-east-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PDX/us-west-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DUB/eu-west-1
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApplicationVersionResponse deleteApplicationVersion(
            DeleteApplicationVersionRequest deleteApplicationVersionRequest) throws SourceBundleDeletionException,
            InsufficientPrivilegesException, OperationInProgressException, S3LocationNotInServiceRegionException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DeleteApplicationVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteApplicationVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeleteApplicationVersionRequest, DeleteApplicationVersionResponse>()
                        .withOperationName("DeleteApplicationVersion").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteApplicationVersionRequest)
                        .withMarshaller(new DeleteApplicationVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the specified configuration template.
     * </p>
     * <note>
     * <p>
     * When you launch an environment using a configuration template, the environment gets a copy of the template. You
     * can delete or modify the environment's copy of the template without affecting the running environment.
     * </p>
     * </note>
     *
     * @param deleteConfigurationTemplateRequest
     *        Request to delete a configuration template.
     * @return Result of the DeleteConfigurationTemplate operation returned by the service.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteConfigurationTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConfigurationTemplateResponse deleteConfigurationTemplate(
            DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) throws OperationInProgressException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DeleteConfigurationTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteConfigurationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeleteConfigurationTemplateRequest, DeleteConfigurationTemplateResponse>()
                        .withOperationName("DeleteConfigurationTemplate").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteConfigurationTemplateRequest)
                        .withMarshaller(new DeleteConfigurationTemplateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the draft configuration associated with the running environment.
     * </p>
     * <p>
     * Updating a running environment with any configuration changes creates a draft configuration set. You can get the
     * draft configuration using <a>DescribeConfigurationSettings</a> while the update is in progress or if the update
     * fails. The <code>DeploymentStatus</code> for the draft configuration indicates whether the deployment is in
     * process or has failed. The draft configuration remains in existence until it is deleted with this action.
     * </p>
     *
     * @param deleteEnvironmentConfigurationRequest
     *        Request to delete a draft environment configuration.
     * @return Result of the DeleteEnvironmentConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeleteEnvironmentConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeleteEnvironmentConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEnvironmentConfigurationResponse deleteEnvironmentConfiguration(
            DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DeleteEnvironmentConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteEnvironmentConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeleteEnvironmentConfigurationRequest, DeleteEnvironmentConfigurationResponse>()
                        .withOperationName("DeleteEnvironmentConfiguration").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteEnvironmentConfigurationRequest)
                        .withMarshaller(new DeleteEnvironmentConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the specified version of a custom platform.
     * </p>
     *
     * @param deletePlatformVersionRequest
     * @return Result of the DeletePlatformVersion operation returned by the service.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws PlatformVersionStillReferencedException
     *         You cannot delete the platform version because there are still environments running on it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DeletePlatformVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DeletePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePlatformVersionResponse deletePlatformVersion(DeletePlatformVersionRequest deletePlatformVersionRequest)
            throws OperationInProgressException, InsufficientPrivilegesException, ElasticBeanstalkServiceException,
            PlatformVersionStillReferencedException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DeletePlatformVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeletePlatformVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeletePlatformVersionRequest, DeletePlatformVersionResponse>()
                .withOperationName("DeletePlatformVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deletePlatformVersionRequest)
                .withMarshaller(new DeletePlatformVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
     * </p>
     * <p>
     * The result currently has one set of attributes—resource quotas.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws InsufficientPrivilegesException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeAccountAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeAccountAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                        .withOperationName("DescribeAccountAttributes").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountAttributesRequest)
                        .withMarshaller(new DescribeAccountAttributesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieve a list of application versions.
     * </p>
     *
     * @param describeApplicationVersionsRequest
     *        Request to describe application versions.
     * @return Result of the DescribeApplicationVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeApplicationVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeApplicationVersionsResponse describeApplicationVersions(
            DescribeApplicationVersionsRequest describeApplicationVersionsRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeApplicationVersionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeApplicationVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeApplicationVersionsRequest, DescribeApplicationVersionsResponse>()
                        .withOperationName("DescribeApplicationVersions").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeApplicationVersionsRequest)
                        .withMarshaller(new DescribeApplicationVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the descriptions of existing applications.
     * </p>
     *
     * @param describeApplicationsRequest
     *        Request to describe one or more applications.
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeApplicationsResponse describeApplications(DescribeApplicationsRequest describeApplicationsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeApplicationsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeApplicationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeApplicationsRequest, DescribeApplicationsResponse>()
                .withOperationName("DescribeApplications").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeApplicationsRequest)
                .withMarshaller(new DescribeApplicationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes the configuration options that are used in a particular configuration template or environment, or that
     * a specified solution stack defines. The description includes the values the options, their default values, and an
     * indication of the required action on a running environment if an option value is changed.
     * </p>
     *
     * @param describeConfigurationOptionsRequest
     *        Result message containing a list of application version descriptions.
     * @return Result of the DescribeConfigurationOptions operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeConfigurationOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationOptionsResponse describeConfigurationOptions(
            DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) throws TooManyBucketsException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeConfigurationOptionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeConfigurationOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeConfigurationOptionsRequest, DescribeConfigurationOptionsResponse>()
                        .withOperationName("DescribeConfigurationOptions").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeConfigurationOptionsRequest)
                        .withMarshaller(new DescribeConfigurationOptionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a description of the settings for the specified configuration set, that is, either a configuration
     * template or the configuration set associated with a running environment.
     * </p>
     * <p>
     * When describing the settings for the configuration set associated with a running environment, it is possible to
     * receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft
     * configuration of an environment that is either in the process of deployment or that failed to deploy.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DeleteEnvironmentConfiguration</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeConfigurationSettingsRequest
     *        Result message containing all of the configuration settings for a specified solution stack or
     *        configuration template.
     * @return Result of the DescribeConfigurationSettings operation returned by the service.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeConfigurationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationSettingsResponse describeConfigurationSettings(
            DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) throws TooManyBucketsException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeConfigurationSettingsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeConfigurationSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeConfigurationSettingsRequest, DescribeConfigurationSettingsResponse>()
                        .withOperationName("DescribeConfigurationSettings").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeConfigurationSettingsRequest)
                        .withMarshaller(new DescribeConfigurationSettingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the overall health of the specified environment. The <b>DescribeEnvironmentHealth</b>
     * operation is only available with AWS Elastic Beanstalk Enhanced Health.
     * </p>
     *
     * @param describeEnvironmentHealthRequest
     *        See the example below to learn how to create a request body.
     * @return Result of the DescribeEnvironmentHealth operation returned by the service.
     * @throws InvalidRequestException
     *         One or more input parameters is not valid. Please correct the input parameters and try the operation
     *         again.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentHealth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEnvironmentHealthResponse describeEnvironmentHealth(
            DescribeEnvironmentHealthRequest describeEnvironmentHealthRequest) throws InvalidRequestException,
            ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeEnvironmentHealthResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEnvironmentHealthResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeEnvironmentHealthRequest, DescribeEnvironmentHealthResponse>()
                        .withOperationName("DescribeEnvironmentHealth").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeEnvironmentHealthRequest)
                        .withMarshaller(new DescribeEnvironmentHealthRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists an environment's completed and failed managed actions.
     * </p>
     *
     * @param describeEnvironmentManagedActionHistoryRequest
     *        Request to list completed and failed managed actions.
     * @return Result of the DescribeEnvironmentManagedActionHistory operation returned by the service.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentManagedActionHistory
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActionHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEnvironmentManagedActionHistoryResponse describeEnvironmentManagedActionHistory(
            DescribeEnvironmentManagedActionHistoryRequest describeEnvironmentManagedActionHistoryRequest)
            throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeEnvironmentManagedActionHistoryResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEnvironmentManagedActionHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeEnvironmentManagedActionHistoryRequest, DescribeEnvironmentManagedActionHistoryResponse>()
                        .withOperationName("DescribeEnvironmentManagedActionHistory").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeEnvironmentManagedActionHistoryRequest)
                        .withMarshaller(new DescribeEnvironmentManagedActionHistoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists an environment's upcoming and in-progress managed actions.
     * </p>
     *
     * @param describeEnvironmentManagedActionsRequest
     *        Request to list an environment's upcoming and in-progress managed actions.
     * @return Result of the DescribeEnvironmentManagedActions operation returned by the service.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentManagedActions
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEnvironmentManagedActionsResponse describeEnvironmentManagedActions(
            DescribeEnvironmentManagedActionsRequest describeEnvironmentManagedActionsRequest)
            throws ElasticBeanstalkServiceException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeEnvironmentManagedActionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEnvironmentManagedActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeEnvironmentManagedActionsRequest, DescribeEnvironmentManagedActionsResponse>()
                        .withOperationName("DescribeEnvironmentManagedActions").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeEnvironmentManagedActionsRequest)
                        .withMarshaller(new DescribeEnvironmentManagedActionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns AWS resources for this environment.
     * </p>
     *
     * @param describeEnvironmentResourcesRequest
     *        Request to describe the resources in an environment.
     * @return Result of the DescribeEnvironmentResources operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironmentResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEnvironmentResourcesResponse describeEnvironmentResources(
            DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest) throws InsufficientPrivilegesException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeEnvironmentResourcesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEnvironmentResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeEnvironmentResourcesRequest, DescribeEnvironmentResourcesResponse>()
                        .withOperationName("DescribeEnvironmentResources").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describeEnvironmentResourcesRequest)
                        .withMarshaller(new DescribeEnvironmentResourcesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns descriptions for existing environments.
     * </p>
     *
     * @param describeEnvironmentsRequest
     *        Request to describe one or more environments.
     * @return Result of the DescribeEnvironments operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEnvironments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEnvironmentsResponse describeEnvironments(DescribeEnvironmentsRequest describeEnvironmentsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeEnvironmentsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEnvironmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeEnvironmentsRequest, DescribeEnvironmentsResponse>()
                .withOperationName("DescribeEnvironments").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeEnvironmentsRequest)
                .withMarshaller(new DescribeEnvironmentsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note>
     *
     * @param describeEventsRequest
     *        Request to retrieve a list of events for an environment.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                .withOperationName("DescribeEvents").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeEventsRequest)
                .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * </p>
     * <note>
     * <p>
     * This action returns the most recent 1,000 events from the specified <code>NextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     *        Request to retrieve a list of events for an environment.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return new DescribeEventsIterable(this, applyPaginatorUserAgent(describeEventsRequest));
    }

    /**
     * <p>
     * Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation
     * requires <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html">enhanced health
     * reporting</a>.
     * </p>
     *
     * @param describeInstancesHealthRequest
     *        Parameters for a call to <code>DescribeInstancesHealth</code>.
     * @return Result of the DescribeInstancesHealth operation returned by the service.
     * @throws InvalidRequestException
     *         One or more input parameters is not valid. Please correct the input parameters and try the operation
     *         again.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribeInstancesHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeInstancesHealth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstancesHealthResponse describeInstancesHealth(DescribeInstancesHealthRequest describeInstancesHealthRequest)
            throws InvalidRequestException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {

        HttpResponseHandler<DescribeInstancesHealthResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeInstancesHealthResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeInstancesHealthRequest, DescribeInstancesHealthResponse>()
                .withOperationName("DescribeInstancesHealth").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeInstancesHealthRequest)
                .withMarshaller(new DescribeInstancesHealthRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes a platform version. Provides full details. Compare to <a>ListPlatformVersions</a>, which provides
     * summary information about a list of platform versions.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @param describePlatformVersionRequest
     * @return Result of the DescribePlatformVersion operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.DescribePlatformVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribePlatformVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePlatformVersionResponse describePlatformVersion(DescribePlatformVersionRequest describePlatformVersionRequest)
            throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {

        HttpResponseHandler<DescribePlatformVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribePlatformVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribePlatformVersionRequest, DescribePlatformVersionResponse>()
                .withOperationName("DescribePlatformVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describePlatformVersionRequest)
                .withMarshaller(new DescribePlatformVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of the available solution stack names, with the public version first and then in reverse
     * chronological order.
     * </p>
     *
     * @param listAvailableSolutionStacksRequest
     * @return Result of the ListAvailableSolutionStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListAvailableSolutionStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListAvailableSolutionStacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAvailableSolutionStacksResponse listAvailableSolutionStacks(
            ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<ListAvailableSolutionStacksResponse> responseHandler = protocolFactory
                .createResponseHandler(ListAvailableSolutionStacksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ListAvailableSolutionStacksRequest, ListAvailableSolutionStacksResponse>()
                        .withOperationName("ListAvailableSolutionStacks").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listAvailableSolutionStacksRequest)
                        .withMarshaller(new ListAvailableSolutionStacksRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @param listPlatformBranchesRequest
     * @return Result of the ListPlatformBranches operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPlatformBranchesResponse listPlatformBranches(ListPlatformBranchesRequest listPlatformBranchesRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<ListPlatformBranchesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListPlatformBranchesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListPlatformBranchesRequest, ListPlatformBranchesResponse>()
                .withOperationName("ListPlatformBranches").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listPlatformBranchesRequest)
                .withMarshaller(new ListPlatformBranchesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each
     * platform branch.
     * </p>
     * <p>
     * For definitions of platform branch and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable responses = client.listPlatformBranchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable responses = client
     *             .listPlatformBranchesPaginator(request);
     *     for (software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.elasticbeanstalk.paginators.ListPlatformBranchesIterable responses = client.listPlatformBranchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformBranches(software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformBranchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlatformBranchesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformBranches"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPlatformBranchesIterable listPlatformBranchesPaginator(ListPlatformBranchesRequest listPlatformBranchesRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {
        return new ListPlatformBranchesIterable(this, applyPaginatorUserAgent(listPlatformBranchesRequest));
    }

    /**
     * <p>
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each
     * platform version. Compare to <a>DescribePlatformVersion</a>, which provides full details about a single platform
     * version.
     * </p>
     * <p>
     * For definitions of platform version and other platform-related terms, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary</a>.
     * </p>
     *
     * @param listPlatformVersionsRequest
     * @return Result of the ListPlatformVersions operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ElasticBeanstalkServiceException
     *         A generic service exception has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListPlatformVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListPlatformVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPlatformVersionsResponse listPlatformVersions(ListPlatformVersionsRequest listPlatformVersionsRequest)
            throws InsufficientPrivilegesException, ElasticBeanstalkServiceException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {

        HttpResponseHandler<ListPlatformVersionsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListPlatformVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListPlatformVersionsRequest, ListPlatformVersionsResponse>()
                .withOperationName("ListPlatformVersions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listPlatformVersionsRequest)
                .withMarshaller(new ListPlatformVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value
     * pairs.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws ResourceNotFoundException
     *         A resource doesn't exist for the specified Amazon Resource Name (ARN).
     * @throws ResourceTypeNotSupportedException
     *         The type of the specified Amazon Resource Name (ARN) isn't supported for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InsufficientPrivilegesException, ResourceNotFoundException, ResourceTypeNotSupportedException,
            AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a
     * specified environment and forces a restart.
     * </p>
     *
     * @param rebuildEnvironmentRequest
     * @return Result of the RebuildEnvironment operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RebuildEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RebuildEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RebuildEnvironmentResponse rebuildEnvironment(RebuildEnvironmentRequest rebuildEnvironmentRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<RebuildEnvironmentResponse> responseHandler = protocolFactory
                .createResponseHandler(RebuildEnvironmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RebuildEnvironmentRequest, RebuildEnvironmentResponse>()
                .withOperationName("RebuildEnvironment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(rebuildEnvironmentRequest)
                .withMarshaller(new RebuildEnvironmentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Initiates a request to compile the specified type of information of the deployed environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>tail</code> compiles the last lines from the application server log
     * files of every Amazon EC2 instance in your environment.
     * </p>
     * <p>
     * Setting the <code>InfoType</code> to <code>bundle</code> compresses the application server log files for every
     * Amazon EC2 instance into a <code>.zip</code> file. Legacy and .NET containers do not support bundle logs.
     * </p>
     * <p>
     * Use <a>RetrieveEnvironmentInfo</a> to obtain the set of logs.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RetrieveEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param requestEnvironmentInfoRequest
     *        Request to retrieve logs from an environment and store them in your Elastic Beanstalk storage bucket.
     * @return Result of the RequestEnvironmentInfo operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RequestEnvironmentInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RequestEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RequestEnvironmentInfoResponse requestEnvironmentInfo(RequestEnvironmentInfoRequest requestEnvironmentInfoRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<RequestEnvironmentInfoResponse> responseHandler = protocolFactory
                .createResponseHandler(RequestEnvironmentInfoResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RequestEnvironmentInfoRequest, RequestEnvironmentInfoResponse>()
                .withOperationName("RequestEnvironmentInfo").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(requestEnvironmentInfoRequest)
                .withMarshaller(new RequestEnvironmentInfoRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Causes the environment to restart the application container server running on each Amazon EC2 instance.
     * </p>
     *
     * @param restartAppServerRequest
     * @return Result of the RestartAppServer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RestartAppServer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RestartAppServer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestartAppServerResponse restartAppServer(RestartAppServerRequest restartAppServerRequest) throws AwsServiceException,
            SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<RestartAppServerResponse> responseHandler = protocolFactory
                .createResponseHandler(RestartAppServerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RestartAppServerRequest, RestartAppServerResponse>()
                .withOperationName("RestartAppServer").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(restartAppServerRequest)
                .withMarshaller(new RestartAppServerRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the compiled information from a <a>RequestEnvironmentInfo</a> request.
     * </p>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>RequestEnvironmentInfo</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param retrieveEnvironmentInfoRequest
     *        Request to download logs retrieved with <a>RequestEnvironmentInfo</a>.
     * @return Result of the RetrieveEnvironmentInfo operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.RetrieveEnvironmentInfo
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/RetrieveEnvironmentInfo"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RetrieveEnvironmentInfoResponse retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<RetrieveEnvironmentInfoResponse> responseHandler = protocolFactory
                .createResponseHandler(RetrieveEnvironmentInfoResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RetrieveEnvironmentInfoRequest, RetrieveEnvironmentInfoResponse>()
                .withOperationName("RetrieveEnvironmentInfo").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(retrieveEnvironmentInfoRequest)
                .withMarshaller(new RetrieveEnvironmentInfoRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Swaps the CNAMEs of two environments.
     * </p>
     *
     * @param swapEnvironmentCnamEsRequest
     *        Swaps the CNAMEs of two environments.
     * @return Result of the SwapEnvironmentCNAMEs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.SwapEnvironmentCNAMEs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/SwapEnvironmentCNAMEs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SwapEnvironmentCnamEsResponse swapEnvironmentCNAMEs(SwapEnvironmentCnamEsRequest swapEnvironmentCnamEsRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<SwapEnvironmentCnamEsResponse> responseHandler = protocolFactory
                .createResponseHandler(SwapEnvironmentCnamEsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SwapEnvironmentCnamEsRequest, SwapEnvironmentCnamEsResponse>()
                .withOperationName("SwapEnvironmentCNAMEs").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(swapEnvironmentCnamEsRequest)
                .withMarshaller(new SwapEnvironmentCnamEsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Terminates the specified environment.
     * </p>
     *
     * @param terminateEnvironmentRequest
     *        Request to terminate an environment.
     * @return Result of the TerminateEnvironment operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.TerminateEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/TerminateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TerminateEnvironmentResponse terminateEnvironment(TerminateEnvironmentRequest terminateEnvironmentRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<TerminateEnvironmentResponse> responseHandler = protocolFactory
                .createResponseHandler(TerminateEnvironmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<TerminateEnvironmentRequest, TerminateEnvironmentResponse>()
                .withOperationName("TerminateEnvironment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(terminateEnvironmentRequest)
                .withMarshaller(new TerminateEnvironmentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the specified application to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * these properties, specify an empty string.
     * </p>
     * </note>
     *
     * @param updateApplicationRequest
     *        Request to update an application.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<UpdateApplicationResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateApplicationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateApplicationRequest, UpdateApplicationResponse>()
                .withOperationName("UpdateApplication").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateApplicationRequest)
                .withMarshaller(new UpdateApplicationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Modifies lifecycle settings for an application.
     * </p>
     *
     * @param updateApplicationResourceLifecycleRequest
     * @return Result of the UpdateApplicationResourceLifecycle operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateApplicationResourceLifecycle
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationResourceLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApplicationResourceLifecycleResponse updateApplicationResourceLifecycle(
            UpdateApplicationResourceLifecycleRequest updateApplicationResourceLifecycleRequest)
            throws InsufficientPrivilegesException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<UpdateApplicationResourceLifecycleResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateApplicationResourceLifecycleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<UpdateApplicationResourceLifecycleRequest, UpdateApplicationResourceLifecycleResponse>()
                        .withOperationName("UpdateApplicationResourceLifecycle").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateApplicationResourceLifecycleRequest)
                        .withMarshaller(new UpdateApplicationResourceLifecycleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the specified application version to have the specified properties.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>description</code>) is not provided, the value remains unchanged. To clear
     * properties, specify an empty string.
     * </p>
     * </note>
     *
     * @param updateApplicationVersionRequest
     * @return Result of the UpdateApplicationVersion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApplicationVersionResponse updateApplicationVersion(
            UpdateApplicationVersionRequest updateApplicationVersionRequest) throws AwsServiceException, SdkClientException,
            ElasticBeanstalkException {

        HttpResponseHandler<UpdateApplicationVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateApplicationVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<UpdateApplicationVersionRequest, UpdateApplicationVersionResponse>()
                        .withOperationName("UpdateApplicationVersion").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateApplicationVersionRequest)
                        .withMarshaller(new UpdateApplicationVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the specified configuration template to have the specified properties or configuration option values.
     * </p>
     * <note>
     * <p>
     * If a property (for example, <code>ApplicationName</code>) is not provided, its value remains unchanged. To clear
     * such properties, specify an empty string.
     * </p>
     * </note>
     * <p>
     * Related Topics
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>DescribeConfigurationOptions</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateConfigurationTemplateRequest
     *        The result message containing the options for the specified solution stack.
     * @return Result of the UpdateConfigurationTemplate operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateConfigurationTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConfigurationTemplateResponse updateConfigurationTemplate(
            UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) throws InsufficientPrivilegesException,
            TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<UpdateConfigurationTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateConfigurationTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<UpdateConfigurationTemplateRequest, UpdateConfigurationTemplateResponse>()
                        .withOperationName("UpdateConfigurationTemplate").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateConfigurationTemplateRequest)
                        .withMarshaller(new UpdateConfigurationTemplateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the environment description, deploys a new application version, updates the configuration settings to an
     * entirely new configuration template, or updates select configuration option values in the running environment.
     * </p>
     * <p>
     * Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an
     * <code>InvalidParameterCombination</code> error.
     * </p>
     * <p>
     * When updating the configuration settings to a new template or individual settings, a draft configuration is
     * created and <a>DescribeConfigurationSettings</a> for this environment returns two setting descriptions with
     * different <code>DeploymentStatus</code> values.
     * </p>
     *
     * @param updateEnvironmentRequest
     *        Request to update an environment.
     * @return Result of the UpdateEnvironment operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateEnvironment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateEnvironment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest)
            throws InsufficientPrivilegesException, TooManyBucketsException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {

        HttpResponseHandler<UpdateEnvironmentResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateEnvironmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateEnvironmentRequest, UpdateEnvironmentResponse>()
                .withOperationName("UpdateEnvironment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateEnvironmentRequest)
                .withMarshaller(new UpdateEnvironmentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed:
     * <code>TagsToAdd</code> for tags to add or update, and <code>TagsToRemove</code>.
     * </p>
     * <p>
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see <a
     * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging
     * Application Resources</a>.
     * </p>
     * <p>
     * If you create a custom IAM user policy to control permission to this operation, specify one of the following two
     * virtual actions (or both) instead of the API operation name:
     * </p>
     * <dl>
     * <dt>elasticbeanstalk:AddTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tags to add in the
     * <code>TagsToAdd</code> parameter.
     * </p>
     * </dd>
     * <dt>elasticbeanstalk:RemoveTags</dt>
     * <dd>
     * <p>
     * Controls permission to call <code>UpdateTagsForResource</code> and pass a list of tag keys to remove in the
     * <code>TagsToRemove</code> parameter.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For details about creating a custom user policy, see <a href=
     * "https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies"
     * >Creating a Custom User Policy</a>.
     * </p>
     *
     * @param updateTagsForResourceRequest
     * @return Result of the UpdateTagsForResource operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws OperationInProgressException
     *         Unable to perform the specified operation because another operation that effects an element in this
     *         activity is already in progress.
     * @throws TooManyTagsException
     *         The number of tags in the resource would exceed the number of tags that each resource can have.</p>
     *         <p>
     *         To calculate this, the operation considers both the number of tags the resource already has and the tags
     *         this operation would add if it succeeded.
     * @throws ResourceNotFoundException
     *         A resource doesn't exist for the specified Amazon Resource Name (ARN).
     * @throws ResourceTypeNotSupportedException
     *         The type of the specified Amazon Resource Name (ARN) isn't supported for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.UpdateTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTagsForResourceResponse updateTagsForResource(UpdateTagsForResourceRequest updateTagsForResourceRequest)
            throws InsufficientPrivilegesException, OperationInProgressException, TooManyTagsException,
            ResourceNotFoundException, ResourceTypeNotSupportedException, AwsServiceException, SdkClientException,
            ElasticBeanstalkException {

        HttpResponseHandler<UpdateTagsForResourceResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateTagsForResourceRequest, UpdateTagsForResourceResponse>()
                .withOperationName("UpdateTagsForResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateTagsForResourceRequest)
                .withMarshaller(new UpdateTagsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Takes a set of configuration settings and either a configuration template or environment, and determines whether
     * those values are valid.
     * </p>
     * <p>
     * This action returns a list of messages indicating any errors or warnings associated with the selection of option
     * values.
     * </p>
     *
     * @param validateConfigurationSettingsRequest
     *        A list of validation messages for a specified configuration template.
     * @return Result of the ValidateConfigurationSettings operation returned by the service.
     * @throws InsufficientPrivilegesException
     *         The specified account does not have sufficient privileges for one or more AWS services.
     * @throws TooManyBucketsException
     *         The specified account has reached its limit of Amazon S3 buckets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticBeanstalkException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticBeanstalkClient.ValidateConfigurationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ValidateConfigurationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ValidateConfigurationSettingsResponse validateConfigurationSettings(
            ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) throws InsufficientPrivilegesException,
            TooManyBucketsException, AwsServiceException, SdkClientException, ElasticBeanstalkException {

        HttpResponseHandler<ValidateConfigurationSettingsResponse> responseHandler = protocolFactory
                .createResponseHandler(ValidateConfigurationSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ValidateConfigurationSettingsRequest, ValidateConfigurationSettingsResponse>()
                        .withOperationName("ValidateConfigurationSettings").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(validateConfigurationSettingsRequest)
                        .withMarshaller(new ValidateConfigurationSettingsRequestMarshaller(protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("S3LocationNotInServiceRegionException")
                                .exceptionBuilderSupplier(S3LocationNotInServiceRegionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ManagedActionInvalidStateException")
                                .exceptionBuilderSupplier(ManagedActionInvalidStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientPrivilegesException")
                                .exceptionBuilderSupplier(InsufficientPrivilegesException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyPlatformsException")
                                .exceptionBuilderSupplier(TooManyPlatformsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyApplicationVersionsException")
                                .exceptionBuilderSupplier(TooManyApplicationVersionsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeBuildNotInServiceRegionException")
                                .exceptionBuilderSupplier(CodeBuildNotInServiceRegionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("S3SubscriptionRequiredException")
                                .exceptionBuilderSupplier(S3SubscriptionRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceBundleDeletionFailure")
                                .exceptionBuilderSupplier(SourceBundleDeletionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyConfigurationTemplatesException")
                                .exceptionBuilderSupplier(TooManyConfigurationTemplatesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException")
                                .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyApplicationsException")
                                .exceptionBuilderSupplier(TooManyApplicationsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationInProgressFailure")
                                .exceptionBuilderSupplier(OperationInProgressException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyEnvironmentsException")
                                .exceptionBuilderSupplier(TooManyEnvironmentsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyBucketsException")
                                .exceptionBuilderSupplier(TooManyBucketsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ElasticBeanstalkServiceException")
                                .exceptionBuilderSupplier(ElasticBeanstalkServiceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PlatformVersionStillReferencedException")
                                .exceptionBuilderSupplier(PlatformVersionStillReferencedException::builder).httpStatusCode(400)
                                .build()).clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ElasticBeanstalkException::builder).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends ElasticBeanstalkRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
