/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Swaps the CNAMEs of two environments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SwapEnvironmentCnamEsRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<SwapEnvironmentCnamEsRequest.Builder, SwapEnvironmentCnamEsRequest> {
    private static final SdkField<String> SOURCE_ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SwapEnvironmentCnamEsRequest::sourceEnvironmentId)).setter(setter(Builder::sourceEnvironmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEnvironmentId").build())
            .build();

    private static final SdkField<String> SOURCE_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SwapEnvironmentCnamEsRequest::sourceEnvironmentName)).setter(setter(Builder::sourceEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEnvironmentName").build())
            .build();

    private static final SdkField<String> DESTINATION_ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SwapEnvironmentCnamEsRequest::destinationEnvironmentId))
            .setter(setter(Builder::destinationEnvironmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEnvironmentId").build())
            .build();

    private static final SdkField<String> DESTINATION_ENVIRONMENT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SwapEnvironmentCnamEsRequest::destinationEnvironmentName))
            .setter(setter(Builder::destinationEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEnvironmentName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ENVIRONMENT_ID_FIELD,
            SOURCE_ENVIRONMENT_NAME_FIELD, DESTINATION_ENVIRONMENT_ID_FIELD, DESTINATION_ENVIRONMENT_NAME_FIELD));

    private final String sourceEnvironmentId;

    private final String sourceEnvironmentName;

    private final String destinationEnvironmentId;

    private final String destinationEnvironmentName;

    private SwapEnvironmentCnamEsRequest(BuilderImpl builder) {
        super(builder);
        this.sourceEnvironmentId = builder.sourceEnvironmentId;
        this.sourceEnvironmentName = builder.sourceEnvironmentName;
        this.destinationEnvironmentId = builder.destinationEnvironmentId;
        this.destinationEnvironmentName = builder.destinationEnvironmentName;
    }

    /**
     * <p>
     * The ID of the source environment.
     * </p>
     * <p>
     * Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
     * <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
     * <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>.
     * </p>
     * 
     * @return The ID of the source environment.</p>
     *         <p>
     *         Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
     *         <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
     *         <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>.
     */
    public String sourceEnvironmentId() {
        return sourceEnvironmentId;
    }

    /**
     * <p>
     * The name of the source environment.
     * </p>
     * <p>
     * Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
     * <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
     * <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>.
     * </p>
     * 
     * @return The name of the source environment.</p>
     *         <p>
     *         Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
     *         <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
     *         <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>.
     */
    public String sourceEnvironmentName() {
        return sourceEnvironmentName;
    }

    /**
     * <p>
     * The ID of the destination environment.
     * </p>
     * <p>
     * Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
     * <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
     * <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>.
     * </p>
     * 
     * @return The ID of the destination environment.</p>
     *         <p>
     *         Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
     *         <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
     *         <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>.
     */
    public String destinationEnvironmentId() {
        return destinationEnvironmentId;
    }

    /**
     * <p>
     * The name of the destination environment.
     * </p>
     * <p>
     * Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
     * <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
     * <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>.
     * </p>
     * 
     * @return The name of the destination environment.</p>
     *         <p>
     *         Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
     *         <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
     *         <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>.
     */
    public String destinationEnvironmentName() {
        return destinationEnvironmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationEnvironmentName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwapEnvironmentCnamEsRequest)) {
            return false;
        }
        SwapEnvironmentCnamEsRequest other = (SwapEnvironmentCnamEsRequest) obj;
        return Objects.equals(sourceEnvironmentId(), other.sourceEnvironmentId())
                && Objects.equals(sourceEnvironmentName(), other.sourceEnvironmentName())
                && Objects.equals(destinationEnvironmentId(), other.destinationEnvironmentId())
                && Objects.equals(destinationEnvironmentName(), other.destinationEnvironmentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SwapEnvironmentCnamEsRequest").add("SourceEnvironmentId", sourceEnvironmentId())
                .add("SourceEnvironmentName", sourceEnvironmentName())
                .add("DestinationEnvironmentId", destinationEnvironmentId())
                .add("DestinationEnvironmentName", destinationEnvironmentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceEnvironmentId":
            return Optional.ofNullable(clazz.cast(sourceEnvironmentId()));
        case "SourceEnvironmentName":
            return Optional.ofNullable(clazz.cast(sourceEnvironmentName()));
        case "DestinationEnvironmentId":
            return Optional.ofNullable(clazz.cast(destinationEnvironmentId()));
        case "DestinationEnvironmentName":
            return Optional.ofNullable(clazz.cast(destinationEnvironmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SwapEnvironmentCnamEsRequest, T> g) {
        return obj -> g.apply((SwapEnvironmentCnamEsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SwapEnvironmentCnamEsRequest> {
        /**
         * <p>
         * The ID of the source environment.
         * </p>
         * <p>
         * Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
         * <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
         * <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>.
         * </p>
         * 
         * @param sourceEnvironmentId
         *        The ID of the source environment.</p>
         *        <p>
         *        Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
         *        <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
         *        <code>SourceEnvironmentId</code>, you must specify the <code>DestinationEnvironmentId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEnvironmentId(String sourceEnvironmentId);

        /**
         * <p>
         * The name of the source environment.
         * </p>
         * <p>
         * Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
         * <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
         * <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>.
         * </p>
         * 
         * @param sourceEnvironmentName
         *        The name of the source environment.</p>
         *        <p>
         *        Condition: You must specify at least the <code>SourceEnvironmentID</code> or the
         *        <code>SourceEnvironmentName</code>. You may also specify both. If you specify the
         *        <code>SourceEnvironmentName</code>, you must specify the <code>DestinationEnvironmentName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEnvironmentName(String sourceEnvironmentName);

        /**
         * <p>
         * The ID of the destination environment.
         * </p>
         * <p>
         * Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
         * <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
         * <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>.
         * </p>
         * 
         * @param destinationEnvironmentId
         *        The ID of the destination environment.</p>
         *        <p>
         *        Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
         *        <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
         *        <code>SourceEnvironmentId</code> with the <code>DestinationEnvironmentId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationEnvironmentId(String destinationEnvironmentId);

        /**
         * <p>
         * The name of the destination environment.
         * </p>
         * <p>
         * Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
         * <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
         * <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>.
         * </p>
         * 
         * @param destinationEnvironmentName
         *        The name of the destination environment.</p>
         *        <p>
         *        Condition: You must specify at least the <code>DestinationEnvironmentID</code> or the
         *        <code>DestinationEnvironmentName</code>. You may also specify both. You must specify the
         *        <code>SourceEnvironmentName</code> with the <code>DestinationEnvironmentName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationEnvironmentName(String destinationEnvironmentName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String sourceEnvironmentId;

        private String sourceEnvironmentName;

        private String destinationEnvironmentId;

        private String destinationEnvironmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(SwapEnvironmentCnamEsRequest model) {
            super(model);
            sourceEnvironmentId(model.sourceEnvironmentId);
            sourceEnvironmentName(model.sourceEnvironmentName);
            destinationEnvironmentId(model.destinationEnvironmentId);
            destinationEnvironmentName(model.destinationEnvironmentName);
        }

        public final String getSourceEnvironmentId() {
            return sourceEnvironmentId;
        }

        @Override
        public final Builder sourceEnvironmentId(String sourceEnvironmentId) {
            this.sourceEnvironmentId = sourceEnvironmentId;
            return this;
        }

        public final void setSourceEnvironmentId(String sourceEnvironmentId) {
            this.sourceEnvironmentId = sourceEnvironmentId;
        }

        public final String getSourceEnvironmentName() {
            return sourceEnvironmentName;
        }

        @Override
        public final Builder sourceEnvironmentName(String sourceEnvironmentName) {
            this.sourceEnvironmentName = sourceEnvironmentName;
            return this;
        }

        public final void setSourceEnvironmentName(String sourceEnvironmentName) {
            this.sourceEnvironmentName = sourceEnvironmentName;
        }

        public final String getDestinationEnvironmentId() {
            return destinationEnvironmentId;
        }

        @Override
        public final Builder destinationEnvironmentId(String destinationEnvironmentId) {
            this.destinationEnvironmentId = destinationEnvironmentId;
            return this;
        }

        public final void setDestinationEnvironmentId(String destinationEnvironmentId) {
            this.destinationEnvironmentId = destinationEnvironmentId;
        }

        public final String getDestinationEnvironmentName() {
            return destinationEnvironmentName;
        }

        @Override
        public final Builder destinationEnvironmentName(String destinationEnvironmentName) {
            this.destinationEnvironmentName = destinationEnvironmentName;
            return this;
        }

        public final void setDestinationEnvironmentName(String destinationEnvironmentName) {
            this.destinationEnvironmentName = destinationEnvironmentName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SwapEnvironmentCnamEsRequest build() {
            return new SwapEnvironmentCnamEsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
