/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to download logs retrieved with <a>RequestEnvironmentInfo</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrieveEnvironmentInfoRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<RetrieveEnvironmentInfoRequest.Builder, RetrieveEnvironmentInfoRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RetrieveEnvironmentInfoRequest::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RetrieveEnvironmentInfoRequest::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<String> INFO_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RetrieveEnvironmentInfoRequest::infoTypeAsString)).setter(setter(Builder::infoType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfoType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            ENVIRONMENT_NAME_FIELD, INFO_TYPE_FIELD));

    private final String environmentId;

    private final String environmentName;

    private final String infoType;

    private RetrieveEnvironmentInfoRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.infoType = builder.infoType;
    }

    /**
     * <p>
     * The ID of the data's environment.
     * </p>
     * <p>
     * If no such environment is found, returns an <code>InvalidParameterValue</code> error.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic
     * Beanstalk returns <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @return The ID of the data's environment.</p>
     *         <p>
     *         If no such environment is found, returns an <code>InvalidParameterValue</code> error.
     *         </p>
     *         <p>
     *         Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS
     *         Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
     */
    public String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The name of the data's environment.
     * </p>
     * <p>
     * If no such environment is found, returns an <code>InvalidParameterValue</code> error.
     * </p>
     * <p>
     * Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic
     * Beanstalk returns <code>MissingRequiredParameter</code> error.
     * </p>
     * 
     * @return The name of the data's environment.</p>
     *         <p>
     *         If no such environment is found, returns an <code>InvalidParameterValue</code> error.
     *         </p>
     *         <p>
     *         Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS
     *         Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The type of information to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #infoType} will
     * return {@link EnvironmentInfoType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #infoTypeAsString}.
     * </p>
     * 
     * @return The type of information to retrieve.
     * @see EnvironmentInfoType
     */
    public EnvironmentInfoType infoType() {
        return EnvironmentInfoType.fromValue(infoType);
    }

    /**
     * <p>
     * The type of information to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #infoType} will
     * return {@link EnvironmentInfoType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #infoTypeAsString}.
     * </p>
     * 
     * @return The type of information to retrieve.
     * @see EnvironmentInfoType
     */
    public String infoTypeAsString() {
        return infoType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(infoTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveEnvironmentInfoRequest)) {
            return false;
        }
        RetrieveEnvironmentInfoRequest other = (RetrieveEnvironmentInfoRequest) obj;
        return Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(infoTypeAsString(), other.infoTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RetrieveEnvironmentInfoRequest").add("EnvironmentId", environmentId())
                .add("EnvironmentName", environmentName()).add("InfoType", infoTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "InfoType":
            return Optional.ofNullable(clazz.cast(infoTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveEnvironmentInfoRequest, T> g) {
        return obj -> g.apply((RetrieveEnvironmentInfoRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RetrieveEnvironmentInfoRequest> {
        /**
         * <p>
         * The ID of the data's environment.
         * </p>
         * <p>
         * If no such environment is found, returns an <code>InvalidParameterValue</code> error.
         * </p>
         * <p>
         * Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS
         * Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * </p>
         * 
         * @param environmentId
         *        The ID of the data's environment.</p>
         *        <p>
         *        If no such environment is found, returns an <code>InvalidParameterValue</code> error.
         *        </p>
         *        <p>
         *        Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either,
         *        AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The name of the data's environment.
         * </p>
         * <p>
         * If no such environment is found, returns an <code>InvalidParameterValue</code> error.
         * </p>
         * <p>
         * Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS
         * Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * </p>
         * 
         * @param environmentName
         *        The name of the data's environment.</p>
         *        <p>
         *        If no such environment is found, returns an <code>InvalidParameterValue</code> error.
         *        </p>
         *        <p>
         *        Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either,
         *        AWS Elastic Beanstalk returns <code>MissingRequiredParameter</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The type of information to retrieve.
         * </p>
         * 
         * @param infoType
         *        The type of information to retrieve.
         * @see EnvironmentInfoType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentInfoType
         */
        Builder infoType(String infoType);

        /**
         * <p>
         * The type of information to retrieve.
         * </p>
         * 
         * @param infoType
         *        The type of information to retrieve.
         * @see EnvironmentInfoType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentInfoType
         */
        Builder infoType(EnvironmentInfoType infoType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String environmentName;

        private String infoType;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveEnvironmentInfoRequest model) {
            super(model);
            environmentId(model.environmentId);
            environmentName(model.environmentName);
            infoType(model.infoType);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getInfoTypeAsString() {
            return infoType;
        }

        @Override
        public final Builder infoType(String infoType) {
            this.infoType = infoType;
            return this;
        }

        @Override
        public final Builder infoType(EnvironmentInfoType infoType) {
            this.infoType(infoType == null ? null : infoType.toString());
            return this;
        }

        public final void setInfoType(String infoType) {
            this.infoType = infoType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetrieveEnvironmentInfoRequest build() {
            return new RetrieveEnvironmentInfoRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
