/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of per-resource AWS Elastic Beanstalk quotas associated with an AWS account. They reflect Elastic Beanstalk
 * resource limits for this account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceQuotas implements SdkPojo, Serializable, ToCopyableBuilder<ResourceQuotas.Builder, ResourceQuotas> {
    private static final SdkField<ResourceQuota> APPLICATION_QUOTA_FIELD = SdkField
            .<ResourceQuota> builder(MarshallingType.SDK_POJO).getter(getter(ResourceQuotas::applicationQuota))
            .setter(setter(Builder::applicationQuota)).constructor(ResourceQuota::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationQuota").build()).build();

    private static final SdkField<ResourceQuota> APPLICATION_VERSION_QUOTA_FIELD = SdkField
            .<ResourceQuota> builder(MarshallingType.SDK_POJO).getter(getter(ResourceQuotas::applicationVersionQuota))
            .setter(setter(Builder::applicationVersionQuota)).constructor(ResourceQuota::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionQuota").build())
            .build();

    private static final SdkField<ResourceQuota> ENVIRONMENT_QUOTA_FIELD = SdkField
            .<ResourceQuota> builder(MarshallingType.SDK_POJO).getter(getter(ResourceQuotas::environmentQuota))
            .setter(setter(Builder::environmentQuota)).constructor(ResourceQuota::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentQuota").build()).build();

    private static final SdkField<ResourceQuota> CONFIGURATION_TEMPLATE_QUOTA_FIELD = SdkField
            .<ResourceQuota> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceQuotas::configurationTemplateQuota))
            .setter(setter(Builder::configurationTemplateQuota))
            .constructor(ResourceQuota::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationTemplateQuota").build())
            .build();

    private static final SdkField<ResourceQuota> CUSTOM_PLATFORM_QUOTA_FIELD = SdkField
            .<ResourceQuota> builder(MarshallingType.SDK_POJO).getter(getter(ResourceQuotas::customPlatformQuota))
            .setter(setter(Builder::customPlatformQuota)).constructor(ResourceQuota::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPlatformQuota").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_QUOTA_FIELD,
            APPLICATION_VERSION_QUOTA_FIELD, ENVIRONMENT_QUOTA_FIELD, CONFIGURATION_TEMPLATE_QUOTA_FIELD,
            CUSTOM_PLATFORM_QUOTA_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResourceQuota applicationQuota;

    private final ResourceQuota applicationVersionQuota;

    private final ResourceQuota environmentQuota;

    private final ResourceQuota configurationTemplateQuota;

    private final ResourceQuota customPlatformQuota;

    private ResourceQuotas(BuilderImpl builder) {
        this.applicationQuota = builder.applicationQuota;
        this.applicationVersionQuota = builder.applicationVersionQuota;
        this.environmentQuota = builder.environmentQuota;
        this.configurationTemplateQuota = builder.configurationTemplateQuota;
        this.customPlatformQuota = builder.customPlatformQuota;
    }

    /**
     * <p>
     * The quota for applications in the AWS account.
     * </p>
     * 
     * @return The quota for applications in the AWS account.
     */
    public ResourceQuota applicationQuota() {
        return applicationQuota;
    }

    /**
     * <p>
     * The quota for application versions in the AWS account.
     * </p>
     * 
     * @return The quota for application versions in the AWS account.
     */
    public ResourceQuota applicationVersionQuota() {
        return applicationVersionQuota;
    }

    /**
     * <p>
     * The quota for environments in the AWS account.
     * </p>
     * 
     * @return The quota for environments in the AWS account.
     */
    public ResourceQuota environmentQuota() {
        return environmentQuota;
    }

    /**
     * <p>
     * The quota for configuration templates in the AWS account.
     * </p>
     * 
     * @return The quota for configuration templates in the AWS account.
     */
    public ResourceQuota configurationTemplateQuota() {
        return configurationTemplateQuota;
    }

    /**
     * <p>
     * The quota for custom platforms in the AWS account.
     * </p>
     * 
     * @return The quota for custom platforms in the AWS account.
     */
    public ResourceQuota customPlatformQuota() {
        return customPlatformQuota;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationQuota());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersionQuota());
        hashCode = 31 * hashCode + Objects.hashCode(environmentQuota());
        hashCode = 31 * hashCode + Objects.hashCode(configurationTemplateQuota());
        hashCode = 31 * hashCode + Objects.hashCode(customPlatformQuota());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceQuotas)) {
            return false;
        }
        ResourceQuotas other = (ResourceQuotas) obj;
        return Objects.equals(applicationQuota(), other.applicationQuota())
                && Objects.equals(applicationVersionQuota(), other.applicationVersionQuota())
                && Objects.equals(environmentQuota(), other.environmentQuota())
                && Objects.equals(configurationTemplateQuota(), other.configurationTemplateQuota())
                && Objects.equals(customPlatformQuota(), other.customPlatformQuota());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceQuotas").add("ApplicationQuota", applicationQuota())
                .add("ApplicationVersionQuota", applicationVersionQuota()).add("EnvironmentQuota", environmentQuota())
                .add("ConfigurationTemplateQuota", configurationTemplateQuota())
                .add("CustomPlatformQuota", customPlatformQuota()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationQuota":
            return Optional.ofNullable(clazz.cast(applicationQuota()));
        case "ApplicationVersionQuota":
            return Optional.ofNullable(clazz.cast(applicationVersionQuota()));
        case "EnvironmentQuota":
            return Optional.ofNullable(clazz.cast(environmentQuota()));
        case "ConfigurationTemplateQuota":
            return Optional.ofNullable(clazz.cast(configurationTemplateQuota()));
        case "CustomPlatformQuota":
            return Optional.ofNullable(clazz.cast(customPlatformQuota()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceQuotas, T> g) {
        return obj -> g.apply((ResourceQuotas) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceQuotas> {
        /**
         * <p>
         * The quota for applications in the AWS account.
         * </p>
         * 
         * @param applicationQuota
         *        The quota for applications in the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationQuota(ResourceQuota applicationQuota);

        /**
         * <p>
         * The quota for applications in the AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceQuota.Builder} avoiding the need to
         * create one manually via {@link ResourceQuota#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuota.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationQuota(ResourceQuota)}.
         * 
         * @param applicationQuota
         *        a consumer that will call methods on {@link ResourceQuota.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationQuota(ResourceQuota)
         */
        default Builder applicationQuota(Consumer<ResourceQuota.Builder> applicationQuota) {
            return applicationQuota(ResourceQuota.builder().applyMutation(applicationQuota).build());
        }

        /**
         * <p>
         * The quota for application versions in the AWS account.
         * </p>
         * 
         * @param applicationVersionQuota
         *        The quota for application versions in the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersionQuota(ResourceQuota applicationVersionQuota);

        /**
         * <p>
         * The quota for application versions in the AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceQuota.Builder} avoiding the need to
         * create one manually via {@link ResourceQuota#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuota.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationVersionQuota(ResourceQuota)}.
         * 
         * @param applicationVersionQuota
         *        a consumer that will call methods on {@link ResourceQuota.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationVersionQuota(ResourceQuota)
         */
        default Builder applicationVersionQuota(Consumer<ResourceQuota.Builder> applicationVersionQuota) {
            return applicationVersionQuota(ResourceQuota.builder().applyMutation(applicationVersionQuota).build());
        }

        /**
         * <p>
         * The quota for environments in the AWS account.
         * </p>
         * 
         * @param environmentQuota
         *        The quota for environments in the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentQuota(ResourceQuota environmentQuota);

        /**
         * <p>
         * The quota for environments in the AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceQuota.Builder} avoiding the need to
         * create one manually via {@link ResourceQuota#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuota.Builder#build()} is called immediately and its
         * result is passed to {@link #environmentQuota(ResourceQuota)}.
         * 
         * @param environmentQuota
         *        a consumer that will call methods on {@link ResourceQuota.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentQuota(ResourceQuota)
         */
        default Builder environmentQuota(Consumer<ResourceQuota.Builder> environmentQuota) {
            return environmentQuota(ResourceQuota.builder().applyMutation(environmentQuota).build());
        }

        /**
         * <p>
         * The quota for configuration templates in the AWS account.
         * </p>
         * 
         * @param configurationTemplateQuota
         *        The quota for configuration templates in the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationTemplateQuota(ResourceQuota configurationTemplateQuota);

        /**
         * <p>
         * The quota for configuration templates in the AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceQuota.Builder} avoiding the need to
         * create one manually via {@link ResourceQuota#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuota.Builder#build()} is called immediately and its
         * result is passed to {@link #configurationTemplateQuota(ResourceQuota)}.
         * 
         * @param configurationTemplateQuota
         *        a consumer that will call methods on {@link ResourceQuota.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationTemplateQuota(ResourceQuota)
         */
        default Builder configurationTemplateQuota(Consumer<ResourceQuota.Builder> configurationTemplateQuota) {
            return configurationTemplateQuota(ResourceQuota.builder().applyMutation(configurationTemplateQuota).build());
        }

        /**
         * <p>
         * The quota for custom platforms in the AWS account.
         * </p>
         * 
         * @param customPlatformQuota
         *        The quota for custom platforms in the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPlatformQuota(ResourceQuota customPlatformQuota);

        /**
         * <p>
         * The quota for custom platforms in the AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceQuota.Builder} avoiding the need to
         * create one manually via {@link ResourceQuota#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuota.Builder#build()} is called immediately and its
         * result is passed to {@link #customPlatformQuota(ResourceQuota)}.
         * 
         * @param customPlatformQuota
         *        a consumer that will call methods on {@link ResourceQuota.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPlatformQuota(ResourceQuota)
         */
        default Builder customPlatformQuota(Consumer<ResourceQuota.Builder> customPlatformQuota) {
            return customPlatformQuota(ResourceQuota.builder().applyMutation(customPlatformQuota).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceQuota applicationQuota;

        private ResourceQuota applicationVersionQuota;

        private ResourceQuota environmentQuota;

        private ResourceQuota configurationTemplateQuota;

        private ResourceQuota customPlatformQuota;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceQuotas model) {
            applicationQuota(model.applicationQuota);
            applicationVersionQuota(model.applicationVersionQuota);
            environmentQuota(model.environmentQuota);
            configurationTemplateQuota(model.configurationTemplateQuota);
            customPlatformQuota(model.customPlatformQuota);
        }

        public final ResourceQuota.Builder getApplicationQuota() {
            return applicationQuota != null ? applicationQuota.toBuilder() : null;
        }

        @Override
        public final Builder applicationQuota(ResourceQuota applicationQuota) {
            this.applicationQuota = applicationQuota;
            return this;
        }

        public final void setApplicationQuota(ResourceQuota.BuilderImpl applicationQuota) {
            this.applicationQuota = applicationQuota != null ? applicationQuota.build() : null;
        }

        public final ResourceQuota.Builder getApplicationVersionQuota() {
            return applicationVersionQuota != null ? applicationVersionQuota.toBuilder() : null;
        }

        @Override
        public final Builder applicationVersionQuota(ResourceQuota applicationVersionQuota) {
            this.applicationVersionQuota = applicationVersionQuota;
            return this;
        }

        public final void setApplicationVersionQuota(ResourceQuota.BuilderImpl applicationVersionQuota) {
            this.applicationVersionQuota = applicationVersionQuota != null ? applicationVersionQuota.build() : null;
        }

        public final ResourceQuota.Builder getEnvironmentQuota() {
            return environmentQuota != null ? environmentQuota.toBuilder() : null;
        }

        @Override
        public final Builder environmentQuota(ResourceQuota environmentQuota) {
            this.environmentQuota = environmentQuota;
            return this;
        }

        public final void setEnvironmentQuota(ResourceQuota.BuilderImpl environmentQuota) {
            this.environmentQuota = environmentQuota != null ? environmentQuota.build() : null;
        }

        public final ResourceQuota.Builder getConfigurationTemplateQuota() {
            return configurationTemplateQuota != null ? configurationTemplateQuota.toBuilder() : null;
        }

        @Override
        public final Builder configurationTemplateQuota(ResourceQuota configurationTemplateQuota) {
            this.configurationTemplateQuota = configurationTemplateQuota;
            return this;
        }

        public final void setConfigurationTemplateQuota(ResourceQuota.BuilderImpl configurationTemplateQuota) {
            this.configurationTemplateQuota = configurationTemplateQuota != null ? configurationTemplateQuota.build() : null;
        }

        public final ResourceQuota.Builder getCustomPlatformQuota() {
            return customPlatformQuota != null ? customPlatformQuota.toBuilder() : null;
        }

        @Override
        public final Builder customPlatformQuota(ResourceQuota customPlatformQuota) {
            this.customPlatformQuota = customPlatformQuota;
            return this;
        }

        public final void setCustomPlatformQuota(ResourceQuota.BuilderImpl customPlatformQuota) {
            this.customPlatformQuota = customPlatformQuota != null ? customPlatformQuota.build() : null;
        }

        @Override
        public ResourceQuotas build() {
            return new ResourceQuotas(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
