/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify criteria to restrict the results when listing custom platforms.
 * </p>
 * <p>
 * The filter is evaluated as the expression:
 * </p>
 * <p>
 * <code>Type</code> <code>Operator</code> <code>Values[i]</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlatformFilter implements SdkPojo, Serializable, ToCopyableBuilder<PlatformFilter.Builder, PlatformFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformFilter::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformFilter::operator)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PlatformFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, OPERATOR_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String operator;

    private final List<String> values;

    private PlatformFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    /**
     * <p>
     * The custom platform attribute to which the filter values are applied.
     * </p>
     * <p>
     * Valid Values: <code>PlatformName</code> | <code>PlatformVersion</code> | <code>PlatformStatus</code> |
     * <code>PlatformOwner</code>
     * </p>
     * 
     * @return The custom platform attribute to which the filter values are applied.</p>
     *         <p>
     *         Valid Values: <code>PlatformName</code> | <code>PlatformVersion</code> | <code>PlatformStatus</code> |
     *         <code>PlatformOwner</code>
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The operator to apply to the <code>Type</code> with each of the <code>Values</code>.
     * </p>
     * <p>
     * Valid Values: <code>=</code> (equal to) | <code>!=</code> (not equal to) | <code>&lt;</code> (less than) |
     * <code>&lt;=</code> (less than or equal to) | <code>&gt;</code> (greater than) | <code>&gt;=</code> (greater than
     * or equal to) | <code>contains</code> | <code>begins_with</code> | <code>ends_with</code>
     * </p>
     * 
     * @return The operator to apply to the <code>Type</code> with each of the <code>Values</code>.</p>
     *         <p>
     *         Valid Values: <code>=</code> (equal to) | <code>!=</code> (not equal to) | <code>&lt;</code> (less than)
     *         | <code>&lt;=</code> (less than or equal to) | <code>&gt;</code> (greater than) | <code>&gt;=</code>
     *         (greater than or equal to) | <code>contains</code> | <code>begins_with</code> | <code>ends_with</code>
     */
    public String operator() {
        return operator;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values applied to the custom platform attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of values applied to the custom platform attribute.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformFilter)) {
            return false;
        }
        PlatformFilter other = (PlatformFilter) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(operator(), other.operator())
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlatformFilter").add("Type", type()).add("Operator", operator()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operator()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlatformFilter, T> g) {
        return obj -> g.apply((PlatformFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlatformFilter> {
        /**
         * <p>
         * The custom platform attribute to which the filter values are applied.
         * </p>
         * <p>
         * Valid Values: <code>PlatformName</code> | <code>PlatformVersion</code> | <code>PlatformStatus</code> |
         * <code>PlatformOwner</code>
         * </p>
         * 
         * @param type
         *        The custom platform attribute to which the filter values are applied.</p>
         *        <p>
         *        Valid Values: <code>PlatformName</code> | <code>PlatformVersion</code> | <code>PlatformStatus</code> |
         *        <code>PlatformOwner</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The operator to apply to the <code>Type</code> with each of the <code>Values</code>.
         * </p>
         * <p>
         * Valid Values: <code>=</code> (equal to) | <code>!=</code> (not equal to) | <code>&lt;</code> (less than) |
         * <code>&lt;=</code> (less than or equal to) | <code>&gt;</code> (greater than) | <code>&gt;=</code> (greater
         * than or equal to) | <code>contains</code> | <code>begins_with</code> | <code>ends_with</code>
         * </p>
         * 
         * @param operator
         *        The operator to apply to the <code>Type</code> with each of the <code>Values</code>.</p>
         *        <p>
         *        Valid Values: <code>=</code> (equal to) | <code>!=</code> (not equal to) | <code>&lt;</code> (less
         *        than) | <code>&lt;=</code> (less than or equal to) | <code>&gt;</code> (greater than) |
         *        <code>&gt;=</code> (greater than or equal to) | <code>contains</code> | <code>begins_with</code> |
         *        <code>ends_with</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(String operator);

        /**
         * <p>
         * The list of values applied to the custom platform attribute.
         * </p>
         * 
         * @param values
         *        The list of values applied to the custom platform attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The list of values applied to the custom platform attribute.
         * </p>
         * 
         * @param values
         *        The list of values applied to the custom platform attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String operator;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformFilter model) {
            type(model.type);
            operator(model.operator);
            values(model.values);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOperator() {
            return operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = PlatformFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = PlatformFilterValueListCopier.copy(values);
        }

        @Override
        public PlatformFilter build() {
            return new PlatformFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
