/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a platform.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlatformDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PlatformDescription.Builder, PlatformDescription> {
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::platformArn)).setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<String> PLATFORM_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::platformOwner)).setter(setter(Builder::platformOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformOwner").build()).build();

    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::platformName)).setter(setter(Builder::platformName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::solutionStackName)).setter(setter(Builder::solutionStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()).build();

    private static final SdkField<String> PLATFORM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::platformStatusAsString)).setter(setter(Builder::platformStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformStatus").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PlatformDescription::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PlatformDescription::dateUpdated)).setter(setter(Builder::dateUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()).build();

    private static final SdkField<String> PLATFORM_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::platformCategory)).setter(setter(Builder::platformCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformCategory").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> MAINTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::maintainer)).setter(setter(Builder::maintainer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maintainer").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::operatingSystemName)).setter(setter(Builder::operatingSystemName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemName").build())
            .build();

    private static final SdkField<String> OPERATING_SYSTEM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlatformDescription::operatingSystemVersion)).setter(setter(Builder::operatingSystemVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemVersion").build())
            .build();

    private static final SdkField<List<PlatformProgrammingLanguage>> PROGRAMMING_LANGUAGES_FIELD = SdkField
            .<List<PlatformProgrammingLanguage>> builder(MarshallingType.LIST)
            .getter(getter(PlatformDescription::programmingLanguages))
            .setter(setter(Builder::programmingLanguages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgrammingLanguages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformProgrammingLanguage> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformProgrammingLanguage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlatformFramework>> FRAMEWORKS_FIELD = SdkField
            .<List<PlatformFramework>> builder(MarshallingType.LIST)
            .getter(getter(PlatformDescription::frameworks))
            .setter(setter(Builder::frameworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frameworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformFramework> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformFramework::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CustomAmi>> CUSTOM_AMI_LIST_FIELD = SdkField
            .<List<CustomAmi>> builder(MarshallingType.LIST)
            .getter(getter(PlatformDescription::customAmiList))
            .setter(setter(Builder::customAmiList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAmiList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomAmi> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomAmi::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_TIER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PlatformDescription::supportedTierList))
            .setter(setter(Builder::supportedTierList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTierList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_ADDON_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PlatformDescription::supportedAddonList))
            .setter(setter(Builder::supportedAddonList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedAddonList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_ARN_FIELD,
            PLATFORM_OWNER_FIELD, PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, SOLUTION_STACK_NAME_FIELD, PLATFORM_STATUS_FIELD,
            DATE_CREATED_FIELD, DATE_UPDATED_FIELD, PLATFORM_CATEGORY_FIELD, DESCRIPTION_FIELD, MAINTAINER_FIELD,
            OPERATING_SYSTEM_NAME_FIELD, OPERATING_SYSTEM_VERSION_FIELD, PROGRAMMING_LANGUAGES_FIELD, FRAMEWORKS_FIELD,
            CUSTOM_AMI_LIST_FIELD, SUPPORTED_TIER_LIST_FIELD, SUPPORTED_ADDON_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String platformArn;

    private final String platformOwner;

    private final String platformName;

    private final String platformVersion;

    private final String solutionStackName;

    private final String platformStatus;

    private final Instant dateCreated;

    private final Instant dateUpdated;

    private final String platformCategory;

    private final String description;

    private final String maintainer;

    private final String operatingSystemName;

    private final String operatingSystemVersion;

    private final List<PlatformProgrammingLanguage> programmingLanguages;

    private final List<PlatformFramework> frameworks;

    private final List<CustomAmi> customAmiList;

    private final List<String> supportedTierList;

    private final List<String> supportedAddonList;

    private PlatformDescription(BuilderImpl builder) {
        this.platformArn = builder.platformArn;
        this.platformOwner = builder.platformOwner;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.solutionStackName = builder.solutionStackName;
        this.platformStatus = builder.platformStatus;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.platformCategory = builder.platformCategory;
        this.description = builder.description;
        this.maintainer = builder.maintainer;
        this.operatingSystemName = builder.operatingSystemName;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.programmingLanguages = builder.programmingLanguages;
        this.frameworks = builder.frameworks;
        this.customAmiList = builder.customAmiList;
        this.supportedTierList = builder.supportedTierList;
        this.supportedAddonList = builder.supportedAddonList;
    }

    /**
     * <p>
     * The ARN of the platform.
     * </p>
     * 
     * @return The ARN of the platform.
     */
    public String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * The AWS account ID of the person who created the platform.
     * </p>
     * 
     * @return The AWS account ID of the person who created the platform.
     */
    public String platformOwner() {
        return platformOwner;
    }

    /**
     * <p>
     * The name of the platform.
     * </p>
     * 
     * @return The name of the platform.
     */
    public String platformName() {
        return platformName;
    }

    /**
     * <p>
     * The version of the platform.
     * </p>
     * 
     * @return The version of the platform.
     */
    public String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The name of the solution stack used by the platform.
     * </p>
     * 
     * @return The name of the solution stack used by the platform.
     */
    public String solutionStackName() {
        return solutionStackName;
    }

    /**
     * <p>
     * The status of the platform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformStatus}
     * will return {@link PlatformStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformStatusAsString}.
     * </p>
     * 
     * @return The status of the platform.
     * @see PlatformStatus
     */
    public PlatformStatus platformStatus() {
        return PlatformStatus.fromValue(platformStatus);
    }

    /**
     * <p>
     * The status of the platform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformStatus}
     * will return {@link PlatformStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformStatusAsString}.
     * </p>
     * 
     * @return The status of the platform.
     * @see PlatformStatus
     */
    public String platformStatusAsString() {
        return platformStatus;
    }

    /**
     * <p>
     * The date when the platform was created.
     * </p>
     * 
     * @return The date when the platform was created.
     */
    public Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date when the platform was last updated.
     * </p>
     * 
     * @return The date when the platform was last updated.
     */
    public Instant dateUpdated() {
        return dateUpdated;
    }

    /**
     * <p>
     * The category of the platform.
     * </p>
     * 
     * @return The category of the platform.
     */
    public String platformCategory() {
        return platformCategory;
    }

    /**
     * <p>
     * The description of the platform.
     * </p>
     * 
     * @return The description of the platform.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Information about the maintainer of the platform.
     * </p>
     * 
     * @return Information about the maintainer of the platform.
     */
    public String maintainer() {
        return maintainer;
    }

    /**
     * <p>
     * The operating system used by the platform.
     * </p>
     * 
     * @return The operating system used by the platform.
     */
    public String operatingSystemName() {
        return operatingSystemName;
    }

    /**
     * <p>
     * The version of the operating system used by the platform.
     * </p>
     * 
     * @return The version of the operating system used by the platform.
     */
    public String operatingSystemVersion() {
        return operatingSystemVersion;
    }

    /**
     * Returns true if the ProgrammingLanguages property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProgrammingLanguages() {
        return programmingLanguages != null && !(programmingLanguages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The programming languages supported by the platform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProgrammingLanguages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The programming languages supported by the platform.
     */
    public List<PlatformProgrammingLanguage> programmingLanguages() {
        return programmingLanguages;
    }

    /**
     * Returns true if the Frameworks property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFrameworks() {
        return frameworks != null && !(frameworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The frameworks supported by the platform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFrameworks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The frameworks supported by the platform.
     */
    public List<PlatformFramework> frameworks() {
        return frameworks;
    }

    /**
     * Returns true if the CustomAmiList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCustomAmiList() {
        return customAmiList != null && !(customAmiList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom AMIs supported by the platform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomAmiList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The custom AMIs supported by the platform.
     */
    public List<CustomAmi> customAmiList() {
        return customAmiList;
    }

    /**
     * Returns true if the SupportedTierList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSupportedTierList() {
        return supportedTierList != null && !(supportedTierList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tiers supported by the platform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedTierList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tiers supported by the platform.
     */
    public List<String> supportedTierList() {
        return supportedTierList;
    }

    /**
     * Returns true if the SupportedAddonList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSupportedAddonList() {
        return supportedAddonList != null && !(supportedAddonList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The additions supported by the platform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedAddonList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The additions supported by the platform.
     */
    public List<String> supportedAddonList() {
        return supportedAddonList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(platformOwner());
        hashCode = 31 * hashCode + Objects.hashCode(platformName());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(platformStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(platformCategory());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(maintainer());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemName());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(programmingLanguages());
        hashCode = 31 * hashCode + Objects.hashCode(frameworks());
        hashCode = 31 * hashCode + Objects.hashCode(customAmiList());
        hashCode = 31 * hashCode + Objects.hashCode(supportedTierList());
        hashCode = 31 * hashCode + Objects.hashCode(supportedAddonList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformDescription)) {
            return false;
        }
        PlatformDescription other = (PlatformDescription) obj;
        return Objects.equals(platformArn(), other.platformArn()) && Objects.equals(platformOwner(), other.platformOwner())
                && Objects.equals(platformName(), other.platformName())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(solutionStackName(), other.solutionStackName())
                && Objects.equals(platformStatusAsString(), other.platformStatusAsString())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateUpdated(), other.dateUpdated())
                && Objects.equals(platformCategory(), other.platformCategory())
                && Objects.equals(description(), other.description()) && Objects.equals(maintainer(), other.maintainer())
                && Objects.equals(operatingSystemName(), other.operatingSystemName())
                && Objects.equals(operatingSystemVersion(), other.operatingSystemVersion())
                && Objects.equals(programmingLanguages(), other.programmingLanguages())
                && Objects.equals(frameworks(), other.frameworks()) && Objects.equals(customAmiList(), other.customAmiList())
                && Objects.equals(supportedTierList(), other.supportedTierList())
                && Objects.equals(supportedAddonList(), other.supportedAddonList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlatformDescription").add("PlatformArn", platformArn()).add("PlatformOwner", platformOwner())
                .add("PlatformName", platformName()).add("PlatformVersion", platformVersion())
                .add("SolutionStackName", solutionStackName()).add("PlatformStatus", platformStatusAsString())
                .add("DateCreated", dateCreated()).add("DateUpdated", dateUpdated()).add("PlatformCategory", platformCategory())
                .add("Description", description()).add("Maintainer", maintainer())
                .add("OperatingSystemName", operatingSystemName()).add("OperatingSystemVersion", operatingSystemVersion())
                .add("ProgrammingLanguages", programmingLanguages()).add("Frameworks", frameworks())
                .add("CustomAmiList", customAmiList()).add("SupportedTierList", supportedTierList())
                .add("SupportedAddonList", supportedAddonList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "PlatformOwner":
            return Optional.ofNullable(clazz.cast(platformOwner()));
        case "PlatformName":
            return Optional.ofNullable(clazz.cast(platformName()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "SolutionStackName":
            return Optional.ofNullable(clazz.cast(solutionStackName()));
        case "PlatformStatus":
            return Optional.ofNullable(clazz.cast(platformStatusAsString()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateUpdated":
            return Optional.ofNullable(clazz.cast(dateUpdated()));
        case "PlatformCategory":
            return Optional.ofNullable(clazz.cast(platformCategory()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Maintainer":
            return Optional.ofNullable(clazz.cast(maintainer()));
        case "OperatingSystemName":
            return Optional.ofNullable(clazz.cast(operatingSystemName()));
        case "OperatingSystemVersion":
            return Optional.ofNullable(clazz.cast(operatingSystemVersion()));
        case "ProgrammingLanguages":
            return Optional.ofNullable(clazz.cast(programmingLanguages()));
        case "Frameworks":
            return Optional.ofNullable(clazz.cast(frameworks()));
        case "CustomAmiList":
            return Optional.ofNullable(clazz.cast(customAmiList()));
        case "SupportedTierList":
            return Optional.ofNullable(clazz.cast(supportedTierList()));
        case "SupportedAddonList":
            return Optional.ofNullable(clazz.cast(supportedAddonList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlatformDescription, T> g) {
        return obj -> g.apply((PlatformDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlatformDescription> {
        /**
         * <p>
         * The ARN of the platform.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * The AWS account ID of the person who created the platform.
         * </p>
         * 
         * @param platformOwner
         *        The AWS account ID of the person who created the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformOwner(String platformOwner);

        /**
         * <p>
         * The name of the platform.
         * </p>
         * 
         * @param platformName
         *        The name of the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformName(String platformName);

        /**
         * <p>
         * The version of the platform.
         * </p>
         * 
         * @param platformVersion
         *        The version of the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The name of the solution stack used by the platform.
         * </p>
         * 
         * @param solutionStackName
         *        The name of the solution stack used by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackName(String solutionStackName);

        /**
         * <p>
         * The status of the platform.
         * </p>
         * 
         * @param platformStatus
         *        The status of the platform.
         * @see PlatformStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformStatus
         */
        Builder platformStatus(String platformStatus);

        /**
         * <p>
         * The status of the platform.
         * </p>
         * 
         * @param platformStatus
         *        The status of the platform.
         * @see PlatformStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformStatus
         */
        Builder platformStatus(PlatformStatus platformStatus);

        /**
         * <p>
         * The date when the platform was created.
         * </p>
         * 
         * @param dateCreated
         *        The date when the platform was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The date when the platform was last updated.
         * </p>
         * 
         * @param dateUpdated
         *        The date when the platform was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateUpdated(Instant dateUpdated);

        /**
         * <p>
         * The category of the platform.
         * </p>
         * 
         * @param platformCategory
         *        The category of the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformCategory(String platformCategory);

        /**
         * <p>
         * The description of the platform.
         * </p>
         * 
         * @param description
         *        The description of the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the maintainer of the platform.
         * </p>
         * 
         * @param maintainer
         *        Information about the maintainer of the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintainer(String maintainer);

        /**
         * <p>
         * The operating system used by the platform.
         * </p>
         * 
         * @param operatingSystemName
         *        The operating system used by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemName(String operatingSystemName);

        /**
         * <p>
         * The version of the operating system used by the platform.
         * </p>
         * 
         * @param operatingSystemVersion
         *        The version of the operating system used by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemVersion(String operatingSystemVersion);

        /**
         * <p>
         * The programming languages supported by the platform.
         * </p>
         * 
         * @param programmingLanguages
         *        The programming languages supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programmingLanguages(Collection<PlatformProgrammingLanguage> programmingLanguages);

        /**
         * <p>
         * The programming languages supported by the platform.
         * </p>
         * 
         * @param programmingLanguages
         *        The programming languages supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programmingLanguages(PlatformProgrammingLanguage... programmingLanguages);

        /**
         * <p>
         * The programming languages supported by the platform.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlatformProgrammingLanguage>.Builder}
         * avoiding the need to create one manually via {@link List<PlatformProgrammingLanguage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlatformProgrammingLanguage>.Builder#build()} is called
         * immediately and its result is passed to {@link #programmingLanguages(List<PlatformProgrammingLanguage>)}.
         * 
         * @param programmingLanguages
         *        a consumer that will call methods on {@link List<PlatformProgrammingLanguage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programmingLanguages(List<PlatformProgrammingLanguage>)
         */
        Builder programmingLanguages(Consumer<PlatformProgrammingLanguage.Builder>... programmingLanguages);

        /**
         * <p>
         * The frameworks supported by the platform.
         * </p>
         * 
         * @param frameworks
         *        The frameworks supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworks(Collection<PlatformFramework> frameworks);

        /**
         * <p>
         * The frameworks supported by the platform.
         * </p>
         * 
         * @param frameworks
         *        The frameworks supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworks(PlatformFramework... frameworks);

        /**
         * <p>
         * The frameworks supported by the platform.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlatformFramework>.Builder} avoiding the
         * need to create one manually via {@link List<PlatformFramework>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlatformFramework>.Builder#build()} is called immediately
         * and its result is passed to {@link #frameworks(List<PlatformFramework>)}.
         * 
         * @param frameworks
         *        a consumer that will call methods on {@link List<PlatformFramework>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworks(List<PlatformFramework>)
         */
        Builder frameworks(Consumer<PlatformFramework.Builder>... frameworks);

        /**
         * <p>
         * The custom AMIs supported by the platform.
         * </p>
         * 
         * @param customAmiList
         *        The custom AMIs supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmiList(Collection<CustomAmi> customAmiList);

        /**
         * <p>
         * The custom AMIs supported by the platform.
         * </p>
         * 
         * @param customAmiList
         *        The custom AMIs supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmiList(CustomAmi... customAmiList);

        /**
         * <p>
         * The custom AMIs supported by the platform.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomAmi>.Builder} avoiding the need to
         * create one manually via {@link List<CustomAmi>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomAmi>.Builder#build()} is called immediately and its
         * result is passed to {@link #customAmiList(List<CustomAmi>)}.
         * 
         * @param customAmiList
         *        a consumer that will call methods on {@link List<CustomAmi>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAmiList(List<CustomAmi>)
         */
        Builder customAmiList(Consumer<CustomAmi.Builder>... customAmiList);

        /**
         * <p>
         * The tiers supported by the platform.
         * </p>
         * 
         * @param supportedTierList
         *        The tiers supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(Collection<String> supportedTierList);

        /**
         * <p>
         * The tiers supported by the platform.
         * </p>
         * 
         * @param supportedTierList
         *        The tiers supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(String... supportedTierList);

        /**
         * <p>
         * The additions supported by the platform.
         * </p>
         * 
         * @param supportedAddonList
         *        The additions supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAddonList(Collection<String> supportedAddonList);

        /**
         * <p>
         * The additions supported by the platform.
         * </p>
         * 
         * @param supportedAddonList
         *        The additions supported by the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedAddonList(String... supportedAddonList);
    }

    static final class BuilderImpl implements Builder {
        private String platformArn;

        private String platformOwner;

        private String platformName;

        private String platformVersion;

        private String solutionStackName;

        private String platformStatus;

        private Instant dateCreated;

        private Instant dateUpdated;

        private String platformCategory;

        private String description;

        private String maintainer;

        private String operatingSystemName;

        private String operatingSystemVersion;

        private List<PlatformProgrammingLanguage> programmingLanguages = DefaultSdkAutoConstructList.getInstance();

        private List<PlatformFramework> frameworks = DefaultSdkAutoConstructList.getInstance();

        private List<CustomAmi> customAmiList = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedTierList = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedAddonList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformDescription model) {
            platformArn(model.platformArn);
            platformOwner(model.platformOwner);
            platformName(model.platformName);
            platformVersion(model.platformVersion);
            solutionStackName(model.solutionStackName);
            platformStatus(model.platformStatus);
            dateCreated(model.dateCreated);
            dateUpdated(model.dateUpdated);
            platformCategory(model.platformCategory);
            description(model.description);
            maintainer(model.maintainer);
            operatingSystemName(model.operatingSystemName);
            operatingSystemVersion(model.operatingSystemVersion);
            programmingLanguages(model.programmingLanguages);
            frameworks(model.frameworks);
            customAmiList(model.customAmiList);
            supportedTierList(model.supportedTierList);
            supportedAddonList(model.supportedAddonList);
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getPlatformOwner() {
            return platformOwner;
        }

        @Override
        public final Builder platformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
            return this;
        }

        public final void setPlatformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
        }

        public final String getPlatformName() {
            return platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getSolutionStackName() {
            return solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformStatusAsString() {
            return platformStatus;
        }

        @Override
        public final Builder platformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
            return this;
        }

        @Override
        public final Builder platformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus == null ? null : platformStatus.toString());
            return this;
        }

        public final void setPlatformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final String getPlatformCategory() {
            return platformCategory;
        }

        @Override
        public final Builder platformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
            return this;
        }

        public final void setPlatformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getMaintainer() {
            return maintainer;
        }

        @Override
        public final Builder maintainer(String maintainer) {
            this.maintainer = maintainer;
            return this;
        }

        public final void setMaintainer(String maintainer) {
            this.maintainer = maintainer;
        }

        public final String getOperatingSystemName() {
            return operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        public final String getOperatingSystemVersion() {
            return operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        public final Collection<PlatformProgrammingLanguage.Builder> getProgrammingLanguages() {
            return programmingLanguages != null ? programmingLanguages.stream().map(PlatformProgrammingLanguage::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder programmingLanguages(Collection<PlatformProgrammingLanguage> programmingLanguages) {
            this.programmingLanguages = PlatformProgrammingLanguagesCopier.copy(programmingLanguages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programmingLanguages(PlatformProgrammingLanguage... programmingLanguages) {
            programmingLanguages(Arrays.asList(programmingLanguages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder programmingLanguages(Consumer<PlatformProgrammingLanguage.Builder>... programmingLanguages) {
            programmingLanguages(Stream.of(programmingLanguages)
                    .map(c -> PlatformProgrammingLanguage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProgrammingLanguages(Collection<PlatformProgrammingLanguage.BuilderImpl> programmingLanguages) {
            this.programmingLanguages = PlatformProgrammingLanguagesCopier.copyFromBuilder(programmingLanguages);
        }

        public final Collection<PlatformFramework.Builder> getFrameworks() {
            return frameworks != null ? frameworks.stream().map(PlatformFramework::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder frameworks(Collection<PlatformFramework> frameworks) {
            this.frameworks = PlatformFrameworksCopier.copy(frameworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworks(PlatformFramework... frameworks) {
            frameworks(Arrays.asList(frameworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworks(Consumer<PlatformFramework.Builder>... frameworks) {
            frameworks(Stream.of(frameworks).map(c -> PlatformFramework.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFrameworks(Collection<PlatformFramework.BuilderImpl> frameworks) {
            this.frameworks = PlatformFrameworksCopier.copyFromBuilder(frameworks);
        }

        public final Collection<CustomAmi.Builder> getCustomAmiList() {
            return customAmiList != null ? customAmiList.stream().map(CustomAmi::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customAmiList(Collection<CustomAmi> customAmiList) {
            this.customAmiList = CustomAmiListCopier.copy(customAmiList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmiList(CustomAmi... customAmiList) {
            customAmiList(Arrays.asList(customAmiList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmiList(Consumer<CustomAmi.Builder>... customAmiList) {
            customAmiList(Stream.of(customAmiList).map(c -> CustomAmi.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCustomAmiList(Collection<CustomAmi.BuilderImpl> customAmiList) {
            this.customAmiList = CustomAmiListCopier.copyFromBuilder(customAmiList);
        }

        public final Collection<String> getSupportedTierList() {
            return supportedTierList;
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String... supportedTierList) {
            supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        public final Collection<String> getSupportedAddonList() {
            return supportedAddonList;
        }

        @Override
        public final Builder supportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAddonList(String... supportedAddonList) {
            supportedAddonList(Arrays.asList(supportedAddonList));
            return this;
        }

        public final void setSupportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
        }

        @Override
        public PlatformDescription build() {
            return new PlatformDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
