/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A lifecycle rule that deletes the oldest application version when the maximum count is exceeded.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaxCountRule implements SdkPojo, Serializable, ToCopyableBuilder<MaxCountRule.Builder, MaxCountRule> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(MaxCountRule::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> MAX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MaxCountRule::maxCount)).setter(setter(Builder::maxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCount").build()).build();

    private static final SdkField<Boolean> DELETE_SOURCE_FROM_S3_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(MaxCountRule::deleteSourceFromS3)).setter(setter(Builder::deleteSourceFromS3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteSourceFromS3").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            MAX_COUNT_FIELD, DELETE_SOURCE_FROM_S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer maxCount;

    private final Boolean deleteSourceFromS3;

    private MaxCountRule(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxCount = builder.maxCount;
        this.deleteSourceFromS3 = builder.deleteSourceFromS3;
    }

    /**
     * <p>
     * Specify <code>true</code> to apply the rule, or <code>false</code> to disable it.
     * </p>
     * 
     * @return Specify <code>true</code> to apply the rule, or <code>false</code> to disable it.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specify the maximum number of application versions to retain.
     * </p>
     * 
     * @return Specify the maximum number of application versions to retain.
     */
    public Integer maxCount() {
        return maxCount;
    }

    /**
     * <p>
     * Set to <code>true</code> to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the
     * application version.
     * </p>
     * 
     * @return Set to <code>true</code> to delete a version's source bundle from Amazon S3 when Elastic Beanstalk
     *         deletes the application version.
     */
    public Boolean deleteSourceFromS3() {
        return deleteSourceFromS3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(deleteSourceFromS3());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaxCountRule)) {
            return false;
        }
        MaxCountRule other = (MaxCountRule) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(maxCount(), other.maxCount())
                && Objects.equals(deleteSourceFromS3(), other.deleteSourceFromS3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MaxCountRule").add("Enabled", enabled()).add("MaxCount", maxCount())
                .add("DeleteSourceFromS3", deleteSourceFromS3()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "MaxCount":
            return Optional.ofNullable(clazz.cast(maxCount()));
        case "DeleteSourceFromS3":
            return Optional.ofNullable(clazz.cast(deleteSourceFromS3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaxCountRule, T> g) {
        return obj -> g.apply((MaxCountRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaxCountRule> {
        /**
         * <p>
         * Specify <code>true</code> to apply the rule, or <code>false</code> to disable it.
         * </p>
         * 
         * @param enabled
         *        Specify <code>true</code> to apply the rule, or <code>false</code> to disable it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specify the maximum number of application versions to retain.
         * </p>
         * 
         * @param maxCount
         *        Specify the maximum number of application versions to retain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCount(Integer maxCount);

        /**
         * <p>
         * Set to <code>true</code> to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes
         * the application version.
         * </p>
         * 
         * @param deleteSourceFromS3
         *        Set to <code>true</code> to delete a version's source bundle from Amazon S3 when Elastic Beanstalk
         *        deletes the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteSourceFromS3(Boolean deleteSourceFromS3);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer maxCount;

        private Boolean deleteSourceFromS3;

        private BuilderImpl() {
        }

        private BuilderImpl(MaxCountRule model) {
            enabled(model.enabled);
            maxCount(model.maxCount);
            deleteSourceFromS3(model.deleteSourceFromS3);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getMaxCount() {
            return maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        public final Boolean getDeleteSourceFromS3() {
            return deleteSourceFromS3;
        }

        @Override
        public final Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
            return this;
        }

        public final void setDeleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
        }

        @Override
        public MaxCountRule build() {
            return new MaxCountRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
