/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The record of a completed or failed managed action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedActionHistoryItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedActionHistoryItem.Builder, ManagedActionHistoryItem> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ManagedActionHistoryItem::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ManagedActionHistoryItem::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> ACTION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ManagedActionHistoryItem::actionDescription)).setter(setter(Builder::actionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionDescription").build()).build();

    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ManagedActionHistoryItem::failureTypeAsString)).setter(setter(Builder::failureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ManagedActionHistoryItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ManagedActionHistoryItem::failureDescription)).setter(setter(Builder::failureDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDescription").build())
            .build();

    private static final SdkField<Instant> EXECUTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ManagedActionHistoryItem::executedTime)).setter(setter(Builder::executedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedTime").build()).build();

    private static final SdkField<Instant> FINISHED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ManagedActionHistoryItem::finishedTime)).setter(setter(Builder::finishedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            ACTION_TYPE_FIELD, ACTION_DESCRIPTION_FIELD, FAILURE_TYPE_FIELD, STATUS_FIELD, FAILURE_DESCRIPTION_FIELD,
            EXECUTED_TIME_FIELD, FINISHED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String actionType;

    private final String actionDescription;

    private final String failureType;

    private final String status;

    private final String failureDescription;

    private final Instant executedTime;

    private final Instant finishedTime;

    private ManagedActionHistoryItem(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionType = builder.actionType;
        this.actionDescription = builder.actionDescription;
        this.failureType = builder.failureType;
        this.status = builder.status;
        this.failureDescription = builder.failureDescription;
        this.executedTime = builder.executedTime;
        this.finishedTime = builder.finishedTime;
    }

    /**
     * <p>
     * A unique identifier for the managed action.
     * </p>
     * 
     * @return A unique identifier for the managed action.
     */
    public String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The type of the managed action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of the managed action.
     * @see ActionType
     */
    public ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of the managed action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of the managed action.
     * @see ActionType
     */
    public String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * A description of the managed action.
     * </p>
     * 
     * @return A description of the managed action.
     */
    public String actionDescription() {
        return actionDescription;
    }

    /**
     * <p>
     * If the action failed, the type of failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link FailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureTypeAsString}.
     * </p>
     * 
     * @return If the action failed, the type of failure.
     * @see FailureType
     */
    public FailureType failureType() {
        return FailureType.fromValue(failureType);
    }

    /**
     * <p>
     * If the action failed, the type of failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureType} will
     * return {@link FailureType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureTypeAsString}.
     * </p>
     * 
     * @return If the action failed, the type of failure.
     * @see FailureType
     */
    public String failureTypeAsString() {
        return failureType;
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionHistoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ActionHistoryStatus
     */
    public ActionHistoryStatus status() {
        return ActionHistoryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionHistoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ActionHistoryStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the action failed, a description of the failure.
     * </p>
     * 
     * @return If the action failed, a description of the failure.
     */
    public String failureDescription() {
        return failureDescription;
    }

    /**
     * <p>
     * The date and time that the action started executing.
     * </p>
     * 
     * @return The date and time that the action started executing.
     */
    public Instant executedTime() {
        return executedTime;
    }

    /**
     * <p>
     * The date and time that the action finished executing.
     * </p>
     * 
     * @return The date and time that the action finished executing.
     */
    public Instant finishedTime() {
        return finishedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureDescription());
        hashCode = 31 * hashCode + Objects.hashCode(executedTime());
        hashCode = 31 * hashCode + Objects.hashCode(finishedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedActionHistoryItem)) {
            return false;
        }
        ManagedActionHistoryItem other = (ManagedActionHistoryItem) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(actionDescription(), other.actionDescription())
                && Objects.equals(failureTypeAsString(), other.failureTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureDescription(), other.failureDescription())
                && Objects.equals(executedTime(), other.executedTime()) && Objects.equals(finishedTime(), other.finishedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ManagedActionHistoryItem").add("ActionId", actionId()).add("ActionType", actionTypeAsString())
                .add("ActionDescription", actionDescription()).add("FailureType", failureTypeAsString())
                .add("Status", statusAsString()).add("FailureDescription", failureDescription())
                .add("ExecutedTime", executedTime()).add("FinishedTime", finishedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "ActionDescription":
            return Optional.ofNullable(clazz.cast(actionDescription()));
        case "FailureType":
            return Optional.ofNullable(clazz.cast(failureTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureDescription":
            return Optional.ofNullable(clazz.cast(failureDescription()));
        case "ExecutedTime":
            return Optional.ofNullable(clazz.cast(executedTime()));
        case "FinishedTime":
            return Optional.ofNullable(clazz.cast(finishedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedActionHistoryItem, T> g) {
        return obj -> g.apply((ManagedActionHistoryItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedActionHistoryItem> {
        /**
         * <p>
         * A unique identifier for the managed action.
         * </p>
         * 
         * @param actionId
         *        A unique identifier for the managed action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The type of the managed action.
         * </p>
         * 
         * @param actionType
         *        The type of the managed action.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of the managed action.
         * </p>
         * 
         * @param actionType
         *        The type of the managed action.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * A description of the managed action.
         * </p>
         * 
         * @param actionDescription
         *        A description of the managed action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDescription(String actionDescription);

        /**
         * <p>
         * If the action failed, the type of failure.
         * </p>
         * 
         * @param failureType
         *        If the action failed, the type of failure.
         * @see FailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureType
         */
        Builder failureType(String failureType);

        /**
         * <p>
         * If the action failed, the type of failure.
         * </p>
         * 
         * @param failureType
         *        If the action failed, the type of failure.
         * @see FailureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureType
         */
        Builder failureType(FailureType failureType);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ActionHistoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionHistoryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ActionHistoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionHistoryStatus
         */
        Builder status(ActionHistoryStatus status);

        /**
         * <p>
         * If the action failed, a description of the failure.
         * </p>
         * 
         * @param failureDescription
         *        If the action failed, a description of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDescription(String failureDescription);

        /**
         * <p>
         * The date and time that the action started executing.
         * </p>
         * 
         * @param executedTime
         *        The date and time that the action started executing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executedTime(Instant executedTime);

        /**
         * <p>
         * The date and time that the action finished executing.
         * </p>
         * 
         * @param finishedTime
         *        The date and time that the action finished executing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishedTime(Instant finishedTime);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String actionType;

        private String actionDescription;

        private String failureType;

        private String status;

        private String failureDescription;

        private Instant executedTime;

        private Instant finishedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedActionHistoryItem model) {
            actionId(model.actionId);
            actionType(model.actionType);
            actionDescription(model.actionDescription);
            failureType(model.failureType);
            status(model.status);
            failureDescription(model.failureDescription);
            executedTime(model.executedTime);
            finishedTime(model.finishedTime);
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionTypeAsString() {
            return actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getActionDescription() {
            return actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getFailureTypeAsString() {
            return failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(FailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionHistoryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureDescription() {
            return failureDescription;
        }

        @Override
        public final Builder failureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        public final void setFailureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
        }

        public final Instant getExecutedTime() {
            return executedTime;
        }

        @Override
        public final Builder executedTime(Instant executedTime) {
            this.executedTime = executedTime;
            return this;
        }

        public final void setExecutedTime(Instant executedTime) {
            this.executedTime = executedTime;
        }

        public final Instant getFinishedTime() {
            return finishedTime;
        }

        @Override
        public final Builder finishedTime(Instant finishedTime) {
            this.finishedTime = finishedTime;
            return this;
        }

        public final void setFinishedTime(Instant finishedTime) {
            this.finishedTime = finishedTime;
        }

        @Override
        public ManagedActionHistoryItem build() {
            return new ManagedActionHistoryItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
