/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result message containing a list of application descriptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationsResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<DescribeApplicationsResponse.Builder, DescribeApplicationsResponse> {
    private static final SdkField<List<ApplicationDescription>> APPLICATIONS_FIELD = SdkField
            .<List<ApplicationDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeApplicationsResponse::applications))
            .setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATIONS_FIELD));

    private final List<ApplicationDescription> applications;

    private DescribeApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applications = builder.applications;
    }

    /**
     * Returns true if the Applications property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasApplications() {
        return applications != null && !(applications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter contains a list of <a>ApplicationDescription</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApplications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This parameter contains a list of <a>ApplicationDescription</a>.
     */
    public List<ApplicationDescription> applications() {
        return applications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsResponse)) {
            return false;
        }
        DescribeApplicationsResponse other = (DescribeApplicationsResponse) obj;
        return Objects.equals(applications(), other.applications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeApplicationsResponse").add("Applications", applications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Applications":
            return Optional.ofNullable(clazz.cast(applications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationsResponse, T> g) {
        return obj -> g.apply((DescribeApplicationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationsResponse> {
        /**
         * <p>
         * This parameter contains a list of <a>ApplicationDescription</a>.
         * </p>
         * 
         * @param applications
         *        This parameter contains a list of <a>ApplicationDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Collection<ApplicationDescription> applications);

        /**
         * <p>
         * This parameter contains a list of <a>ApplicationDescription</a>.
         * </p>
         * 
         * @param applications
         *        This parameter contains a list of <a>ApplicationDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(ApplicationDescription... applications);

        /**
         * <p>
         * This parameter contains a list of <a>ApplicationDescription</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ApplicationDescription>.Builder} avoiding
         * the need to create one manually via {@link List<ApplicationDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #applications(List<ApplicationDescription>)}.
         * 
         * @param applications
         *        a consumer that will call methods on {@link List<ApplicationDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applications(List<ApplicationDescription>)
         */
        Builder applications(Consumer<ApplicationDescription.Builder>... applications);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<ApplicationDescription> applications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsResponse model) {
            super(model);
            applications(model.applications);
        }

        public final Collection<ApplicationDescription.Builder> getApplications() {
            return applications != null ? applications.stream().map(ApplicationDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applications(Collection<ApplicationDescription> applications) {
            this.applications = ApplicationDescriptionListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(ApplicationDescription... applications) {
            applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<ApplicationDescription.Builder>... applications) {
            applications(Stream.of(applications).map(c -> ApplicationDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setApplications(Collection<ApplicationDescription.BuilderImpl> applications) {
            this.applications = ApplicationDescriptionListCopier.copyFromBuilder(applications);
        }

        @Override
        public DescribeApplicationsResponse build() {
            return new DescribeApplicationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
