/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an application version deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Deployment implements SdkPojo, Serializable, ToCopyableBuilder<Deployment.Builder, Deployment> {
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::versionLabel)).setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final SdkField<Long> DEPLOYMENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Deployment::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> DEPLOYMENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Deployment::deploymentTime)).setter(setter(Builder::deploymentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_LABEL_FIELD,
            DEPLOYMENT_ID_FIELD, STATUS_FIELD, DEPLOYMENT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String versionLabel;

    private final Long deploymentId;

    private final String status;

    private final Instant deploymentTime;

    private Deployment(BuilderImpl builder) {
        this.versionLabel = builder.versionLabel;
        this.deploymentId = builder.deploymentId;
        this.status = builder.status;
        this.deploymentTime = builder.deploymentTime;
    }

    /**
     * <p>
     * The version label of the application version in the deployment.
     * </p>
     * 
     * @return The version label of the application version in the deployment.
     */
    public String versionLabel() {
        return versionLabel;
    }

    /**
     * <p>
     * The ID of the deployment. This number increases by one each time that you deploy source code or change instance
     * configuration settings.
     * </p>
     * 
     * @return The ID of the deployment. This number increases by one each time that you deploy source code or change
     *         instance configuration settings.
     */
    public Long deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The status of the deployment:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>In Progress</code> : The deployment is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deployed</code> : The deployment succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> : The deployment failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the deployment:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>In Progress</code> : The deployment is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deployed</code> : The deployment succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> : The deployment failed.
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * For in-progress deployments, the time that the deployment started.
     * </p>
     * <p>
     * For completed deployments, the time that the deployment ended.
     * </p>
     * 
     * @return For in-progress deployments, the time that the deployment started.</p>
     *         <p>
     *         For completed deployments, the time that the deployment ended.
     */
    public Instant deploymentTime() {
        return deploymentTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment) obj;
        return Objects.equals(versionLabel(), other.versionLabel()) && Objects.equals(deploymentId(), other.deploymentId())
                && Objects.equals(status(), other.status()) && Objects.equals(deploymentTime(), other.deploymentTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Deployment").add("VersionLabel", versionLabel()).add("DeploymentId", deploymentId())
                .add("Status", status()).add("DeploymentTime", deploymentTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "DeploymentTime":
            return Optional.ofNullable(clazz.cast(deploymentTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Deployment> {
        /**
         * <p>
         * The version label of the application version in the deployment.
         * </p>
         * 
         * @param versionLabel
         *        The version label of the application version in the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);

        /**
         * <p>
         * The ID of the deployment. This number increases by one each time that you deploy source code or change
         * instance configuration settings.
         * </p>
         * 
         * @param deploymentId
         *        The ID of the deployment. This number increases by one each time that you deploy source code or change
         *        instance configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(Long deploymentId);

        /**
         * <p>
         * The status of the deployment:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>In Progress</code> : The deployment is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deployed</code> : The deployment succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> : The deployment failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the deployment:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>In Progress</code> : The deployment is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deployed</code> : The deployment succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> : The deployment failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * For in-progress deployments, the time that the deployment started.
         * </p>
         * <p>
         * For completed deployments, the time that the deployment ended.
         * </p>
         * 
         * @param deploymentTime
         *        For in-progress deployments, the time that the deployment started.</p>
         *        <p>
         *        For completed deployments, the time that the deployment ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentTime(Instant deploymentTime);
    }

    static final class BuilderImpl implements Builder {
        private String versionLabel;

        private Long deploymentId;

        private String status;

        private Instant deploymentTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            versionLabel(model.versionLabel);
            deploymentId(model.deploymentId);
            status(model.status);
            deploymentTime(model.deploymentTime);
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final Long getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(Long deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(Long deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getDeploymentTime() {
            return deploymentTime;
        }

        @Override
        public final Builder deploymentTime(Instant deploymentTime) {
            this.deploymentTime = deploymentTime;
            return this;
        }

        public final void setDeploymentTime(Instant deploymentTime) {
            this.deploymentTime = deploymentTime;
        }

        @Override
        public Deployment build() {
            return new Deployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
