/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to create a new platform version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlatformVersionRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<CreatePlatformVersionRequest.Builder, CreatePlatformVersionRequest> {
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePlatformVersionRequest::platformName)).setter(setter(Builder::platformName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePlatformVersionRequest::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<S3Location> PLATFORM_DEFINITION_BUNDLE_FIELD = SdkField
            .<S3Location> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreatePlatformVersionRequest::platformDefinitionBundle))
            .setter(setter(Builder::platformDefinitionBundle)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformDefinitionBundle").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePlatformVersionRequest::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<List<ConfigurationOptionSetting>> OPTION_SETTINGS_FIELD = SdkField
            .<List<ConfigurationOptionSetting>> builder(MarshallingType.LIST)
            .getter(getter(CreatePlatformVersionRequest::optionSettings))
            .setter(setter(Builder::optionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationOptionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationOptionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreatePlatformVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_NAME_FIELD,
            PLATFORM_VERSION_FIELD, PLATFORM_DEFINITION_BUNDLE_FIELD, ENVIRONMENT_NAME_FIELD, OPTION_SETTINGS_FIELD, TAGS_FIELD));

    private final String platformName;

    private final String platformVersion;

    private final S3Location platformDefinitionBundle;

    private final String environmentName;

    private final List<ConfigurationOptionSetting> optionSettings;

    private final List<Tag> tags;

    private CreatePlatformVersionRequest(BuilderImpl builder) {
        super(builder);
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.platformDefinitionBundle = builder.platformDefinitionBundle;
        this.environmentName = builder.environmentName;
        this.optionSettings = builder.optionSettings;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of your custom platform.
     * </p>
     * 
     * @return The name of your custom platform.
     */
    public String platformName() {
        return platformName;
    }

    /**
     * <p>
     * The number, such as 1.0.2, for the new platform version.
     * </p>
     * 
     * @return The number, such as 1.0.2, for the new platform version.
     */
    public String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The location of the platform definition archive in Amazon S3.
     * </p>
     * 
     * @return The location of the platform definition archive in Amazon S3.
     */
    public S3Location platformDefinitionBundle() {
        return platformDefinitionBundle;
    }

    /**
     * <p>
     * The name of the builder environment.
     * </p>
     * 
     * @return The name of the builder environment.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * Returns true if the OptionSettings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOptionSettings() {
        return optionSettings != null && !(optionSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration option settings to apply to the builder environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOptionSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The configuration option settings to apply to the builder environment.
     */
    public List<ConfigurationOptionSetting> optionSettings() {
        return optionSettings;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tags applied to the new platform version.
     * </p>
     * <p>
     * Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the
     * platform version don't inherit the tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the tags applied to the new platform version.</p>
     *         <p>
     *         Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the
     *         platform version don't inherit the tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(platformName());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platformDefinitionBundle());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(optionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformVersionRequest)) {
            return false;
        }
        CreatePlatformVersionRequest other = (CreatePlatformVersionRequest) obj;
        return Objects.equals(platformName(), other.platformName()) && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(platformDefinitionBundle(), other.platformDefinitionBundle())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(optionSettings(), other.optionSettings()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePlatformVersionRequest").add("PlatformName", platformName())
                .add("PlatformVersion", platformVersion()).add("PlatformDefinitionBundle", platformDefinitionBundle())
                .add("EnvironmentName", environmentName()).add("OptionSettings", optionSettings()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformName":
            return Optional.ofNullable(clazz.cast(platformName()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "PlatformDefinitionBundle":
            return Optional.ofNullable(clazz.cast(platformDefinitionBundle()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "OptionSettings":
            return Optional.ofNullable(clazz.cast(optionSettings()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlatformVersionRequest, T> g) {
        return obj -> g.apply((CreatePlatformVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePlatformVersionRequest> {
        /**
         * <p>
         * The name of your custom platform.
         * </p>
         * 
         * @param platformName
         *        The name of your custom platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformName(String platformName);

        /**
         * <p>
         * The number, such as 1.0.2, for the new platform version.
         * </p>
         * 
         * @param platformVersion
         *        The number, such as 1.0.2, for the new platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The location of the platform definition archive in Amazon S3.
         * </p>
         * 
         * @param platformDefinitionBundle
         *        The location of the platform definition archive in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDefinitionBundle(S3Location platformDefinitionBundle);

        /**
         * <p>
         * The location of the platform definition archive in Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #platformDefinitionBundle(S3Location)}.
         * 
         * @param platformDefinitionBundle
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformDefinitionBundle(S3Location)
         */
        default Builder platformDefinitionBundle(Consumer<S3Location.Builder> platformDefinitionBundle) {
            return platformDefinitionBundle(S3Location.builder().applyMutation(platformDefinitionBundle).build());
        }

        /**
         * <p>
         * The name of the builder environment.
         * </p>
         * 
         * @param environmentName
         *        The name of the builder environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The configuration option settings to apply to the builder environment.
         * </p>
         * 
         * @param optionSettings
         *        The configuration option settings to apply to the builder environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings);

        /**
         * <p>
         * The configuration option settings to apply to the builder environment.
         * </p>
         * 
         * @param optionSettings
         *        The configuration option settings to apply to the builder environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(ConfigurationOptionSetting... optionSettings);

        /**
         * <p>
         * The configuration option settings to apply to the builder environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigurationOptionSetting>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigurationOptionSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationOptionSetting>.Builder#build()} is called
         * immediately and its result is passed to {@link #optionSettings(List<ConfigurationOptionSetting>)}.
         * 
         * @param optionSettings
         *        a consumer that will call methods on {@link List<ConfigurationOptionSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionSettings(List<ConfigurationOptionSetting>)
         */
        Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings);

        /**
         * <p>
         * Specifies the tags applied to the new platform version.
         * </p>
         * <p>
         * Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the
         * platform version don't inherit the tags.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the new platform version.</p>
         *        <p>
         *        Elastic Beanstalk applies these tags only to the platform version. Environments that you create using
         *        the platform version don't inherit the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the tags applied to the new platform version.
         * </p>
         * <p>
         * Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the
         * platform version don't inherit the tags.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the new platform version.</p>
         *        <p>
         *        Elastic Beanstalk applies these tags only to the platform version. Environments that you create using
         *        the platform version don't inherit the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the tags applied to the new platform version.
         * </p>
         * <p>
         * Elastic Beanstalk applies these tags only to the platform version. Environments that you create using the
         * platform version don't inherit the tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String platformName;

        private String platformVersion;

        private S3Location platformDefinitionBundle;

        private String environmentName;

        private List<ConfigurationOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformVersionRequest model) {
            super(model);
            platformName(model.platformName);
            platformVersion(model.platformVersion);
            platformDefinitionBundle(model.platformDefinitionBundle);
            environmentName(model.environmentName);
            optionSettings(model.optionSettings);
            tags(model.tags);
        }

        public final String getPlatformName() {
            return platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final S3Location.Builder getPlatformDefinitionBundle() {
            return platformDefinitionBundle != null ? platformDefinitionBundle.toBuilder() : null;
        }

        @Override
        public final Builder platformDefinitionBundle(S3Location platformDefinitionBundle) {
            this.platformDefinitionBundle = platformDefinitionBundle;
            return this;
        }

        public final void setPlatformDefinitionBundle(S3Location.BuilderImpl platformDefinitionBundle) {
            this.platformDefinitionBundle = platformDefinitionBundle != null ? platformDefinitionBundle.build() : null;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Collection<ConfigurationOptionSetting.Builder> getOptionSettings() {
            return optionSettings != null ? optionSettings.stream().map(ConfigurationOptionSetting::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting... optionSettings) {
            optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<ConfigurationOptionSetting.Builder>... optionSettings) {
            optionSettings(Stream.of(optionSettings).map(c -> ConfigurationOptionSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlatformVersionRequest build() {
            return new CreatePlatformVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
