/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Results message indicating whether a CNAME is available.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckDnsAvailabilityRequest extends ElasticBeanstalkRequest implements
        ToCopyableBuilder<CheckDnsAvailabilityRequest.Builder, CheckDnsAvailabilityRequest> {
    private static final SdkField<String> CNAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CheckDnsAvailabilityRequest::cnamePrefix)).setter(setter(Builder::cnamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CNAMEPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CNAME_PREFIX_FIELD));

    private final String cnamePrefix;

    private CheckDnsAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.cnamePrefix = builder.cnamePrefix;
    }

    /**
     * <p>
     * The prefix used when this CNAME is reserved.
     * </p>
     * 
     * @return The prefix used when this CNAME is reserved.
     */
    public String cnamePrefix() {
        return cnamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cnamePrefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDnsAvailabilityRequest)) {
            return false;
        }
        CheckDnsAvailabilityRequest other = (CheckDnsAvailabilityRequest) obj;
        return Objects.equals(cnamePrefix(), other.cnamePrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CheckDnsAvailabilityRequest").add("CNAMEPrefix", cnamePrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CNAMEPrefix":
            return Optional.ofNullable(clazz.cast(cnamePrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckDnsAvailabilityRequest, T> g) {
        return obj -> g.apply((CheckDnsAvailabilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticBeanstalkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckDnsAvailabilityRequest> {
        /**
         * <p>
         * The prefix used when this CNAME is reserved.
         * </p>
         * 
         * @param cnamePrefix
         *        The prefix used when this CNAME is reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cnamePrefix(String cnamePrefix);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticBeanstalkRequest.BuilderImpl implements Builder {
        private String cnamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDnsAvailabilityRequest model) {
            super(model);
            cnamePrefix(model.cnamePrefix);
        }

        public final String getCnamePrefix() {
            return cnamePrefix;
        }

        @Override
        public final Builder cnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
            return this;
        }

        public final void setCnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckDnsAvailabilityRequest build() {
            return new CheckDnsAvailabilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
