/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationDescription.Builder, ApplicationDescription> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationDescription::applicationArn)).setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationDescription::applicationName)).setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationDescription::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ApplicationDescription::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ApplicationDescription::dateUpdated)).setter(setter(Builder::dateUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()).build();

    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ApplicationDescription::versions))
            .setter(setter(Builder::versions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONFIGURATION_TEMPLATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ApplicationDescription::configurationTemplates))
            .setter(setter(Builder::configurationTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApplicationResourceLifecycleConfig> RESOURCE_LIFECYCLE_CONFIG_FIELD = SdkField
            .<ApplicationResourceLifecycleConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(ApplicationDescription::resourceLifecycleConfig)).setter(setter(Builder::resourceLifecycleConfig))
            .constructor(ApplicationResourceLifecycleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLifecycleConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_NAME_FIELD, DESCRIPTION_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, VERSIONS_FIELD,
            CONFIGURATION_TEMPLATES_FIELD, RESOURCE_LIFECYCLE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationArn;

    private final String applicationName;

    private final String description;

    private final Instant dateCreated;

    private final Instant dateUpdated;

    private final List<String> versions;

    private final List<String> configurationTemplates;

    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private ApplicationDescription(BuilderImpl builder) {
        this.applicationArn = builder.applicationArn;
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.versions = builder.versions;
        this.configurationTemplates = builder.configurationTemplates;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * User-defined description of the application.
     * </p>
     * 
     * @return User-defined description of the application.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date when the application was created.
     * </p>
     * 
     * @return The date when the application was created.
     */
    public Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date when the application was last modified.
     * </p>
     * 
     * @return The date when the application was last modified.
     */
    public Instant dateUpdated() {
        return dateUpdated;
    }

    /**
     * Returns true if the Versions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVersions() {
        return versions != null && !(versions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the versions for this application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the versions for this application.
     */
    public List<String> versions() {
        return versions;
    }

    /**
     * Returns true if the ConfigurationTemplates property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConfigurationTemplates() {
        return configurationTemplates != null && !(configurationTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the configuration templates associated with this application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurationTemplates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the configuration templates associated with this application.
     */
    public List<String> configurationTemplates() {
        return configurationTemplates;
    }

    /**
     * <p>
     * The lifecycle settings for the application.
     * </p>
     * 
     * @return The lifecycle settings for the application.
     */
    public ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return resourceLifecycleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(versions());
        hashCode = 31 * hashCode + Objects.hashCode(configurationTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLifecycleConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDescription)) {
            return false;
        }
        ApplicationDescription other = (ApplicationDescription) obj;
        return Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(description(), other.description()) && Objects.equals(dateCreated(), other.dateCreated())
                && Objects.equals(dateUpdated(), other.dateUpdated()) && Objects.equals(versions(), other.versions())
                && Objects.equals(configurationTemplates(), other.configurationTemplates())
                && Objects.equals(resourceLifecycleConfig(), other.resourceLifecycleConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationDescription").add("ApplicationArn", applicationArn())
                .add("ApplicationName", applicationName()).add("Description", description()).add("DateCreated", dateCreated())
                .add("DateUpdated", dateUpdated()).add("Versions", versions())
                .add("ConfigurationTemplates", configurationTemplates())
                .add("ResourceLifecycleConfig", resourceLifecycleConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateUpdated":
            return Optional.ofNullable(clazz.cast(dateUpdated()));
        case "Versions":
            return Optional.ofNullable(clazz.cast(versions()));
        case "ConfigurationTemplates":
            return Optional.ofNullable(clazz.cast(configurationTemplates()));
        case "ResourceLifecycleConfig":
            return Optional.ofNullable(clazz.cast(resourceLifecycleConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationDescription, T> g) {
        return obj -> g.apply((ApplicationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationDescription> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param applicationName
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * User-defined description of the application.
         * </p>
         * 
         * @param description
         *        User-defined description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date when the application was created.
         * </p>
         * 
         * @param dateCreated
         *        The date when the application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The date when the application was last modified.
         * </p>
         * 
         * @param dateUpdated
         *        The date when the application was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateUpdated(Instant dateUpdated);

        /**
         * <p>
         * The names of the versions for this application.
         * </p>
         * 
         * @param versions
         *        The names of the versions for this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(Collection<String> versions);

        /**
         * <p>
         * The names of the versions for this application.
         * </p>
         * 
         * @param versions
         *        The names of the versions for this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versions(String... versions);

        /**
         * <p>
         * The names of the configuration templates associated with this application.
         * </p>
         * 
         * @param configurationTemplates
         *        The names of the configuration templates associated with this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationTemplates(Collection<String> configurationTemplates);

        /**
         * <p>
         * The names of the configuration templates associated with this application.
         * </p>
         * 
         * @param configurationTemplates
         *        The names of the configuration templates associated with this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationTemplates(String... configurationTemplates);

        /**
         * <p>
         * The lifecycle settings for the application.
         * </p>
         * 
         * @param resourceLifecycleConfig
         *        The lifecycle settings for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig);

        /**
         * <p>
         * The lifecycle settings for the application.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationResourceLifecycleConfig.Builder}
         * avoiding the need to create one manually via {@link ApplicationResourceLifecycleConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationResourceLifecycleConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceLifecycleConfig(ApplicationResourceLifecycleConfig)}.
         * 
         * @param resourceLifecycleConfig
         *        a consumer that will call methods on {@link ApplicationResourceLifecycleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceLifecycleConfig(ApplicationResourceLifecycleConfig)
         */
        default Builder resourceLifecycleConfig(Consumer<ApplicationResourceLifecycleConfig.Builder> resourceLifecycleConfig) {
            return resourceLifecycleConfig(ApplicationResourceLifecycleConfig.builder().applyMutation(resourceLifecycleConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String applicationArn;

        private String applicationName;

        private String description;

        private Instant dateCreated;

        private Instant dateUpdated;

        private List<String> versions = DefaultSdkAutoConstructList.getInstance();

        private List<String> configurationTemplates = DefaultSdkAutoConstructList.getInstance();

        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDescription model) {
            applicationArn(model.applicationArn);
            applicationName(model.applicationName);
            description(model.description);
            dateCreated(model.dateCreated);
            dateUpdated(model.dateUpdated);
            versions(model.versions);
            configurationTemplates(model.configurationTemplates);
            resourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final Collection<String> getVersions() {
            return versions;
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = VersionLabelsListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String... versions) {
            versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = VersionLabelsListCopier.copy(versions);
        }

        public final Collection<String> getConfigurationTemplates() {
            return configurationTemplates;
        }

        @Override
        public final Builder configurationTemplates(Collection<String> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplateNamesListCopier.copy(configurationTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationTemplates(String... configurationTemplates) {
            configurationTemplates(Arrays.asList(configurationTemplates));
            return this;
        }

        public final void setConfigurationTemplates(Collection<String> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplateNamesListCopier.copy(configurationTemplates);
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return resourceLifecycleConfig != null ? resourceLifecycleConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        @Override
        public ApplicationDescription build() {
            return new ApplicationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
