/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteApplicationVersionRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DeleteApplicationVersionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteApplicationVersionRequest.getter(DeleteApplicationVersionRequest::applicationName)).setter(DeleteApplicationVersionRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteApplicationVersionRequest.getter(DeleteApplicationVersionRequest::versionLabel)).setter(DeleteApplicationVersionRequest.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final SdkField<Boolean> DELETE_SOURCE_BUNDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeleteApplicationVersionRequest.getter(DeleteApplicationVersionRequest::deleteSourceBundle)).setter(DeleteApplicationVersionRequest.setter(Builder::deleteSourceBundle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteSourceBundle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, VERSION_LABEL_FIELD, DELETE_SOURCE_BUNDLE_FIELD));
    private final String applicationName;
    private final String versionLabel;
    private final Boolean deleteSourceBundle;

    private DeleteApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.deleteSourceBundle = builder.deleteSourceBundle;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public Boolean deleteSourceBundle() {
        return this.deleteSourceBundle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteSourceBundle());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationVersionRequest)) {
            return false;
        }
        DeleteApplicationVersionRequest other = (DeleteApplicationVersionRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.deleteSourceBundle(), other.deleteSourceBundle());
    }

    public String toString() {
        return ToString.builder((String)"DeleteApplicationVersionRequest").add("ApplicationName", (Object)this.applicationName()).add("VersionLabel", (Object)this.versionLabel()).add("DeleteSourceBundle", (Object)this.deleteSourceBundle()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
            case "DeleteSourceBundle": {
                return Optional.ofNullable(clazz.cast(this.deleteSourceBundle()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationVersionRequest, T> g) {
        return obj -> g.apply((DeleteApplicationVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private Boolean deleteSourceBundle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationVersionRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.deleteSourceBundle(model.deleteSourceBundle);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final Boolean getDeleteSourceBundle() {
            return this.deleteSourceBundle;
        }

        @Override
        public final Builder deleteSourceBundle(Boolean deleteSourceBundle) {
            this.deleteSourceBundle = deleteSourceBundle;
            return this;
        }

        public final void setDeleteSourceBundle(Boolean deleteSourceBundle) {
            this.deleteSourceBundle = deleteSourceBundle;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationVersionRequest build() {
            return new DeleteApplicationVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteApplicationVersionRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder deleteSourceBundle(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

