/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;

public class DeleteEnvironmentConfigurationRequestMarshaller
implements Marshaller<Request<DeleteEnvironmentConfigurationRequest>, DeleteEnvironmentConfigurationRequest> {
    public Request<DeleteEnvironmentConfigurationRequest> marshall(DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) {
        if (deleteEnvironmentConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteEnvironmentConfigurationRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DeleteEnvironmentConfiguration");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteEnvironmentConfigurationRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)deleteEnvironmentConfigurationRequest.applicationName()));
        }
        if (deleteEnvironmentConfigurationRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)deleteEnvironmentConfigurationRequest.environmentName()));
        }
        return request;
    }
}

