/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticbeanstalk.model.AvailableSolutionStackDetailsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.AvailableSolutionStackNamesListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAvailableSolutionStacksResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ListAvailableSolutionStacksResponse> {
    private final List<String> solutionStacks;
    private final List<SolutionStackDescription> solutionStackDetails;

    private ListAvailableSolutionStacksResponse(BuilderImpl builder) {
        super(builder);
        this.solutionStacks = builder.solutionStacks;
        this.solutionStackDetails = builder.solutionStackDetails;
    }

    public List<String> solutionStacks() {
        return this.solutionStacks;
    }

    public List<SolutionStackDescription> solutionStackDetails() {
        return this.solutionStackDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStacks());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableSolutionStacksResponse)) {
            return false;
        }
        ListAvailableSolutionStacksResponse other = (ListAvailableSolutionStacksResponse)((Object)obj);
        return Objects.equals(this.solutionStacks(), other.solutionStacks()) && Objects.equals(this.solutionStackDetails(), other.solutionStackDetails());
    }

    public String toString() {
        return ToString.builder((String)"ListAvailableSolutionStacksResponse").add("SolutionStacks", this.solutionStacks()).add("SolutionStackDetails", this.solutionStackDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SolutionStacks": {
                return Optional.of(clazz.cast(this.solutionStacks()));
            }
            case "SolutionStackDetails": {
                return Optional.of(clazz.cast(this.solutionStackDetails()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<String> solutionStacks;
        private List<SolutionStackDescription> solutionStackDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableSolutionStacksResponse model) {
            this.solutionStacks(model.solutionStacks);
            this.solutionStackDetails(model.solutionStackDetails);
        }

        public final Collection<String> getSolutionStacks() {
            return this.solutionStacks;
        }

        @Override
        public final Builder solutionStacks(Collection<String> solutionStacks) {
            this.solutionStacks = AvailableSolutionStackNamesListCopier.copy(solutionStacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStacks(String ... solutionStacks) {
            this.solutionStacks(Arrays.asList(solutionStacks));
            return this;
        }

        public final void setSolutionStacks(Collection<String> solutionStacks) {
            this.solutionStacks = AvailableSolutionStackNamesListCopier.copy(solutionStacks);
        }

        public final Collection<SolutionStackDescription.Builder> getSolutionStackDetails() {
            return this.solutionStackDetails != null ? (Collection)this.solutionStackDetails.stream().map(SolutionStackDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder solutionStackDetails(Collection<SolutionStackDescription> solutionStackDetails) {
            this.solutionStackDetails = AvailableSolutionStackDetailsListCopier.copy(solutionStackDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionStackDetails(SolutionStackDescription ... solutionStackDetails) {
            this.solutionStackDetails(Arrays.asList(solutionStackDetails));
            return this;
        }

        public final void setSolutionStackDetails(Collection<SolutionStackDescription.BuilderImpl> solutionStackDetails) {
            this.solutionStackDetails = AvailableSolutionStackDetailsListCopier.copyFromBuilder(solutionStackDetails);
        }

        @Override
        public ListAvailableSolutionStacksResponse build() {
            return new ListAvailableSolutionStacksResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, ListAvailableSolutionStacksResponse> {
        public Builder solutionStacks(Collection<String> var1);

        public Builder solutionStacks(String ... var1);

        public Builder solutionStackDetails(Collection<SolutionStackDescription> var1);

        public Builder solutionStackDetails(SolutionStackDescription ... var1);
    }
}

