/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeEventsRequest> {
    private final String applicationName;
    private final String versionLabel;
    private final String templateName;
    private final String environmentId;
    private final String environmentName;
    private final String platformArn;
    private final String requestId;
    private final String severity;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeEventsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.platformArn = builder.platformArn;
        this.requestId = builder.requestId;
        this.severity = builder.severity;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String templateName() {
        return this.templateName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String requestId() {
        return this.requestId;
    }

    public EventSeverity severity() {
        return EventSeverity.fromValue(this.severity);
    }

    public String severityString() {
        return this.severity;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsRequest)) {
            return false;
        }
        DescribeEventsRequest other = (DescribeEventsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.severityString(), other.severityString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventsRequest").add("ApplicationName", (Object)this.applicationName()).add("VersionLabel", (Object)this.versionLabel()).add("TemplateName", (Object)this.templateName()).add("EnvironmentId", (Object)this.environmentId()).add("EnvironmentName", (Object)this.environmentName()).add("PlatformArn", (Object)this.platformArn()).add("RequestId", (Object)this.requestId()).add("Severity", (Object)this.severityString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("MaxRecords", (Object)this.maxRecords()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "TemplateName": {
                return Optional.of(clazz.cast(this.templateName()));
            }
            case "EnvironmentId": {
                return Optional.of(clazz.cast(this.environmentId()));
            }
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "PlatformArn": {
                return Optional.of(clazz.cast(this.platformArn()));
            }
            case "RequestId": {
                return Optional.of(clazz.cast(this.requestId()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severityString()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private String templateName;
        private String environmentId;
        private String environmentName;
        private String platformArn;
        private String requestId;
        private String severity;
        private Instant startTime;
        private Instant endTime;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsRequest model) {
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.templateName(model.templateName);
            this.environmentId(model.environmentId);
            this.environmentName(model.environmentName);
            this.platformArn(model.platformArn);
            this.requestId(model.requestId);
            this.severity(model.severity);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(EventSeverity severity) {
            this.severity(severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventsRequest build() {
            return new DescribeEventsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, DescribeEventsRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder templateName(String var1);

        public Builder environmentId(String var1);

        public Builder environmentName(String var1);

        public Builder platformArn(String var1);

        public Builder requestId(String var1);

        public Builder severity(String var1);

        public Builder severity(EventSeverity var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

