/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLink;
import software.amazon.awssdk.services.elasticbeanstalk.transform.EnvironmentLinkUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.EnvironmentResourcesDescriptionUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.EnvironmentTierUnmarshaller;

public class EnvironmentDescriptionUnmarshaller
implements Unmarshaller<EnvironmentDescription, StaxUnmarshallerContext> {
    private static final EnvironmentDescriptionUnmarshaller INSTANCE = new EnvironmentDescriptionUnmarshaller();

    public EnvironmentDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        EnvironmentDescription.Builder environmentDescription;
        block24: {
            environmentDescription = EnvironmentDescription.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<EnvironmentLink> environmentLinks = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    environmentDescription.environmentLinks(environmentLinks);
                    break block24;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("EnvironmentName", targetDepth)) {
                        environmentDescription.environmentName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EnvironmentId", targetDepth)) {
                        environmentDescription.environmentId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ApplicationName", targetDepth)) {
                        environmentDescription.applicationName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VersionLabel", targetDepth)) {
                        environmentDescription.versionLabel(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SolutionStackName", targetDepth)) {
                        environmentDescription.solutionStackName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PlatformArn", targetDepth)) {
                        environmentDescription.platformArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TemplateName", targetDepth)) {
                        environmentDescription.templateName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        environmentDescription.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EndpointURL", targetDepth)) {
                        environmentDescription.endpointURL(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CNAME", targetDepth)) {
                        environmentDescription.cname(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DateCreated", targetDepth)) {
                        environmentDescription.dateCreated(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DateUpdated", targetDepth)) {
                        environmentDescription.dateUpdated(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        environmentDescription.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AbortableOperationInProgress", targetDepth)) {
                        environmentDescription.abortableOperationInProgress(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Health", targetDepth)) {
                        environmentDescription.health(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("HealthStatus", targetDepth)) {
                        environmentDescription.healthStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Resources", targetDepth)) {
                        environmentDescription.resources(EnvironmentResourcesDescriptionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tier", targetDepth)) {
                        environmentDescription.tier(EnvironmentTierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EnvironmentLinks", targetDepth)) {
                        environmentLinks = new ArrayList<EnvironmentLink>();
                        continue;
                    }
                    if (context.testExpression("EnvironmentLinks/member", targetDepth)) {
                        environmentLinks.add(EnvironmentLinkUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("EnvironmentArn", targetDepth)) continue;
                    environmentDescription.environmentArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            environmentDescription.environmentLinks(environmentLinks);
        }
        return (EnvironmentDescription)environmentDescription.build();
    }

    public static EnvironmentDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

