/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;

public class DeleteApplicationVersionRequestMarshaller
implements Marshaller<Request<DeleteApplicationVersionRequest>, DeleteApplicationVersionRequest> {
    public Request<DeleteApplicationVersionRequest> marshall(DeleteApplicationVersionRequest deleteApplicationVersionRequest) {
        if (deleteApplicationVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteApplicationVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DeleteApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteApplicationVersionRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)deleteApplicationVersionRequest.applicationName()));
        }
        if (deleteApplicationVersionRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)deleteApplicationVersionRequest.versionLabel()));
        }
        if (deleteApplicationVersionRequest.deleteSourceBundle() != null) {
            request.addParameter("DeleteSourceBundle", StringUtils.fromBoolean((Boolean)deleteApplicationVersionRequest.deleteSourceBundle()));
        }
        return request;
    }
}

