/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TerminateEnvironmentRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, TerminateEnvironmentRequest> {
    private final String environmentId;
    private final String environmentName;
    private final Boolean terminateResources;
    private final Boolean forceTerminate;

    private TerminateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.terminateResources = builder.terminateResources;
        this.forceTerminate = builder.forceTerminate;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public Boolean terminateResources() {
        return this.terminateResources;
    }

    public Boolean forceTerminate() {
        return this.forceTerminate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceTerminate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateEnvironmentRequest)) {
            return false;
        }
        TerminateEnvironmentRequest other = (TerminateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.terminateResources(), other.terminateResources()) && Objects.equals(this.forceTerminate(), other.forceTerminate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.terminateResources() != null) {
            sb.append("TerminateResources: ").append(this.terminateResources()).append(",");
        }
        if (this.forceTerminate() != null) {
            sb.append("ForceTerminate: ").append(this.forceTerminate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentId": {
                return Optional.of(clazz.cast(this.environmentId()));
            }
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "TerminateResources": {
                return Optional.of(clazz.cast(this.terminateResources()));
            }
            case "ForceTerminate": {
                return Optional.of(clazz.cast(this.forceTerminate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private String environmentName;
        private Boolean terminateResources;
        private Boolean forceTerminate;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateEnvironmentRequest model) {
            this.environmentId(model.environmentId);
            this.environmentName(model.environmentName);
            this.terminateResources(model.terminateResources);
            this.forceTerminate(model.forceTerminate);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Boolean getTerminateResources() {
            return this.terminateResources;
        }

        @Override
        public final Builder terminateResources(Boolean terminateResources) {
            this.terminateResources = terminateResources;
            return this;
        }

        public final void setTerminateResources(Boolean terminateResources) {
            this.terminateResources = terminateResources;
        }

        public final Boolean getForceTerminate() {
            return this.forceTerminate;
        }

        @Override
        public final Builder forceTerminate(Boolean forceTerminate) {
            this.forceTerminate = forceTerminate;
            return this;
        }

        public final void setForceTerminate(Boolean forceTerminate) {
            this.forceTerminate = forceTerminate;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TerminateEnvironmentRequest build() {
            return new TerminateEnvironmentRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, TerminateEnvironmentRequest> {
        public Builder environmentId(String var1);

        public Builder environmentName(String var1);

        public Builder terminateResources(Boolean var1);

        public Builder forceTerminate(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

