/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackFileTypeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SolutionStackDescription
implements ToCopyableBuilder<Builder, SolutionStackDescription> {
    private final String solutionStackName;
    private final List<String> permittedFileTypes;

    private SolutionStackDescription(BuilderImpl builder) {
        this.solutionStackName = builder.solutionStackName;
        this.permittedFileTypes = builder.permittedFileTypes;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public List<String> permittedFileTypes() {
        return this.permittedFileTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.permittedFileTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionStackDescription)) {
            return false;
        }
        SolutionStackDescription other = (SolutionStackDescription)obj;
        return Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.permittedFileTypes(), other.permittedFileTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.permittedFileTypes() != null) {
            sb.append("PermittedFileTypes: ").append(this.permittedFileTypes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SolutionStackName": {
                return Optional.of(clazz.cast(this.solutionStackName()));
            }
            case "PermittedFileTypes": {
                return Optional.of(clazz.cast(this.permittedFileTypes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String solutionStackName;
        private List<String> permittedFileTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionStackDescription model) {
            this.solutionStackName(model.solutionStackName);
            this.permittedFileTypes(model.permittedFileTypes);
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final Collection<String> getPermittedFileTypes() {
            return this.permittedFileTypes;
        }

        @Override
        public final Builder permittedFileTypes(Collection<String> permittedFileTypes) {
            this.permittedFileTypes = SolutionStackFileTypeListCopier.copy(permittedFileTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedFileTypes(String ... permittedFileTypes) {
            this.permittedFileTypes(Arrays.asList(permittedFileTypes));
            return this;
        }

        public final void setPermittedFileTypes(Collection<String> permittedFileTypes) {
            this.permittedFileTypes = SolutionStackFileTypeListCopier.copy(permittedFileTypes);
        }

        public SolutionStackDescription build() {
            return new SolutionStackDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SolutionStackDescription> {
        public Builder solutionStackName(String var1);

        public Builder permittedFileTypes(Collection<String> var1);

        public Builder permittedFileTypes(String ... var1);
    }
}

