/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionsSpecifierListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;
import software.amazon.awssdk.services.elasticbeanstalk.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateEnvironmentRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentRequest> {
    private final String applicationName;
    private final String environmentName;
    private final String groupName;
    private final String description;
    private final String cnamePrefix;
    private final EnvironmentTier tier;
    private final List<Tag> tags;
    private final String versionLabel;
    private final String templateName;
    private final String solutionStackName;
    private final String platformArn;
    private final List<ConfigurationOptionSetting> optionSettings;
    private final List<OptionSpecification> optionsToRemove;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.environmentName = builder.environmentName;
        this.groupName = builder.groupName;
        this.description = builder.description;
        this.cnamePrefix = builder.cnamePrefix;
        this.tier = builder.tier;
        this.tags = builder.tags;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.optionSettings = builder.optionSettings;
        this.optionsToRemove = builder.optionsToRemove;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String groupName() {
        return this.groupName;
    }

    public String description() {
        return this.description;
    }

    public String cnamePrefix() {
        return this.cnamePrefix;
    }

    public EnvironmentTier tier() {
        return this.tier;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String templateName() {
        return this.templateName;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public List<OptionSpecification> optionsToRemove() {
        return this.optionsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cnamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cnamePrefix(), other.cnamePrefix()) && Objects.equals(this.tier(), other.tier()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.optionSettings(), other.optionSettings()) && Objects.equals(this.optionsToRemove(), other.optionsToRemove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.cnamePrefix() != null) {
            sb.append("CNAMEPrefix: ").append(this.cnamePrefix()).append(",");
        }
        if (this.tier() != null) {
            sb.append("Tier: ").append(this.tier()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        if (this.optionsToRemove() != null) {
            sb.append("OptionsToRemove: ").append(this.optionsToRemove()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "CNAMEPrefix": {
                return Optional.of(clazz.cast(this.cnamePrefix()));
            }
            case "Tier": {
                return Optional.of(clazz.cast(this.tier()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "TemplateName": {
                return Optional.of(clazz.cast(this.templateName()));
            }
            case "SolutionStackName": {
                return Optional.of(clazz.cast(this.solutionStackName()));
            }
            case "PlatformArn": {
                return Optional.of(clazz.cast(this.platformArn()));
            }
            case "OptionSettings": {
                return Optional.of(clazz.cast(this.optionSettings()));
            }
            case "OptionsToRemove": {
                return Optional.of(clazz.cast(this.optionsToRemove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String environmentName;
        private String groupName;
        private String description;
        private String cnamePrefix;
        private EnvironmentTier tier;
        private List<Tag> tags;
        private String versionLabel;
        private String templateName;
        private String solutionStackName;
        private String platformArn;
        private List<ConfigurationOptionSetting> optionSettings;
        private List<OptionSpecification> optionsToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            this.applicationName(model.applicationName);
            this.environmentName(model.environmentName);
            this.groupName(model.groupName);
            this.description(model.description);
            this.cnamePrefix(model.cnamePrefix);
            this.tier(model.tier);
            this.tags(model.tags);
            this.versionLabel(model.versionLabel);
            this.templateName(model.templateName);
            this.solutionStackName(model.solutionStackName);
            this.platformArn(model.platformArn);
            this.optionSettings(model.optionSettings);
            this.optionsToRemove(model.optionsToRemove);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCNAMEPrefix() {
            return this.cnamePrefix;
        }

        @Override
        public final Builder cnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
            return this;
        }

        public final void setCNAMEPrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
        }

        public final EnvironmentTier.Builder getTier() {
            return this.tier != null ? this.tier.toBuilder() : null;
        }

        @Override
        public final Builder tier(EnvironmentTier tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(EnvironmentTier.BuilderImpl tier) {
            this.tier = tier != null ? tier.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final Collection<ConfigurationOptionSetting.Builder> getOptionSettings() {
            return this.optionSettings != null ? (Collection)this.optionSettings.stream().map(ConfigurationOptionSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        public final Collection<OptionSpecification.Builder> getOptionsToRemove() {
            return this.optionsToRemove != null ? (Collection)this.optionsToRemove.stream().map(OptionSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToRemove(OptionSpecification ... optionsToRemove) {
            this.optionsToRemove(Arrays.asList(optionsToRemove));
            return this;
        }

        public final void setOptionsToRemove(Collection<OptionSpecification.BuilderImpl> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copyFromBuilder(optionsToRemove);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, CreateEnvironmentRequest> {
        public Builder applicationName(String var1);

        public Builder environmentName(String var1);

        public Builder groupName(String var1);

        public Builder description(String var1);

        public Builder cnamePrefix(String var1);

        public Builder tier(EnvironmentTier var1);

        default public Builder tier(Consumer<EnvironmentTier.Builder> tier) {
            return this.tier((EnvironmentTier)((EnvironmentTier.Builder)EnvironmentTier.builder().apply(tier)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder versionLabel(String var1);

        public Builder templateName(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);

        public Builder optionsToRemove(Collection<OptionSpecification> var1);

        public Builder optionsToRemove(OptionSpecification ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

