/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.ComputeType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BuildConfiguration
implements ToCopyableBuilder<Builder, BuildConfiguration> {
    private final String artifactName;
    private final String codeBuildServiceRole;
    private final String computeType;
    private final String image;
    private final Integer timeoutInMinutes;

    private BuildConfiguration(BuilderImpl builder) {
        this.artifactName = builder.artifactName;
        this.codeBuildServiceRole = builder.codeBuildServiceRole;
        this.computeType = builder.computeType;
        this.image = builder.image;
        this.timeoutInMinutes = builder.timeoutInMinutes;
    }

    public String artifactName() {
        return this.artifactName;
    }

    public String codeBuildServiceRole() {
        return this.codeBuildServiceRole;
    }

    public ComputeType computeType() {
        return ComputeType.fromValue(this.computeType);
    }

    public String computeTypeString() {
        return this.computeType;
    }

    public String image() {
        return this.image;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactName());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeBuildServiceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildConfiguration)) {
            return false;
        }
        BuildConfiguration other = (BuildConfiguration)obj;
        return Objects.equals(this.artifactName(), other.artifactName()) && Objects.equals(this.codeBuildServiceRole(), other.codeBuildServiceRole()) && Objects.equals(this.computeTypeString(), other.computeTypeString()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.artifactName() != null) {
            sb.append("ArtifactName: ").append(this.artifactName()).append(",");
        }
        if (this.codeBuildServiceRole() != null) {
            sb.append("CodeBuildServiceRole: ").append(this.codeBuildServiceRole()).append(",");
        }
        if (this.computeTypeString() != null) {
            sb.append("ComputeType: ").append(this.computeTypeString()).append(",");
        }
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.timeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.timeoutInMinutes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArtifactName": {
                return Optional.of(clazz.cast(this.artifactName()));
            }
            case "CodeBuildServiceRole": {
                return Optional.of(clazz.cast(this.codeBuildServiceRole()));
            }
            case "ComputeType": {
                return Optional.of(clazz.cast(this.computeTypeString()));
            }
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "TimeoutInMinutes": {
                return Optional.of(clazz.cast(this.timeoutInMinutes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String artifactName;
        private String codeBuildServiceRole;
        private String computeType;
        private String image;
        private Integer timeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildConfiguration model) {
            this.artifactName(model.artifactName);
            this.codeBuildServiceRole(model.codeBuildServiceRole);
            this.computeType(model.computeType);
            this.image(model.image);
            this.timeoutInMinutes(model.timeoutInMinutes);
        }

        public final String getArtifactName() {
            return this.artifactName;
        }

        @Override
        public final Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public final void setArtifactName(String artifactName) {
            this.artifactName = artifactName;
        }

        public final String getCodeBuildServiceRole() {
            return this.codeBuildServiceRole;
        }

        @Override
        public final Builder codeBuildServiceRole(String codeBuildServiceRole) {
            this.codeBuildServiceRole = codeBuildServiceRole;
            return this;
        }

        public final void setCodeBuildServiceRole(String codeBuildServiceRole) {
            this.codeBuildServiceRole = codeBuildServiceRole;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType.toString());
            return this;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public BuildConfiguration build() {
            return new BuildConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BuildConfiguration> {
        public Builder artifactName(String var1);

        public Builder codeBuildServiceRole(String var1);

        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder image(String var1);

        public Builder timeoutInMinutes(Integer var1);
    }
}

