/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;

public class RequestEnvironmentInfoRequestMarshaller
implements Marshaller<Request<RequestEnvironmentInfoRequest>, RequestEnvironmentInfoRequest> {
    public Request<RequestEnvironmentInfoRequest> marshall(RequestEnvironmentInfoRequest requestEnvironmentInfoRequest) {
        if (requestEnvironmentInfoRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestEnvironmentInfoRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "RequestEnvironmentInfo");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (requestEnvironmentInfoRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)requestEnvironmentInfoRequest.environmentId()));
        }
        if (requestEnvironmentInfoRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)requestEnvironmentInfoRequest.environmentName()));
        }
        if (requestEnvironmentInfoRequest.infoTypeString() != null) {
            request.addParameter("InfoType", StringUtils.fromString((String)requestEnvironmentInfoRequest.infoTypeString()));
        }
        return request;
    }
}

