/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.ListPlatformVersionsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter;

public class ListPlatformVersionsRequestMarshaller
implements Marshaller<Request<ListPlatformVersionsRequest>, ListPlatformVersionsRequest> {
    public Request<ListPlatformVersionsRequest> marshall(ListPlatformVersionsRequest listPlatformVersionsRequest) {
        if (listPlatformVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPlatformVersionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "ListPlatformVersions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<PlatformFilter> filtersList = listPlatformVersionsRequest.filters();
        if (filtersList != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (PlatformFilter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.type() != null) {
                        request.addParameter("Filters.member." + filtersListIndex + ".Type", StringUtils.fromString((String)filtersListValue.type()));
                    }
                    if (filtersListValue.operator() != null) {
                        request.addParameter("Filters.member." + filtersListIndex + ".Operator", StringUtils.fromString((String)filtersListValue.operator()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.member." + filtersListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.member." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (listPlatformVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)listPlatformVersionsRequest.maxRecords()));
        }
        if (listPlatformVersionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listPlatformVersionsRequest.nextToken()));
        }
        return request;
    }
}

