/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;

public class DescribeApplicationVersionsRequestMarshaller
implements Marshaller<Request<DescribeApplicationVersionsRequest>, DescribeApplicationVersionsRequest> {
    public Request<DescribeApplicationVersionsRequest> marshall(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) {
        List<String> versionLabelsList;
        if (describeApplicationVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeApplicationVersionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeApplicationVersions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeApplicationVersionsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeApplicationVersionsRequest.applicationName()));
        }
        if ((versionLabelsList = describeApplicationVersionsRequest.versionLabels()) != null) {
            if (!versionLabelsList.isEmpty()) {
                int versionLabelsListIndex = 1;
                for (String versionLabelsListValue : versionLabelsList) {
                    if (versionLabelsListValue != null) {
                        request.addParameter("VersionLabels.member." + versionLabelsListIndex, StringUtils.fromString((String)versionLabelsListValue));
                    }
                    ++versionLabelsListIndex;
                }
            } else {
                request.addParameter("VersionLabels", "");
            }
        }
        if (describeApplicationVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeApplicationVersionsRequest.maxRecords()));
        }
        if (describeApplicationVersionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeApplicationVersionsRequest.nextToken()));
        }
        return request;
    }
}

