/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreatePlatformVersionRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;

public class CreatePlatformVersionRequestMarshaller
implements Marshaller<Request<CreatePlatformVersionRequest>, CreatePlatformVersionRequest> {
    public Request<CreatePlatformVersionRequest> marshall(CreatePlatformVersionRequest createPlatformVersionRequest) {
        List<ConfigurationOptionSetting> optionSettingsList;
        S3Location platformDefinitionBundle;
        if (createPlatformVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlatformVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CreatePlatformVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlatformVersionRequest.platformName() != null) {
            request.addParameter("PlatformName", StringUtils.fromString((String)createPlatformVersionRequest.platformName()));
        }
        if (createPlatformVersionRequest.platformVersion() != null) {
            request.addParameter("PlatformVersion", StringUtils.fromString((String)createPlatformVersionRequest.platformVersion()));
        }
        if ((platformDefinitionBundle = createPlatformVersionRequest.platformDefinitionBundle()) != null) {
            if (platformDefinitionBundle.s3Bucket() != null) {
                request.addParameter("PlatformDefinitionBundle.S3Bucket", StringUtils.fromString((String)platformDefinitionBundle.s3Bucket()));
            }
            if (platformDefinitionBundle.s3Key() != null) {
                request.addParameter("PlatformDefinitionBundle.S3Key", StringUtils.fromString((String)platformDefinitionBundle.s3Key()));
            }
        }
        if (createPlatformVersionRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)createPlatformVersionRequest.environmentName()));
        }
        if ((optionSettingsList = createPlatformVersionRequest.optionSettings()) != null) {
            if (!optionSettingsList.isEmpty()) {
                int optionSettingsListIndex = 1;
                for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                    if (optionSettingsListValue.resourceName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.resourceName()));
                    }
                    if (optionSettingsListValue.namespace() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.namespace()));
                    }
                    if (optionSettingsListValue.optionName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.optionName()));
                    }
                    if (optionSettingsListValue.value() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.value()));
                    }
                    ++optionSettingsListIndex;
                }
            } else {
                request.addParameter("OptionSettings", "");
            }
        }
        return request;
    }
}

