/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3Location
implements ToCopyableBuilder<Builder, S3Location> {
    private final String s3Bucket;
    private final String s3Key;

    private S3Location(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.s3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.s3Bucket()).append(",");
        }
        if (this.s3Key() != null) {
            sb.append("S3Key: ").append(this.s3Key()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Bucket": {
                return Optional.of(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.of(clazz.cast(this.s3Key()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Bucket;
        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public S3Location build() {
            return new S3Location(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Location> {
        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);
    }
}

