/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.EventDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EventDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventsResponse> {
    private final List<EventDescription> events;
    private final String nextToken;

    private DescribeEventsResponse(BuilderImpl builder) {
        this.events = builder.events;
        this.nextToken = builder.nextToken;
    }

    public List<EventDescription> events() {
        return this.events;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResponse)) {
            return false;
        }
        DescribeEventsResponse other = (DescribeEventsResponse)((Object)obj);
        return Objects.equals(this.events(), other.events()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Events": {
                return Optional.of(clazz.cast(this.events()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<EventDescription> events;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsResponse model) {
            this.events(model.events);
            this.nextToken(model.nextToken);
        }

        public final Collection<EventDescription.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(EventDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<EventDescription> events) {
            this.events = EventDescriptionListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(EventDescription ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<EventDescription.BuilderImpl> events) {
            this.events = EventDescriptionListCopier.copyFromBuilder(events);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEventsResponse build() {
            return new DescribeEventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventsResponse> {
        public Builder events(Collection<EventDescription> var1);

        public Builder events(EventDescription ... var1);

        public Builder nextToken(String var1);
    }
}

