/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionPossibleValuesCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionValueType;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionRestrictionRegex;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfigurationOptionDescription
implements ToCopyableBuilder<Builder, ConfigurationOptionDescription> {
    private final String namespace;
    private final String name;
    private final String defaultValue;
    private final String changeSeverity;
    private final Boolean userDefined;
    private final String valueType;
    private final List<String> valueOptions;
    private final Integer minValue;
    private final Integer maxValue;
    private final Integer maxLength;
    private final OptionRestrictionRegex regex;

    private ConfigurationOptionDescription(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.defaultValue = builder.defaultValue;
        this.changeSeverity = builder.changeSeverity;
        this.userDefined = builder.userDefined;
        this.valueType = builder.valueType;
        this.valueOptions = builder.valueOptions;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.maxLength = builder.maxLength;
        this.regex = builder.regex;
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String changeSeverity() {
        return this.changeSeverity;
    }

    public Boolean userDefined() {
        return this.userDefined;
    }

    public ConfigurationOptionValueType valueType() {
        return ConfigurationOptionValueType.fromValue(this.valueType);
    }

    public String valueTypeString() {
        return this.valueType;
    }

    public List<String> valueOptions() {
        return this.valueOptions;
    }

    public Integer minValue() {
        return this.minValue;
    }

    public Integer maxValue() {
        return this.maxValue;
    }

    public Integer maxLength() {
        return this.maxLength;
    }

    public OptionRestrictionRegex regex() {
        return this.regex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(this.userDefined());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.regex());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationOptionDescription)) {
            return false;
        }
        ConfigurationOptionDescription other = (ConfigurationOptionDescription)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.changeSeverity(), other.changeSeverity()) && Objects.equals(this.userDefined(), other.userDefined()) && Objects.equals(this.valueTypeString(), other.valueTypeString()) && Objects.equals(this.valueOptions(), other.valueOptions()) && Objects.equals(this.minValue(), other.minValue()) && Objects.equals(this.maxValue(), other.maxValue()) && Objects.equals(this.maxLength(), other.maxLength()) && Objects.equals(this.regex(), other.regex());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        if (this.changeSeverity() != null) {
            sb.append("ChangeSeverity: ").append(this.changeSeverity()).append(",");
        }
        if (this.userDefined() != null) {
            sb.append("UserDefined: ").append(this.userDefined()).append(",");
        }
        if (this.valueTypeString() != null) {
            sb.append("ValueType: ").append(this.valueTypeString()).append(",");
        }
        if (this.valueOptions() != null) {
            sb.append("ValueOptions: ").append(this.valueOptions()).append(",");
        }
        if (this.minValue() != null) {
            sb.append("MinValue: ").append(this.minValue()).append(",");
        }
        if (this.maxValue() != null) {
            sb.append("MaxValue: ").append(this.maxValue()).append(",");
        }
        if (this.maxLength() != null) {
            sb.append("MaxLength: ").append(this.maxLength()).append(",");
        }
        if (this.regex() != null) {
            sb.append("Regex: ").append(this.regex()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.of(clazz.cast(this.namespace()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DefaultValue": {
                return Optional.of(clazz.cast(this.defaultValue()));
            }
            case "ChangeSeverity": {
                return Optional.of(clazz.cast(this.changeSeverity()));
            }
            case "UserDefined": {
                return Optional.of(clazz.cast(this.userDefined()));
            }
            case "ValueType": {
                return Optional.of(clazz.cast(this.valueTypeString()));
            }
            case "ValueOptions": {
                return Optional.of(clazz.cast(this.valueOptions()));
            }
            case "MinValue": {
                return Optional.of(clazz.cast(this.minValue()));
            }
            case "MaxValue": {
                return Optional.of(clazz.cast(this.maxValue()));
            }
            case "MaxLength": {
                return Optional.of(clazz.cast(this.maxLength()));
            }
            case "Regex": {
                return Optional.of(clazz.cast(this.regex()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String name;
        private String defaultValue;
        private String changeSeverity;
        private Boolean userDefined;
        private String valueType;
        private List<String> valueOptions;
        private Integer minValue;
        private Integer maxValue;
        private Integer maxLength;
        private OptionRestrictionRegex regex;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationOptionDescription model) {
            this.namespace(model.namespace);
            this.name(model.name);
            this.defaultValue(model.defaultValue);
            this.changeSeverity(model.changeSeverity);
            this.userDefined(model.userDefined);
            this.valueType(model.valueType);
            this.valueOptions(model.valueOptions);
            this.minValue(model.minValue);
            this.maxValue(model.maxValue);
            this.maxLength(model.maxLength);
            this.regex(model.regex);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getChangeSeverity() {
            return this.changeSeverity;
        }

        @Override
        public final Builder changeSeverity(String changeSeverity) {
            this.changeSeverity = changeSeverity;
            return this;
        }

        public final void setChangeSeverity(String changeSeverity) {
            this.changeSeverity = changeSeverity;
        }

        public final Boolean getUserDefined() {
            return this.userDefined;
        }

        @Override
        public final Builder userDefined(Boolean userDefined) {
            this.userDefined = userDefined;
            return this;
        }

        public final void setUserDefined(Boolean userDefined) {
            this.userDefined = userDefined;
        }

        public final String getValueType() {
            return this.valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(ConfigurationOptionValueType valueType) {
            this.valueType(valueType.toString());
            return this;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        public final Collection<String> getValueOptions() {
            return this.valueOptions;
        }

        @Override
        public final Builder valueOptions(Collection<String> valueOptions) {
            this.valueOptions = ConfigurationOptionPossibleValuesCopier.copy(valueOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueOptions(String ... valueOptions) {
            this.valueOptions(Arrays.asList(valueOptions));
            return this;
        }

        public final void setValueOptions(Collection<String> valueOptions) {
            this.valueOptions = ConfigurationOptionPossibleValuesCopier.copy(valueOptions);
        }

        public final Integer getMinValue() {
            return this.minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        public final Integer getMaxValue() {
            return this.maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        public final Integer getMaxLength() {
            return this.maxLength;
        }

        @Override
        public final Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        public final OptionRestrictionRegex.Builder getRegex() {
            return this.regex != null ? this.regex.toBuilder() : null;
        }

        @Override
        public final Builder regex(OptionRestrictionRegex regex) {
            this.regex = regex;
            return this;
        }

        public final void setRegex(OptionRestrictionRegex.BuilderImpl regex) {
            this.regex = regex != null ? regex.build() : null;
        }

        public ConfigurationOptionDescription build() {
            return new ConfigurationOptionDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfigurationOptionDescription> {
        public Builder namespace(String var1);

        public Builder name(String var1);

        public Builder defaultValue(String var1);

        public Builder changeSeverity(String var1);

        public Builder userDefined(Boolean var1);

        public Builder valueType(String var1);

        public Builder valueType(ConfigurationOptionValueType var1);

        public Builder valueOptions(Collection<String> var1);

        public Builder valueOptions(String ... var1);

        public Builder minValue(Integer var1);

        public Builder maxValue(Integer var1);

        public Builder maxLength(Integer var1);

        public Builder regex(OptionRestrictionRegex var1);

        default public Builder regex(Consumer<OptionRestrictionRegex.Builder> regex) {
            return this.regex((OptionRestrictionRegex)((OptionRestrictionRegex.Builder)OptionRestrictionRegex.builder().apply(regex)).build());
        }
    }
}

